/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.pac4j.core.context.WebContext;
import org.springframework.web.servlet.ModelAndView;

public abstract class BaseOAuth20AuthorizationResponseBuilder<T extends OAuth20ConfigurationContext>
implements OAuth20AuthorizationResponseBuilder {
    protected final T configurationContext;
    protected final OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder;

    public ModelAndView build(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseMode, String redirectUrl, Map<String, String> parameters) throws Exception {
        return this.authorizationModelAndViewBuilder.build(registeredService, responseMode, redirectUrl, parameters);
    }

    public Optional<OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder> toAuthorizationRequest(WebContext context, Authentication authentication, Service service, OAuthRegisteredService registeredService) {
        return Optional.of(OAuth20AuthorizationRequest.builder().clientId(((OAuth20ConfigurationContext)this.configurationContext).getRequestParameterResolver().resolveRequestParameter(context, "client_id").map(String::valueOf).orElse("")).url(context.getRequestURL()).responseType(((OAuth20ConfigurationContext)this.configurationContext).getRequestParameterResolver().resolveRequestParameter(context, "response_type").map(String::valueOf).orElse("")).grantType(((OAuth20ConfigurationContext)this.configurationContext).getRequestParameterResolver().resolveRequestParameter(context, "grant_type").map(String::valueOf).orElse("")));
    }

    @Generated
    public BaseOAuth20AuthorizationResponseBuilder(T configurationContext, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        this.configurationContext = configurationContext;
        this.authorizationModelAndViewBuilder = authorizationModelAndViewBuilder;
    }
}

