/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenAuthorizationCodeGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.OAuth20UnauthorizedScopeRequestException;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenRefreshTokenGrantRequestExtractor
extends AccessTokenAuthorizationCodeGrantRequestExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenRefreshTokenGrantRequestExtractor.class);

    public AccessTokenRefreshTokenGrantRequestExtractor(OAuth20ConfigurationContext oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    @Override
    public boolean supports(WebContext context) {
        String grantType = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    @Override
    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.REFRESH_TOKEN;
    }

    @Override
    protected String getOAuthParameterName() {
        return "refresh_token";
    }

    @Override
    protected AccessTokenRequestContext extractInternal(WebContext context, AccessTokenRequestContext.AccessTokenRequestContextBuilder builder) {
        OAuthRegisteredService registeredService = this.getOAuthRegisteredServiceBy(context);
        if (registeredService == null) {
            throw new UnauthorizedServiceException("Unable to locate service in registry ");
        }
        boolean shouldRenewRefreshToken = registeredService.isGenerateRefreshToken() && registeredService.isRenewRefreshToken();
        builder.generateRefreshToken(shouldRenewRefreshToken);
        builder.expireOldRefreshToken(shouldRenewRefreshToken);
        return super.extractInternal(context, builder);
    }

    @Override
    protected OAuthRegisteredService getOAuthRegisteredServiceBy(WebContext context) {
        String clientId = this.getRegisteredServiceIdentifierFromRequest(context);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), clientId);
        LOGGER.debug("Located registered service [{}]", (Object)registeredService);
        return registeredService;
    }

    @Override
    protected String getRegisteredServiceIdentifierFromRequest(WebContext context) {
        return (String)this.getConfigurationContext().getRequestParameterResolver().resolveClientIdAndClientSecret(context, this.getConfigurationContext().getSessionStore()).getLeft();
    }

    @Override
    protected Set<String> extractRequestedScopesByToken(Set<String> requestedScopes, OAuth20Token token, WebContext context) {
        if (!requestedScopes.isEmpty() && !requestedScopes.equals(token.getScopes())) {
            LOGGER.error("Requested scopes [{}] exceed the granted scopes [{}] for token [{}]", new Object[]{requestedScopes, token.getScopes(), token.getId()});
            throw new OAuth20UnauthorizedScopeRequestException(token.getId());
        }
        return new TreeSet<String>(token.getScopes());
    }
}

