/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20ClientIdClientSecretCredential;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20ClientIdClientSecretAuthenticator
implements Authenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ClientIdClientSecretAuthenticator.class);
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final TicketRegistry ticketRegistry;
    private final PrincipalResolver principalResolver;
    private final OAuth20RequestParameterResolver requestParameterResolver;
    private final OAuth20ClientSecretValidator clientSecretValidator;

    public void validate(Credentials credentials, WebContext webContext, SessionStore sessionStore) throws CredentialsException {
        LOGGER.debug("Authenticating credential [{}]", (Object)credentials);
        UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
        String id = upc.getUsername();
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, id);
        AuditableContext audit = AuditableContext.builder().registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        if (!accessResult.isExecutionFailure() && this.canAuthenticate(webContext)) {
            WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId());
            this.validateCredentials(upc, registeredService, webContext, sessionStore);
            OAuth20ClientIdClientSecretCredential credential = new OAuth20ClientIdClientSecretCredential(upc.getUsername(), upc.getPassword());
            Principal principal = this.principalResolver.resolve((Credential)credential);
            RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)registeredService).service((Service)service).principal(principal).build();
            Map attributes = registeredService.getAttributeReleasePolicy().getAttributes(context);
            CommonProfile profile = new CommonProfile();
            if (principal instanceof NullPrincipal) {
                LOGGER.debug("No principal was resolved. Falling back to the username [{}] from the credentials.", (Object)id);
                profile.setId(id);
            } else {
                String username = registeredService.getUsernameAttributeProvider().resolveUsername(principal, (Service)service, (RegisteredService)registeredService);
                profile.setId(username);
            }
            profile.addAttribute("client_id", (Object)id);
            LOGGER.debug("Created profile id [{}]", (Object)profile.getId());
            profile.addAttributes(attributes);
            LOGGER.debug("Authenticated user profile [{}]", (Object)profile);
            credentials.setUserProfile((UserProfile)profile);
        }
    }

    protected void validateCredentials(UsernamePasswordCredentials credentials, OAuthRegisteredService registeredService, WebContext context, SessionStore sessionStore) {
        if (!this.clientSecretValidator.validate(registeredService, credentials.getPassword())) {
            throw new CredentialsException("Invalid client credentials provided registered service: " + registeredService.getName());
        }
    }

    protected boolean canAuthenticate(WebContext context) {
        Optional grantType = context.getRequestParameter("grant_type");
        if (grantType.isPresent() && OAuth20Utils.isGrantType((String)grantType.get(), OAuth20GrantTypes.PASSWORD)) {
            LOGGER.debug("Skipping Client credential authentication to use password authentication");
            return false;
        }
        if (grantType.isPresent() && OAuth20Utils.isGrantType((String)grantType.get(), OAuth20GrantTypes.REFRESH_TOKEN) && context.getRequestParameter("client_id").isPresent() && context.getRequestParameter("client_secret").isEmpty()) {
            LOGGER.debug("Skipping client credential authentication to use refresh token authentication");
            return false;
        }
        Optional code = context.getRequestParameter("code");
        if (code.isPresent()) {
            LOGGER.debug("Checking if the OAuth code issued contains code challenge");
            OAuth20Code token = (OAuth20Code)FunctionUtils.doAndHandle(() -> {
                OAuth20Code state = (OAuth20Code)this.ticketRegistry.getTicket((String)code.get(), OAuth20Code.class);
                return state == null || state.isExpired() ? null : state;
            });
            if (token != null && StringUtils.isNotEmpty((CharSequence)token.getCodeChallenge())) {
                LOGGER.debug("The OAuth code [{}] issued contains code challenge which requires PKCE Authentication", code.get());
                return false;
            }
        }
        return true;
    }

    @Generated
    public OAuth20ClientIdClientSecretAuthenticator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer, TicketRegistry ticketRegistry, PrincipalResolver principalResolver, OAuth20RequestParameterResolver requestParameterResolver, OAuth20ClientSecretValidator clientSecretValidator) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.ticketRegistry = ticketRegistry;
        this.principalResolver = principalResolver;
        this.requestParameterResolver = requestParameterResolver;
        this.clientSecretValidator = clientSecretValidator;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceServiceFactory() {
        return this.webApplicationServiceServiceFactory;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public PrincipalResolver getPrincipalResolver() {
        return this.principalResolver;
    }

    @Generated
    public OAuth20RequestParameterResolver getRequestParameterResolver() {
        return this.requestParameterResolver;
    }

    @Generated
    public OAuth20ClientSecretValidator getClientSecretValidator() {
        return this.clientSecretValidator;
    }
}

