/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.PullCorrelationRuleEntity;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.rules.PullCorrelationRule;
import org.apache.syncope.core.provisioning.api.rules.PullMatch;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional(readOnly=true)
public class InboundMatcher {
    protected static final Logger LOG = LoggerFactory.getLogger(InboundMatcher.class);
    protected final UserDAO userDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final GroupDAO groupDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final RealmDAO realmDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final ImplementationDAO implementationDAO;
    protected final VirAttrHandler virAttrHandler;
    protected final IntAttrNameParser intAttrNameParser;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final Map<String, PullCorrelationRule> perContextPullCorrelationRules = new ConcurrentHashMap<String, PullCorrelationRule>();

    public InboundMatcher(UserDAO userDAO, AnyObjectDAO anyObjectDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, RealmDAO realmDAO, VirSchemaDAO virSchemaDAO, ImplementationDAO implementationDAO, VirAttrHandler virAttrHandler, IntAttrNameParser intAttrNameParser, AnyUtilsFactory anyUtilsFactory) {
        this.userDAO = userDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.groupDAO = groupDAO;
        this.anySearchDAO = anySearchDAO;
        this.realmDAO = realmDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.implementationDAO = implementationDAO;
        this.virAttrHandler = virAttrHandler;
        this.intAttrNameParser = intAttrNameParser;
        this.anyUtilsFactory = anyUtilsFactory;
    }

    public Optional<PullMatch> match(AnyType anyType, String nameValue, ExternalResource resource, Connector connector) {
        Optional provision = resource.getProvisionByAnyType(anyType.getKey());
        if (provision.isEmpty()) {
            return Optional.empty();
        }
        Stream<Item> mapItems = Stream.concat(((Provision)provision.get()).getMapping().getItems().stream(), this.virSchemaDAO.find(resource.getKey(), anyType.getKey()).stream().map(VirSchema::asLinkingMappingItem));
        final ArrayList found = new ArrayList();
        try {
            Name nameAttr = new Name(nameValue);
            connector.search(new ObjectClass(((Provision)provision.get()).getObjectClass()), ((Provision)provision.get()).isIgnoreCaseMatch() ? FilterBuilder.equalsIgnoreCase((Attribute)nameAttr) : FilterBuilder.equalTo((Attribute)nameAttr), new SearchResultsHandler(){

                public void handleResult(SearchResult result) {
                }

                public boolean handle(ConnectorObject connectorObject) {
                    return found.add(connectorObject);
                }
            }, MappingUtils.buildOperationOptions(mapItems, new String[0]));
        }
        catch (Throwable t) {
            LOG.warn("While searching for {} ...", (Object)nameValue, (Object)t);
        }
        Optional<PullMatch> result = Optional.empty();
        if (found.isEmpty()) {
            LOG.debug("No {} found on {} with {} {}", new Object[]{((Provision)provision.get()).getObjectClass(), resource, Name.NAME, nameValue});
        } else {
            if (found.size() > 1) {
                LOG.warn("More than one {} found on {} with {} {} - taking first only", new Object[]{((Provision)provision.get()).getObjectClass(), resource, Name.NAME, nameValue});
            }
            ConnectorObject connObj = (ConnectorObject)found.iterator().next();
            try {
                List<PullMatch> matches = this.match(new SyncDeltaBuilder().setToken(new SyncToken((Object)"")).setDeltaType(SyncDeltaType.CREATE_OR_UPDATE).setObject(connObj).build(), resource, (Provision)provision.get(), anyType.getKind());
                if (matches.isEmpty()) {
                    LOG.debug("No matching {} found for {}, aborting", (Object)anyType.getKind(), (Object)connObj);
                } else {
                    if (matches.size() > 1) {
                        LOG.warn("More than one {} found {} - taking first only", (Object)anyType.getKind(), matches);
                    }
                    result = matches.stream().filter(match -> match.getAny() != null).findFirst();
                    result.ifPresent(pullMatch -> this.virAttrHandler.setValues(pullMatch.getAny(), connObj));
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn(e.getMessage());
            }
        }
        return result;
    }

    protected List<Implementation> getTransformers(Item item) {
        return item.getTransformers().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<PullMatch> matchByConnObjectKeyValue(Item connObjectKeyItem, String connObjectKeyValue, AnyTypeKind anyTypeKind, boolean ignoreCaseMatch, ExternalResource resource) {
        IntAttrName intAttrName;
        String finalConnObjectKeyValue = connObjectKeyValue;
        for (ItemTransformer transformer : MappingUtils.getItemTransformers(connObjectKeyItem, this.getTransformers(connObjectKeyItem))) {
            List output = transformer.beforePull(connObjectKeyItem, null, List.of(finalConnObjectKeyValue));
            if (CollectionUtils.isEmpty((Collection)output)) continue;
            finalConnObjectKeyValue = output.get(0).toString();
        }
        List<PullMatch> noMatchResult = List.of(PullCorrelationRule.NO_MATCH);
        try {
            intAttrName = this.intAttrNameParser.parse(connObjectKeyItem.getIntAttrName(), anyTypeKind);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)connObjectKeyItem.getIntAttrName(), (Object)e);
            return noMatchResult;
        }
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyTypeKind);
        ArrayList anys = new ArrayList();
        if (intAttrName.getField() != null) {
            switch (intAttrName.getField()) {
                case "key": {
                    Optional.ofNullable(anyUtils.dao().find(finalConnObjectKeyValue)).ifPresent(anys::add);
                    break;
                }
                case "username": {
                    if (anyTypeKind == AnyTypeKind.USER && ignoreCaseMatch) {
                        AnyCond cond = new AnyCond(AttrCond.Type.IEQ);
                        cond.setSchema("username");
                        cond.setExpression(finalConnObjectKeyValue);
                        anys.addAll(this.anySearchDAO.search(SearchCond.getLeaf((AbstractSearchCond)cond), AnyTypeKind.USER));
                        break;
                    }
                    Optional.ofNullable(this.userDAO.findByUsername(finalConnObjectKeyValue)).ifPresent(anys::add);
                    break;
                }
                case "name": {
                    AnyCond cond;
                    if (anyTypeKind == AnyTypeKind.GROUP && ignoreCaseMatch) {
                        cond = new AnyCond(AttrCond.Type.IEQ);
                        cond.setSchema("name");
                        cond.setExpression(finalConnObjectKeyValue);
                        anys.addAll(this.anySearchDAO.search(SearchCond.getLeaf((AbstractSearchCond)cond), AnyTypeKind.GROUP));
                    } else {
                        Optional.ofNullable(this.groupDAO.findByName(finalConnObjectKeyValue)).ifPresent(anys::add);
                    }
                    if (anyTypeKind == AnyTypeKind.ANY_OBJECT && ignoreCaseMatch) {
                        cond = new AnyCond(AttrCond.Type.IEQ);
                        cond.setSchema("name");
                        cond.setExpression(finalConnObjectKeyValue);
                        anys.addAll(this.anySearchDAO.search(SearchCond.getLeaf((AbstractSearchCond)cond), AnyTypeKind.ANY_OBJECT));
                        break;
                    }
                    anys.addAll(this.anyObjectDAO.findByName(finalConnObjectKeyValue));
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null) {
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    PlainAttrValue value = intAttrName.getSchema().isUniqueConstraint() ? anyUtils.newPlainAttrUniqueValue() : anyUtils.newPlainAttrValue();
                    try {
                        value.parseValue((PlainSchema)intAttrName.getSchema(), finalConnObjectKeyValue);
                    }
                    catch (ParsingValidationException e) {
                        LOG.error("While parsing provided {} {}", new Object[]{Uid.NAME, value, e});
                        value.setStringValue(finalConnObjectKeyValue);
                    }
                    if (intAttrName.getSchema().isUniqueConstraint()) {
                        anyUtils.dao().findByPlainAttrUniqueValue((PlainSchema)intAttrName.getSchema(), (PlainAttrUniqueValue)value, ignoreCaseMatch).ifPresent(anys::add);
                        break;
                    }
                    anys.addAll(anyUtils.dao().findByPlainAttrValue((PlainSchema)intAttrName.getSchema(), value, ignoreCaseMatch));
                    break;
                }
                case DERIVED: {
                    anys.addAll(anyUtils.dao().findByDerAttrValue((DerSchema)intAttrName.getSchema(), finalConnObjectKeyValue, ignoreCaseMatch));
                    break;
                }
            }
        }
        List result = anys.stream().map(any -> new PullMatch(MatchType.ANY, (Entity)any)).collect(Collectors.toList());
        if (resource != null) {
            this.userDAO.findLinkedAccount(resource, finalConnObjectKeyValue).map(account -> new PullMatch(MatchType.LINKED_ACCOUNT, (Entity)account)).ifPresent(result::add);
        }
        return result.isEmpty() ? noMatchResult : result;
    }

    protected List<PullMatch> matchByCorrelationRule(SyncDelta syncDelta, Provision provision, PullCorrelationRule rule, AnyTypeKind type) {
        ArrayList<PullMatch> result = new ArrayList<PullMatch>();
        try {
            result.addAll(this.anySearchDAO.search(rule.getSearchCond(syncDelta, provision), type).stream().map(any -> rule.matching(any, syncDelta, provision)).collect(Collectors.toList()));
        }
        catch (Throwable t) {
            LOG.error("While searching via {}", (Object)rule.getClass().getName(), (Object)t);
        }
        if (result.isEmpty()) {
            rule.unmatching(syncDelta, provision).ifPresent(result::add);
        }
        return result;
    }

    protected Optional<PullCorrelationRule> rule(ExternalResource resource, Provision provision) {
        Optional correlationRule = resource.getPullPolicy() == null ? Optional.empty() : resource.getPullPolicy().getCorrelationRule(provision.getAnyType());
        Optional rule = Optional.empty();
        if (correlationRule.isPresent()) {
            Implementation impl = ((PullCorrelationRuleEntity)correlationRule.get()).getImplementation();
            try {
                rule = ImplementationManager.buildPullCorrelationRule((Implementation)impl, () -> this.perContextPullCorrelationRules.get(impl.getKey()), instance -> this.perContextPullCorrelationRules.put(impl.getKey(), (PullCorrelationRule)instance));
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)impl, (Object)e);
            }
        }
        return rule;
    }

    public List<PullMatch> match(SyncDelta syncDelta, ExternalResource resource, Provision provision, AnyTypeKind anyTypeKind) {
        Optional<PullCorrelationRule> rule = this.rule(resource, provision);
        List<Object> result = List.of();
        try {
            if (rule.isPresent()) {
                result = this.matchByCorrelationRule(syncDelta, provision, rule.get(), anyTypeKind);
            } else {
                String connObjectKeyValue = null;
                Optional<Item> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
                if (connObjectKeyItem.isPresent()) {
                    Attribute connObjectKeyAttr = syncDelta.getObject().getAttributeByName(connObjectKeyItem.get().getExtAttrName());
                    if (connObjectKeyAttr != null) {
                        connObjectKeyValue = AttributeUtil.getStringValue((Attribute)connObjectKeyAttr);
                    }
                    if (connObjectKeyValue == null) {
                        connObjectKeyValue = syncDelta.getUid().getUidValue();
                    }
                }
                result = connObjectKeyValue == null ? List.of(PullCorrelationRule.NO_MATCH) : this.matchByConnObjectKeyValue(connObjectKeyItem.get(), connObjectKeyValue, anyTypeKind, provision.isIgnoreCaseMatch(), resource);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Could not match {} with any existing {}", new Object[]{syncDelta, provision.getAnyType(), e});
        }
        if (result.size() == 1 && ((PullMatch)result.get(0)).getMatchTarget() == MatchType.ANY) {
            this.virAttrHandler.setValues(((PullMatch)result.get(0)).getAny(), syncDelta.getObject());
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<Realm> match(SyncDelta syncDelta, OrgUnit orgUnit) {
        Object connObjectKeyAttr;
        String connObjectKey = null;
        Optional connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        if (connObjectKeyItem.isPresent() && (connObjectKeyAttr = syncDelta.getObject().getAttributeByName(((Item)connObjectKeyItem.get()).getExtAttrName())) != null) {
            connObjectKey = AttributeUtil.getStringValue((Attribute)connObjectKeyAttr);
        }
        if (connObjectKey == null) {
            return List.of();
        }
        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)connObjectKeyItem.get(), this.getTransformers((Item)connObjectKeyItem.get()))) {
            List output = transformer.beforePull((Item)connObjectKeyItem.get(), null, List.of(connObjectKey));
            if (CollectionUtils.isEmpty((Collection)output)) continue;
            connObjectKey = output.get(0).toString();
        }
        ArrayList<Realm> result = new ArrayList<Realm>();
        switch (((Item)connObjectKeyItem.get()).getIntAttrName()) {
            case "key": {
                Realm realm = this.realmDAO.find(connObjectKey);
                if (realm == null) break;
                result.add(realm);
                break;
            }
            case "name": {
                if (orgUnit.isIgnoreCaseMatch()) {
                    result.addAll(this.realmDAO.findDescendants("/", connObjectKey, -1, -1));
                    break;
                }
                result.addAll(this.realmDAO.findByName(connObjectKey).stream().collect(Collectors.toList()));
                break;
            }
            case "fullpath": {
                Realm realm = this.realmDAO.findByFullPath(connObjectKey);
                if (realm == null) break;
                result.add(realm);
                break;
            }
        }
        return result;
    }
}

