/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.search.DefaultSearchStrategy;
import net.tirasa.connid.bundles.ldap.search.LdapSearchResultsHandler;
import net.tirasa.connid.bundles.ldap.search.PagedSearchStrategy;
import net.tirasa.connid.bundles.ldap.search.VlvIndexSearchStrategy;
import org.identityconnectors.framework.common.objects.OperationOptions;

public abstract class LdapSearchStrategy {
    public abstract void doSearch(LdapContext var1, List<String> var2, String var3, SearchControls var4, LdapSearchResultsHandler var5) throws IOException, NamingException;

    protected static String searchControlsToString(SearchControls controls) {
        StringBuilder builder = new StringBuilder();
        builder.append("SearchControls: {returningAttributes=");
        String[] attrs = controls.getReturningAttributes();
        builder.append(attrs == null ? "null" : Arrays.asList(attrs));
        builder.append(", scope=");
        switch (controls.getSearchScope()) {
            case 0: {
                builder.append("OBJECT");
                break;
            }
            case 1: {
                builder.append("ONELEVEL");
                break;
            }
            default: {
                builder.append("SUBTREE");
            }
        }
        builder.append('}');
        return builder.toString();
    }

    public static Class<? extends LdapSearchStrategy> getSearchStrategy(LdapConnection conn, OperationOptions options) {
        Class clazz = DefaultSearchStrategy.class;
        if (options.getPageSize() != null) {
            if (conn.getConfiguration().isUseVlvControls() && conn.supportsControl("2.16.840.1.113730.3.4.9")) {
                clazz = VlvIndexSearchStrategy.class;
            } else if (conn.supportsControl("1.2.840.113556.1.4.319")) {
                clazz = PagedSearchStrategy.class;
            }
        }
        return clazz;
    }
}

