/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.PrettyStringBuilder;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.objects.SortKey;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

public final class OperationOptions {
    public static final String OP_SCOPE = "SCOPE";
    public static final String SCOPE_OBJECT = "object";
    public static final String SCOPE_ONE_LEVEL = "onelevel";
    public static final String SCOPE_SUBTREE = "subtree";
    public static final String OP_CONTAINER = "CONTAINER";
    public static final String OP_RUN_AS_USER = "RUN_AS_USER";
    public static final String OP_RUN_WITH_PASSWORD = "RUN_WITH_PASSWORD";
    public static final String OP_ATTRIBUTES_TO_GET = "ATTRS_TO_GET";
    public static final String OP_RETURN_DEFAULT_ATTRIBUTES = "RETURN_DEFAULT_ATTRIBUTES";
    public static final String OP_ALLOW_PARTIAL_RESULTS = "ALLOW_PARTIAL_RESULTS";
    public static final String OP_ALLOW_PARTIAL_ATTRIBUTE_VALUES = "ALLOW_PARTIAL_ATTRIBUTE_VALUES";
    public static final String OP_PAGED_RESULTS_COOKIE = "PAGED_RESULTS_COOKIE";
    public static final String OP_PAGED_RESULTS_OFFSET = "PAGED_RESULTS_OFFSET";
    public static final String OP_PAGE_SIZE = "PAGE_SIZE";
    public static final String OP_SORT_KEYS = "SORT_KEYS";
    private final Map<String, Object> operationOptions;

    public OperationOptions(Map<String, Object> operationOptions) {
        for (Object value : operationOptions.values()) {
            FrameworkUtil.checkOperationOptionValue(value);
        }
        Map operationOptionsClone = (Map)SerializerUtil.cloneObject(operationOptions);
        this.operationOptions = CollectionUtil.asReadOnlyMap(operationOptionsClone);
    }

    public Map<String, Object> getOptions() {
        return this.operationOptions;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("OperationOptions: ").append(new PrettyStringBuilder().toString(this.getOptions()));
        return bld.toString();
    }

    public String getScope() {
        return (String)this.operationOptions.get(OP_SCOPE);
    }

    public QualifiedUid getContainer() {
        return (QualifiedUid)this.operationOptions.get(OP_CONTAINER);
    }

    public String[] getAttributesToGet() {
        return (String[])this.operationOptions.get(OP_ATTRIBUTES_TO_GET);
    }

    public Boolean getReturnDefaultAttributes() {
        return (Boolean)this.operationOptions.get(OP_RETURN_DEFAULT_ATTRIBUTES);
    }

    public String getRunAsUser() {
        return (String)this.operationOptions.get(OP_RUN_AS_USER);
    }

    public GuardedString getRunWithPassword() {
        return (GuardedString)this.operationOptions.get(OP_RUN_WITH_PASSWORD);
    }

    public Boolean getAllowPartialResults() {
        return (Boolean)this.operationOptions.get(OP_ALLOW_PARTIAL_RESULTS);
    }

    public Boolean getAllowPartialAttributeValues() {
        return (Boolean)this.operationOptions.get(OP_ALLOW_PARTIAL_ATTRIBUTE_VALUES);
    }

    public String getPagedResultsCookie() {
        return (String)this.operationOptions.get(OP_PAGED_RESULTS_COOKIE);
    }

    public Integer getPagedResultsOffset() {
        return (Integer)this.operationOptions.get(OP_PAGED_RESULTS_OFFSET);
    }

    public Integer getPageSize() {
        return (Integer)this.operationOptions.get(OP_PAGE_SIZE);
    }

    public SortKey[] getSortKeys() {
        return (SortKey[])this.operationOptions.get(OP_SORT_KEYS);
    }
}

