/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.panels;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.panels.BaseSSOLoginFormPanel;
import org.apache.syncope.common.lib.to.SAML2SP4UIIdPTO;
import org.apache.syncope.common.rest.api.service.SAML2SP4UIIdPService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLSSOLoginFormPanel
extends BaseSSOLoginFormPanel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSAMLSSOLoginFormPanel.class);
    private static final long serialVersionUID = 1153528484703183466L;

    public AbstractSAMLSSOLoginFormPanel(String id, BaseSession session) {
        super(id);
        List available = ((SAML2SP4UIIdPService)session.getAnonymousService(SAML2SP4UIIdPService.class)).list();
        final Model model = new Model();
        AjaxDropDownChoicePanel idps = new AjaxDropDownChoicePanel("idps", "SAML 2.0", (IModel)model, false);
        idps.setChoices(available);
        idps.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<SAML2SP4UIIdPTO>(){
            private static final long serialVersionUID = 1814750973898916102L;

            public Object getDisplayValue(SAML2SP4UIIdPTO object) {
                return object.getName();
            }

            public String getIdValue(SAML2SP4UIIdPTO object, int index) {
                return object.getEntityID();
            }

            public SAML2SP4UIIdPTO getObject(String id, IModel<? extends List<? extends SAML2SP4UIIdPTO>> choices) {
                return ((List)choices.getObject()).stream().filter(idp -> idp.getEntityID().equals(id)).findFirst().orElse(null);
            }
        });
        idps.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (model.getObject() != null) {
                    try {
                        RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new RedirectRequestHandler(UrlUtils.rewriteToContextRelative((String)("saml2sp4ui/login?idp=" + URLEncoder.encode(((SAML2SP4UIIdPTO)model.getObject()).getEntityID(), StandardCharsets.UTF_8) + "&reauth=" + AbstractSAMLSSOLoginFormPanel.this.reauth), (IRequestCycle)RequestCycle.get())));
                    }
                    catch (Exception e) {
                        LOG.error("Could not redirect to the selected IdP {}", (Object)((SAML2SP4UIIdPTO)model.getObject()).getEntityID(), (Object)e);
                    }
                }
            }
        }});
        idps.setOutputMarkupPlaceholderTag(true);
        idps.setVisible(!available.isEmpty());
        this.add(new Component[]{idps});
    }
}

