/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Transaction;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.helper.ScopeUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.JobUtil;
import org.flowable.engine.impl.variable.ParallelMultiInstanceLoopVariable;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.persistence.entity.VariableInstance;

public class ParallelMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1L;

    public ParallelMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution multiInstanceRootExecution) {
        ProcessEngineConfigurationImpl processEngineConfiguration;
        ExecutionEntity concurrentExecution;
        int loopCounter;
        int nrOfInstances = this.resolveNrOfInstances(multiInstanceRootExecution);
        if (nrOfInstances < 0) {
            throw new FlowableIllegalArgumentException("Invalid number of instances: must be non-negative integer value, but was " + nrOfInstances);
        }
        if (nrOfInstances == 0) {
            return nrOfInstances;
        }
        this.setLoopVariable(multiInstanceRootExecution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", ParallelMultiInstanceLoopVariable.completed(multiInstanceRootExecution.getId()));
        this.setLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances", ParallelMultiInstanceLoopVariable.active(multiInstanceRootExecution.getId()));
        ArrayList<ExecutionEntity> concurrentExecutions = new ArrayList<ExecutionEntity>();
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = CommandContextUtil.getExecutionEntityManager().createChildExecution((ExecutionEntity)multiInstanceRootExecution);
            concurrentExecution.setCurrentFlowElement((FlowElement)this.activity);
            concurrentExecution.setActive(true);
            concurrentExecution.setScope(false);
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = (ExecutionEntity)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || concurrentExecution.getParent().isEnded()) continue;
            this.executeOriginalBehavior(concurrentExecution, (ExecutionEntity)multiInstanceRootExecution, loopCounter);
        }
        if (!concurrentExecutions.isEmpty()) {
            multiInstanceRootExecution.setActive(false);
        }
        if (this.isAsyncWithoutWaitStates(processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration())) {
            JobEntity job = JobUtil.createJob((ExecutionEntity)concurrentExecutions.get(0), "parallel-multi-instance-no-waits-async-leave", processEngineConfiguration);
            JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
            jobService.createAsyncJobNoTriggerAsyncExecutor(job, true);
            jobService.insertJob(job);
        }
        return nrOfInstances;
    }

    public boolean isAsyncWithoutWaitStates(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return this.activity.isAsynchronous() && this.activity.getLoopCharacteristics().isNoWaitStatesAsyncLeave() && processEngineConfiguration.isParallelMultiInstanceAsyncLeave();
    }

    @Override
    public void leave(DelegateExecution execution) {
        ProcessEngineConfigurationImpl processEngineConfiguration;
        boolean zeroNrOfInstances = false;
        if (this.resolveNrOfInstances(execution) == 0) {
            zeroNrOfInstances = true;
            super.leave(execution);
        }
        if (this.isAsyncWithoutWaitStates(processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration())) {
            DelegateExecution miRootExecution;
            ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
            long activeChildExecutionsCount = executionEntityManager.countActiveExecutionsByParentId((miRootExecution = this.getMultiInstanceRootExecution(execution)).getId());
            if (activeChildExecutionsCount > 0L) {
                this.inactivateExecutionAndParentExecutions(execution, processEngineConfiguration);
                this.callActivityEndListeners(execution);
                this.aggregateVariablesForChildExecution(execution, miRootExecution);
            } else {
                this.internalLeave(execution, zeroNrOfInstances);
            }
        } else {
            this.internalLeave(execution, zeroNrOfInstances);
        }
    }

    protected void internalLeave(DelegateExecution execution, boolean zeroNrOfInstances) {
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        VariableInstance nrOfCompletedInstancesVariable = this.getLoopVariableInstance(execution, "nrOfCompletedInstances");
        boolean usesParallelMultiInstanceLoopVariable = nrOfCompletedInstancesVariable != null && "bpmnParallelMultiInstanceCompleted".equals(nrOfCompletedInstancesVariable.getTypeName());
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
        DelegateExecution miRootExecution = this.getMultiInstanceRootExecution(execution);
        if (miRootExecution != null && !usesParallelMultiInstanceLoopVariable) {
            this.setLoopVariable(miRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
            this.setLoopVariable(miRootExecution, "nrOfActiveInstances", nrOfActiveInstances);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        this.inactivateExecution(execution, processEngineConfiguration);
        try {
            this.callActivityEndListeners(execution);
        }
        catch (BpmnError bpmnError) {
            ErrorPropagation.propagateError(bpmnError, execution);
            return;
        }
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        if (zeroNrOfInstances) {
            return;
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (executionEntity.getParent() != null) {
            boolean asyncLeave;
            boolean bl = asyncLeave = usesParallelMultiInstanceLoopVariable && processEngineConfiguration.isParallelMultiInstanceAsyncLeave() && !this.isAsyncWithoutWaitStates(processEngineConfiguration);
            if (!asyncLeave) {
                this.lockFirstParentScope(executionEntity);
            }
            this.aggregateVariablesForChildExecution(execution, miRootExecution);
            boolean isCompletionConditionSatisfied = this.completionConditionSatisfied(execution.getParent());
            if (nrOfCompletedInstances >= nrOfInstances || isCompletionConditionSatisfied) {
                this.leave(executionEntity, nrOfInstances, nrOfCompletedInstances, isCompletionConditionSatisfied);
            } else if (asyncLeave) {
                JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity job = JobUtil.createJob(executionEntity, "parallel-multi-instance-complete", processEngineConfiguration);
                jobService.createAsyncJob(job, true);
                jobService.scheduleAsyncJob(job);
            }
        } else {
            this.sendCompletedEvent(execution);
            super.leave(execution);
        }
    }

    protected void inactivateExecutionAndParentExecutions(DelegateExecution execution, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.inactivateExecution(execution, processEngineConfiguration);
        ExecutionEntity parentExecution = (ExecutionEntity)execution.getParent();
        while (!parentExecution.isMultiInstanceRoot()) {
            this.inactivateExecution(parentExecution, processEngineConfiguration);
            parentExecution = parentExecution.getParent();
        }
    }

    protected ExecutionEntity inactivateExecution(DelegateExecution execution, ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getActivityInstanceEntityManager().recordActivityEnd((ExecutionEntity)execution, null);
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (execution.getParent() != null) {
            executionEntity.inactivate();
        }
        return executionEntity;
    }

    public boolean leaveAsync(ExecutionEntity execution) {
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances");
        boolean isCompletionConditionSatisfied = this.completionConditionSatisfied(execution.getParent());
        if (nrOfCompletedInstances >= nrOfInstances || isCompletionConditionSatisfied) {
            this.leave(execution, nrOfInstances, nrOfCompletedInstances, isCompletionConditionSatisfied);
            return true;
        }
        return false;
    }

    protected void leave(ExecutionEntity execution, int nrOfInstances, int nrOfCompletedInstances, boolean isCompletionConditionSatisfied) {
        DelegateExecution miRootExecution = this.getMultiInstanceRootExecution(execution);
        ExecutionEntity leavingExecution = null;
        if (nrOfInstances > 0) {
            leavingExecution = execution.getParent();
        } else {
            CommandContextUtil.getActivityInstanceEntityManager().recordActivityEnd(execution, null);
            leavingExecution = execution;
        }
        Activity activity = (Activity)execution.getCurrentFlowElement();
        this.verifyCompensation(execution, leavingExecution, activity);
        this.verifyCallActivity(leavingExecution, activity);
        this.setLoopVariable(miRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.setLoopVariable(miRootExecution, "nrOfActiveInstances", this.getLoopVariable(execution, "nrOfActiveInstances"));
        if (isCompletionConditionSatisfied) {
            LinkedList<? extends DelegateExecution> toVerify = new LinkedList<DelegateExecution>(miRootExecution.getExecutions());
            while (!toVerify.isEmpty()) {
                List<? extends DelegateExecution> childExecutions;
                DelegateExecution childExecution = toVerify.pop();
                if (((ExecutionEntity)childExecution).isInserted()) {
                    childExecution.inactivate();
                }
                if ((childExecutions = childExecution.getExecutions()) == null || childExecutions.isEmpty()) continue;
                toVerify.addAll(childExecutions);
            }
            this.sendCompletedWithConditionEvent(leavingExecution);
        } else {
            this.sendCompletedEvent(leavingExecution);
        }
        super.leave(leavingExecution);
    }

    protected Activity verifyCompensation(DelegateExecution execution, ExecutionEntity executionToUse, Activity activity) {
        boolean hasCompensation = false;
        if (activity instanceof Transaction) {
            hasCompensation = true;
        } else if (activity instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)activity;
            block0: for (FlowElement subElement : subProcess.getFlowElements()) {
                Activity subActivity;
                if (!(subElement instanceof Activity) || !CollectionUtil.isNotEmpty((Collection)(subActivity = (Activity)subElement).getBoundaryEvents())) continue;
                for (BoundaryEvent boundaryEvent : subActivity.getBoundaryEvents()) {
                    if (!CollectionUtil.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                    hasCompensation = true;
                    continue block0;
                }
            }
        }
        if (hasCompensation) {
            ScopeUtil.createCopyOfSubProcessExecutionForCompensation(executionToUse);
        }
        return activity;
    }

    protected void verifyCallActivity(ExecutionEntity executionToUse, Activity activity) {
        if (activity instanceof CallActivity) {
            ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
            if (executionToUse != null) {
                ArrayList<String> callActivityExecutionIds = new ArrayList<String>();
                List<ExecutionEntity> childExecutions = executionEntityManager.collectChildren(executionToUse);
                if (childExecutions != null) {
                    for (ExecutionEntity childExecution : childExecutions) {
                        if (!activity.getId().equals(childExecution.getCurrentActivityId())) continue;
                        callActivityExecutionIds.add(childExecution.getId());
                    }
                    for (int i = childExecutions.size() - 1; i >= 0; --i) {
                        ExecutionEntity childExecution;
                        childExecution = childExecutions.get(i);
                        if (!StringUtils.isNotEmpty((CharSequence)childExecution.getSuperExecutionId()) || !callActivityExecutionIds.contains(childExecution.getSuperExecutionId())) continue;
                        executionEntityManager.deleteProcessInstanceExecutionEntity(childExecution.getId(), activity.getId(), "call activity completion condition met", true, false, true);
                    }
                }
            }
        }
    }

    protected void lockFirstParentScope(DelegateExecution execution) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        boolean found = false;
        ExecutionEntity parentScopeExecution = null;
        ExecutionEntity currentExecution = (ExecutionEntity)execution;
        while (!found && currentExecution != null && currentExecution.getParentId() != null) {
            parentScopeExecution = (ExecutionEntity)executionEntityManager.findById(currentExecution.getParentId());
            if (parentScopeExecution != null && parentScopeExecution.isScope()) {
                found = true;
            }
            currentExecution = parentScopeExecution;
        }
        parentScopeExecution.forceUpdate();
    }

    @Override
    protected void internalInterrupted(DelegateExecution execution) {
        this.setLoopVariable(execution, "nrOfCompletedInstances", this.getLoopVariable(execution, "nrOfCompletedInstances"));
        this.setLoopVariable(execution, "nrOfActiveInstances", this.getLoopVariable(execution, "nrOfActiveInstances"));
        super.internalInterrupted(execution);
    }
}

