/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.idm.api.PasswordEncoder;
import org.flowable.idm.api.PasswordSalt;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.UserQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.AbstractIdmEngineEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.flowable.idm.engine.impl.persistence.entity.IdentityInfoEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.MembershipEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.UserEntity;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.data.UserDataManager;

public class UserEntityManagerImpl
extends AbstractIdmEngineEntityManager<UserEntity, UserDataManager>
implements UserEntityManager {
    public UserEntityManagerImpl(IdmEngineConfiguration idmEngineConfiguration, UserDataManager userDataManager) {
        super(idmEngineConfiguration, userDataManager);
    }

    public UserEntity findById(String entityId) {
        return (UserEntity)((UserDataManager)this.dataManager).findById(entityId);
    }

    @Override
    public User createNewUser(String userId) {
        UserEntity userEntity = (UserEntity)this.create();
        userEntity.setId(userId);
        userEntity.setRevision(0);
        return userEntity;
    }

    @Override
    public void updateUser(User updatedUser) {
        super.update((Entity)((UserEntity)updatedUser));
    }

    public void delete(UserEntity userEntity) {
        super.delete((Entity)userEntity);
        this.deletePicture(userEntity);
    }

    @Override
    public void deletePicture(User user) {
        UserEntity userEntity = (UserEntity)user;
        if (userEntity.getPictureByteArrayRef() != null) {
            userEntity.getPictureByteArrayRef().delete();
        }
    }

    public void delete(String userId) {
        UserEntity user = this.findById(userId);
        if (user != null) {
            List<IdentityInfoEntity> identityInfos = this.getIdentityInfoEntityManager().findIdentityInfoByUserId(userId);
            for (IdentityInfoEntity identityInfo : identityInfos) {
                this.getIdentityInfoEntityManager().delete(identityInfo);
            }
            this.getMembershipEntityManager().deleteMembershipByUserId(userId);
            this.delete(user);
        }
    }

    @Override
    public List<User> findUserByQueryCriteria(UserQueryImpl query) {
        return ((UserDataManager)this.dataManager).findUserByQueryCriteria(query);
    }

    @Override
    public long findUserCountByQueryCriteria(UserQueryImpl query) {
        return ((UserDataManager)this.dataManager).findUserCountByQueryCriteria(query);
    }

    @Override
    public UserQuery createNewUserQuery() {
        return new UserQueryImpl(this.getCommandExecutor());
    }

    @Override
    public Boolean checkPassword(String userId, String password, PasswordEncoder passwordEncoder, PasswordSalt salt) {
        UserEntity user = null;
        if (userId != null) {
            user = this.findById(userId);
        }
        return user != null && password != null && passwordEncoder.isMatches((CharSequence)password, user.getPassword(), salt);
    }

    @Override
    public List<User> findUsersByNativeQuery(Map<String, Object> parameterMap) {
        return ((UserDataManager)this.dataManager).findUsersByNativeQuery(parameterMap);
    }

    @Override
    public long findUserCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((UserDataManager)this.dataManager).findUserCountByNativeQuery(parameterMap);
    }

    @Override
    public boolean isNewUser(User user) {
        return ((UserEntity)user).getRevision() == 0;
    }

    @Override
    public Picture getUserPicture(User user) {
        UserEntity userEntity = (UserEntity)user;
        return userEntity.getPicture();
    }

    @Override
    public void setUserPicture(User user, Picture picture) {
        UserEntity userEntity = (UserEntity)user;
        userEntity.setPicture(picture);
        ((UserDataManager)this.dataManager).update(userEntity);
    }

    @Override
    public List<User> findUsersByPrivilegeId(String name) {
        return ((UserDataManager)this.dataManager).findUsersByPrivilegeId(name);
    }

    public UserDataManager getUserDataManager() {
        return (UserDataManager)this.dataManager;
    }

    public void setUserDataManager(UserDataManager userDataManager) {
        this.dataManager = userDataManager;
    }

    protected IdentityInfoEntityManager getIdentityInfoEntityManager() {
        return ((IdmEngineConfiguration)this.engineConfiguration).getIdentityInfoEntityManager();
    }

    protected MembershipEntityManager getMembershipEntityManager() {
        return ((IdmEngineConfiguration)this.engineConfiguration).getMembershipEntityManager();
    }
}

