/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.zstd;

import coursierapi.shaded.zstd.BufferPool;
import coursierapi.shaded.zstd.ZstdIOException;
import coursierapi.shaded.zstd.util.Native;
import java.nio.ByteBuffer;

public class Zstd {
    public static native boolean isError(long var0);

    public static native String getErrorName(long var0);

    public static native long getErrorCode(long var0);

    public static native long errCorruptionDetected();

    public static native long errMemoryAllocation();

    static ByteBuffer getArrayBackedBuffer(BufferPool bufferPool, int n) throws ZstdIOException {
        ByteBuffer byteBuffer = bufferPool.get(n);
        if (byteBuffer == null) {
            throw new ZstdIOException(Zstd.errMemoryAllocation(), "Cannot get ByteBuffer of size " + n + " from the BufferPool");
        }
        if (!byteBuffer.hasArray() || byteBuffer.arrayOffset() != 0) {
            bufferPool.release(byteBuffer);
            throw new IllegalArgumentException("provided ByteBuffer lacks array or has non-zero arrayOffset");
        }
        return byteBuffer;
    }

    static {
        Native.load();
    }
}

