/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.RDDDataDistribution;
import org.apache.spark.status.api.v1.RDDPartitionInfo;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.storage.BlockPagedTable;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005!4Qa\u0002\u0005\u0001\u0015IA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\t9\u0001\u0011\t\u0011)A\u0005;!)1\u0005\u0001C\u0001I!)\u0011\u0006\u0001C\u0001U!)1\n\u0001C\u0005\u0019\")A\f\u0001C\u0005;\n9!\u000b\u0012#QC\u001e,'BA\u0005\u000b\u0003\u001d\u0019Ho\u001c:bO\u0016T!a\u0003\u0007\u0002\u0005UL'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005Q\u0011B\u0001\f\u000b\u0005%9VMY+J!\u0006<W-\u0001\u0004qCJ,g\u000e^\u0002\u0001!\t!\"$\u0003\u0002\u001c\u0015\tQ1\u000b]1sWVKE+\u00192\u0002\u000bM$xN]3\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001b\u0011AB:uCR,8/\u0003\u0002#?\tq\u0011\t\u001d9Ti\u0006$Xo]*u_J,\u0017A\u0002\u001fj]&$h\bF\u0002&O!\u0002\"A\n\u0001\u000e\u0003!AQaF\u0002A\u0002eAQ\u0001H\u0002A\u0002u\taA]3oI\u0016\u0014HCA\u0016@!\rac'\u000f\b\u0003[Mr!AL\u0019\u000e\u0003=R!\u0001\r\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b6\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AM\u0005\u0003oa\u00121aU3r\u0015\t!T\u0007\u0005\u0002;{5\t1H\u0003\u0002=k\u0005\u0019\u00010\u001c7\n\u0005yZ$\u0001\u0002(pI\u0016DQ\u0001\u0011\u0003A\u0002\u0005\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002C\u00136\t1I\u0003\u0002E\u000b\u0006!\u0001\u000e\u001e;q\u0015\t1u)A\u0004tKJ4H.\u001a;\u000b\u0003!\u000bqA[1lCJ$\u0018-\u0003\u0002K\u0007\n\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u000319xN]6fe\"+\u0017\rZ3s+\u0005i\u0005c\u0001(T)6\tqJ\u0003\u0002Q#\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003%V\n!bY8mY\u0016\u001cG/[8o\u0013\t9t\n\u0005\u0002V56\taK\u0003\u0002X1\u0006!A.\u00198h\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017,\u0003\rM#(/\u001b8h\u0003%9xN]6feJ{w\u000f\u0006\u0002,=\")qL\u0002a\u0001A\u00061qo\u001c:lKJ\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u0005Y\f$BA3 \u0003\r\t\u0007/[\u0005\u0003O\n\u00141C\u0015#E\t\u0006$\u0018\rR5tiJL'-\u001e;j_:\u0004")
public class RDDPage
extends WebUIPage {
    private final SparkUITab parent;
    private final AppStatusStore store;

    @Override
    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        Elem elem;
        RDDStorageInfo rDDStorageInfo;
        String parameterId = request.getParameter("id");
        Predef$.MODULE$.require(parameterId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parameterId)), (Function0 & Serializable)() -> "Missing id parameter");
        int blockPage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter("block.page")).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        int rddId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(parameterId));
        try {
            rDDStorageInfo = this.store.rdd(rddId);
        }
        catch (NoSuchElementException noSuchElementException) {
            return UIUtils$.MODULE$.headerSparkPage(request, "RDD Not Found", (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
        }
        RDDStorageInfo rddStorageInfo = rDDStorageInfo;
        scala.collection.immutable.Seq<String> x$12 = this.workerHeader();
        Function1 & Serializable x$22 = (Function1 & Serializable)worker -> this.workerRow((RDDDataDistribution)worker);
        Seq x$32 = (Seq)rddStorageInfo.dataDistribution().get();
        Some x$4 = new Some((Object)"rdd-storage-by-worker-table");
        boolean x$5 = UIUtils$.MODULE$.listingTable$default$4();
        scala.collection.immutable.Seq<String> x$6 = UIUtils$.MODULE$.listingTable$default$6();
        boolean x$7 = UIUtils$.MODULE$.listingTable$default$7();
        boolean x$8 = UIUtils$.MODULE$.listingTable$default$8();
        scala.collection.immutable.Seq<Option<String>> x$9 = UIUtils$.MODULE$.listingTable$default$9();
        scala.collection.immutable.Seq<Node> workerTable = UIUtils$.MODULE$.listingTable(x$12, x$22, x$32, x$5, (Option<String>)x$4, x$6, x$7, x$8, x$9);
        try {
            BlockPagedTable _blockTable = new BlockPagedTable(request, "block", UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()) + "/storage/rdd/?id=" + rddId, (Seq<RDDPartitionInfo>)((Seq)rddStorageInfo.partitions().get()), this.store.executorList(true));
            elem = _blockTable.table(blockPage);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException) {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)throwable2.getMessage());
                Elem elem2 = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
                elem = elem2;
            }
            throw throwable;
        }
        Elem blockTableHTML = elem;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |$(function() {\n              |  if (/.*&block.sort=.*$/.test(location.search)) {\n              |    var topOffset = $(\"#blocks-section\").offset().top;\n              |    $(\"html,body\").animate({scrollTop: topOffset}, 200);\n              |  }\n              |});\n            "))));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem jsForScrollingDownToBlockTable = new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
        NodeBuffer $buf2 = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md2);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Storage Level:"));
        $buf6.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        $buf6.$amp$plus((Object)new Text("\n              "));
        $buf6.$amp$plus((Object)rddStorageInfo.storageLevel());
        $buf6.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Cached Partitions:"));
        $buf8.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf8.$amp$plus((Object)new Text("\n              "));
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)rddStorageInfo.numCachedPartitions()));
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("Total Partitions:"));
        $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector()));
        $buf10.$amp$plus((Object)new Text("\n              "));
        $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)rddStorageInfo.numPartitions()));
        $buf10.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("Memory Size:"));
        $buf12.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf13.toVector()));
        $buf12.$amp$plus((Object)new Text("\n              "));
        $buf12.$amp$plus((Object)Utils$.MODULE$.bytesToString(rddStorageInfo.memoryUsed()));
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf12.toVector()));
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("Disk Size:"));
        $buf14.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf15.toVector()));
        $buf14.$amp$plus((Object)new Text("\n              "));
        $buf14.$amp$plus((Object)Utils$.MODULE$.bytesToString(rddStorageInfo.diskUsed()));
        $buf14.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf14.toVector()));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md4);
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md5);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("\n            Data Distribution on "));
        $buf18.$amp$plus(rddStorageInfo.dataDistribution().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        $buf18.$amp$plus((Object)new Text("\n            Executors\n          "));
        $buf17.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf18.toVector()));
        $buf17.$amp$plus((Object)new Text("\n          "));
        $buf17.$amp$plus(workerTable);
        $buf17.$amp$plus((Object)new Text("\n        "));
        $buf16.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf17.toVector()));
        $buf16.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf16.toVector()));
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("blocks-section"), (MetaData)$md6);
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n          "));
        $buf20.$amp$plus(rddStorageInfo.partitions().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        $buf20.$amp$plus((Object)new Text(" Partitions\n        "));
        $buf19.$amp$plus((Object)new Elem(null, "h4", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf20.toVector()));
        $buf19.$amp$plus((Object)new Text("\n        "));
        $buf19.$amp$plus(blockTableHTML.$plus$plus((IterableOnce)jsForScrollingDownToBlockTable));
        $buf19.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf19.toVector()));
        NodeBuffer content = $buf2;
        return UIUtils$.MODULE$.headerSparkPage(request, "RDD Storage Info for " + rddStorageInfo.name(), (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> NodeSeq$.MODULE$.seqToNodeSeq((Seq)content), this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    private scala.collection.immutable.Seq<String> workerHeader() {
        return new .colon.colon((Object)"Host", (List)new .colon.colon((Object)"On Heap Memory Usage", (List)new .colon.colon((Object)"Off Heap Memory Usage", (List)new .colon.colon((Object)"Disk Usage", (List)Nil$.MODULE$))));
    }

    private scala.collection.immutable.Seq<Node> workerRow(RDDDataDistribution worker) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)worker.address());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)worker.onHeapMemoryUsed().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))));
        $buf3.$amp$plus((Object)new Text("\n        ("));
        $buf3.$amp$plus((Object)Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)worker.onHeapMemoryRemaining().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))));
        $buf3.$amp$plus((Object)new Text(" Remaining)\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)worker.offHeapMemoryUsed().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))));
        $buf4.$amp$plus((Object)new Text("\n        ("));
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)worker.offHeapMemoryRemaining().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))));
        $buf4.$amp$plus((Object)new Text(" Remaining)\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)Utils$.MODULE$.bytesToString(worker.diskUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public RDDPage(SparkUITab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("rdd");
    }
}

