/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangeDataReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangeDataReader$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple4;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005U4A\u0001D\u0007\u00019!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011e\u0002!\u0011!Q\u0001\niB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0003\")\u0001\n\u0001C\u0001\u0013\"9!\u000b\u0001b\u0001\n#\u001a\u0006BB0\u0001A\u0003%A\u000bC\u0003a\u0001\u0011\u0005\u0013M\u0001\u0013I\t\u001a\u001b&)Y2lK\u0012\u001cF/\u0019;f'R|'/Z\"iC:<W\rR1uCJ+\u0017\rZ3s\u0015\tqq\"A\u0003ti\u0006$XM\u0003\u0002\u0011#\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003%M\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Q)\u0012aA:rY*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010 \u001b\u0005i\u0011B\u0001\u0011\u000e\u0005i\u0019F/\u0019;f'R|'/Z\"iC:<W\rR1uCJ+\u0017\rZ3s\u0003\t1W\u000e\u0005\u0002$M5\tAE\u0003\u0002&\u001f\u0005i1\r[3dWB|\u0017N\u001c;j]\u001eL!a\n\u0013\u0003+\rCWmY6q_&tGOR5mK6\u000bg.Y4fe\u0006i1\u000f^1uK2{7-\u0019;j_:\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0005\u0019\u001c(B\u0001\u0018\u0018\u0003\u0019A\u0017\rZ8pa&\u0011\u0001g\u000b\u0002\u0005!\u0006$\b.\u0001\u0007ti\u0006\u0014HOV3sg&|g\u000e\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0003M_:<\u0017AC3oIZ+'o]5p]\u0006\u00012m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{U\t!![8\n\u0005}b$\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0003%YW-_*dQ\u0016l\u0017\r\u0005\u0002C\u000b6\t1I\u0003\u0002E'\u0005)A/\u001f9fg&\u0011ai\u0011\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017a\u0003<bYV,7k\u00195f[\u0006\fa\u0001P5oSRtD\u0003\u0003&L\u00196su\nU)\u0011\u0005y\u0001\u0001\"B\u0011\t\u0001\u0004\u0011\u0003\"\u0002\u0015\t\u0001\u0004I\u0003\"B\u0019\t\u0001\u0004\u0011\u0004\"\u0002\u001d\t\u0001\u0004\u0011\u0004\"B\u001d\t\u0001\u0004Q\u0004\"\u0002!\t\u0001\u0004\t\u0005\"B$\t\u0001\u0004\t\u0015aD2iC:<W\r\\8h'V4g-\u001b=\u0016\u0003Q\u0003\"!\u0016/\u000f\u0005YS\u0006CA,5\u001b\u0005A&BA-\u001c\u0003\u0019a$o\\8u}%\u00111\fN\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\i\u0005\u00012\r[1oO\u0016dwnZ*vM\u001aL\u0007\u0010I\u0001\bO\u0016$h*\u001a=u)\u0005\u0011\u0007CB\u001adK6l''\u0003\u0002ei\t1A+\u001e9mKR\u0002\"AZ5\u000f\u0005y9\u0017B\u00015\u000e\u0003)\u0011VmY8sIRK\b/Z\u0005\u0003U.\u0014QAV1mk\u0016L!\u0001\u001c\u001b\u0003\u0017\u0015sW/\\3sCRLwN\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\f1\"\u001a=qe\u0016\u001c8/[8og*\u0011!oE\u0001\tG\u0006$\u0018\r\\=ti&\u0011Ao\u001c\u0002\n+:\u001c\u0018MZ3S_^\u0004")
public class HDFSBackedStateStoreChangeDataReader
extends StateStoreChangeDataReader {
    private final StructType keySchema;
    private final StructType valueSchema;
    private final String changelogSuffix;

    @Override
    public String changelogSuffix() {
        return this.changelogSuffix;
    }

    public Tuple4<Enumeration.Value, UnsafeRow, UnsafeRow, Object> getNext() {
        StateStoreChangelogReader reader = this.currentChangelogReader();
        if (reader == null) {
            return null;
        }
        Tuple3 tuple3 = (Tuple3)reader.next();
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Enumeration.Value recordType = (Enumeration.Value)tuple3._1();
        byte[] keyArray = (byte[])tuple3._2();
        byte[] valueArray = (byte[])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)recordType, (Object)keyArray, (Object)valueArray);
        Enumeration.Value recordType2 = (Enumeration.Value)tuple32._1();
        byte[] keyArray2 = (byte[])tuple32._2();
        byte[] valueArray2 = (byte[])tuple32._3();
        UnsafeRow keyRow = new UnsafeRow(this.keySchema.fields().length);
        keyRow.pointTo(keyArray2, keyArray2.length);
        if (valueArray2 == null) {
            return new Tuple4((Object)recordType2, (Object)keyRow, null, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
        }
        UnsafeRow valueRow = new UnsafeRow(this.valueSchema.fields().length);
        valueRow.pointTo(valueArray2, valueArray2.length / 8 * 8);
        return new Tuple4((Object)recordType2, (Object)keyRow, (Object)valueRow, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
    }

    public HDFSBackedStateStoreChangeDataReader(CheckpointFileManager fm, Path stateLocation, long startVersion, long endVersion, CompressionCodec compressionCodec, StructType keySchema, StructType valueSchema) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        super(fm, stateLocation, startVersion, endVersion, compressionCodec, StateStoreChangeDataReader$.MODULE$.$lessinit$greater$default$6());
        this.changelogSuffix = "delta";
    }
}

