/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.Serializable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.connect.proto.Read;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.connect.ConnectConversions$;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\r\u001b\u0005\u0015B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0007a\u0001!\t\u0001H\u0019\t\u000fQ\u0002!\u0019!C\u0005k!1\u0011\u000b\u0001Q\u0001\nYBQA\u0015\u0001\u0005\u0002MCQ!\u0019\u0001\u0005\u0002\tDQ!\u0019\u0001\u0005B)DQ!\u001c\u0001\u0005\u00029DQa\u001d\u0001\u0005\u0002QDQa\u001d\u0001\u0005BqDq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\f\u0001!\t!!\b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u00111\u0006\u0001\u0005R\u00055\u0002BB7\u0001\t\u0003\nY\u0004\u0003\u0004n\u0001\u0011\u0005\u0013q\t\u0005\u0007[\u0002!\t%a\u0015\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\t9\b\u0001C!\u0003sBq!! \u0001\t\u0003\ny\bC\u0004\u0002\u0004\u0002!\t%!\"\u0003!\u0011\u000bG/Y*ue\u0016\fWNU3bI\u0016\u0014(BA\u000e\u001d\u0003\u001d\u0019wN\u001c8fGRT!!\b\u0010\u0002\u0007M\fHN\u0003\u0002 A\u0005)1\u000f]1sW*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%b\u0012!C:ue\u0016\fW.\u001b8h\u0013\tI\u0002&\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002.]5\t!$\u0003\u000205\ta1\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"\"AM\u001a\u0011\u00055\u0002\u0001\"B\u0016\u0003\u0001\u0004a\u0013!D:pkJ\u001cWMQ;jY\u0012,'/F\u00017!\t9dJ\u0004\u00029\u0017:\u0011\u0011\b\u0013\b\u0003u\u0015s!a\u000f#\u000f\u0005q\u001aeBA\u001fC\u001d\tq\u0014)D\u0001@\u0015\t\u0001E%\u0001\u0004=e>|GOP\u0005\u0002G%\u0011\u0011EI\u0005\u0003?\u0001J!a\u0007\u0010\n\u0005\u0019;\u0015!\u00029s_R|'BA\u000e\u001f\u0013\tI%*\u0001\u0003SK\u0006$'B\u0001$H\u0013\taU*\u0001\u0006ECR\f7k\\;sG\u0016T!!\u0013&\n\u0005=\u0003&a\u0002\"vS2$WM\u001d\u0006\u0003\u00196\u000bab]8ve\u000e,')^5mI\u0016\u0014\b%\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0003)Vk\u0011\u0001\u0001\u0005\u0006-\u0016\u0001\raV\u0001\u0007g>,(oY3\u0011\u0005asfBA-]!\tq$LC\u0001\\\u0003\u0015\u00198-\u00197b\u0013\ti&,\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/[\u0003\u0019\u00198\r[3nCR\u0011Ak\u0019\u0005\u0006C\u001a\u0001\r\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003Or\tQ\u0001^=qKNL!!\u001b4\u0003\u0015M#(/^2u)f\u0004X\r\u0006\u0002UW\")An\u0002a\u0001/\u0006a1o\u00195f[\u0006\u001cFO]5oO\u00061q\u000e\u001d;j_:$2\u0001V8r\u0011\u0015\u0001\b\u00021\u0001X\u0003\rYW-\u001f\u0005\u0006e\"\u0001\raV\u0001\u0006m\u0006dW/Z\u0001\b_B$\u0018n\u001c8t)\t!V\u000fC\u0003t\u0013\u0001\u0007a\u000f\u0005\u0003xu^;V\"\u0001=\u000b\u0005eT\u0016AC2pY2,7\r^5p]&\u00111\u0010\u001f\u0002\u0004\u001b\u0006\u0004HC\u0001+~\u0011\u0015\u0019(\u00021\u0001\u007f!\u0015y\u0018\u0011B,X\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001B;uS2T!!a\u0002\u0002\t)\fg/Y\u0005\u0004w\u0006\u0005\u0011\u0001\u00027pC\u0012$\"!a\u0004\u0011\t\u0005E\u0011q\u0003\b\u0004[\u0005M\u0011bAA\u000b5\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\r\u00037\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005U!\u0004\u0006\u0003\u0002\u0010\u0005}\u0001BBA\u0011\u0019\u0001\u0007q+\u0001\u0003qCRD\u0017!\u0002;bE2,G\u0003BA\b\u0003OAa!!\u000b\u000e\u0001\u00049\u0016!\u0003;bE2,g*Y7f\u0003]\t7o]3si:{7\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017\r\u0006\u0003\u00020\u0005]\u0002\u0003BA\u0019\u0003gi\u0011AW\u0005\u0004\u0003kQ&\u0001B+oSRDa!!\u000f\u000f\u0001\u00049\u0016!C8qKJ\fG/[8o)\u0015!\u0016QHA \u0011\u0015\u0001x\u00021\u0001X\u0011\u0019\u0011x\u00021\u0001\u0002BA!\u0011\u0011GA\"\u0013\r\t)E\u0017\u0002\b\u0005>|G.Z1o)\u0015!\u0016\u0011JA&\u0011\u0015\u0001\b\u00031\u0001X\u0011\u0019\u0011\b\u00031\u0001\u0002NA!\u0011\u0011GA(\u0013\r\t\tF\u0017\u0002\u0005\u0019>tw\rF\u0003U\u0003+\n9\u0006C\u0003q#\u0001\u0007q\u000b\u0003\u0004s#\u0001\u0007\u0011\u0011\f\t\u0005\u0003c\tY&C\u0002\u0002^i\u0013a\u0001R8vE2,\u0017\u0001\u00026t_:$B!a\u0004\u0002d!1\u0011\u0011\u0005\nA\u0002]\u000b1aY:w)\u0011\ty!!\u001b\t\r\u0005\u00052\u00031\u0001X\u0003\rAX\u000e\u001c\u000b\u0005\u0003\u001f\ty\u0007\u0003\u0004\u0002\"Q\u0001\raV\u0001\u0004_J\u001cG\u0003BA\b\u0003kBa!!\t\u0016\u0001\u00049\u0016a\u00029beF,X\r\u001e\u000b\u0005\u0003\u001f\tY\b\u0003\u0004\u0002\"Y\u0001\raV\u0001\u0005i\u0016DH\u000f\u0006\u0003\u0002\u0010\u0005\u0005\u0005BBA\u0011/\u0001\u0007q+\u0001\u0005uKb$h)\u001b7f)\u0011\t9)!$\u0011\t5\nIiV\u0005\u0004\u0003\u0017S\"a\u0002#bi\u0006\u001cX\r\u001e\u0005\u0007\u0003CA\u0002\u0019A,)\u0007\u0001\t\t\n\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9JH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAN\u0003+\u0013\u0001\"\u0012<pYZLgn\u001a")
public final class DataStreamReader
extends org.apache.spark.sql.streaming.DataStreamReader {
    private final SparkSession sparkSession;
    private final Read.DataSource.Builder sourceBuilder;

    private Read.DataSource.Builder sourceBuilder() {
        return this.sourceBuilder;
    }

    public DataStreamReader format(String source) {
        this.sourceBuilder().setFormat(source);
        return this;
    }

    public DataStreamReader schema(StructType schema) {
        Object object = schema != null ? this.sourceBuilder().setSchema(schema.json()) : BoxedUnit.UNIT;
        return this;
    }

    public DataStreamReader schema(String schemaString) {
        this.sourceBuilder().setSchema(schemaString);
        return this;
    }

    public DataStreamReader option(String key, String value) {
        this.sourceBuilder().putOptions(key, value);
        return this;
    }

    public DataStreamReader options(Map<String, String> options) {
        return this.options(CollectionConverters$.MODULE$.MapHasAsJava(options).asJava());
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        this.sourceBuilder().putAllOptions(options);
        return this;
    }

    public Dataset<Row> load() {
        return this.sparkSession.newDataFrame((Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable)relationBuilder -> {
            DataStreamReader.$anonfun$load$1(this, relationBuilder);
            return BoxedUnit.UNIT;
        });
    }

    public Dataset<Row> load(String path) {
        this.sourceBuilder().clearPaths();
        this.sourceBuilder().addPaths(path);
        return this.load();
    }

    public Dataset<Row> table(String tableName) {
        Predef$.MODULE$.require(tableName != null, (Function0 & Serializable)() -> "The table name can't be null");
        return this.sparkSession.newDataFrame((Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable)builder -> {
            DataStreamReader.$anonfun$table$2(this, tableName, builder);
            return BoxedUnit.UNIT;
        });
    }

    public void assertNoSpecifiedSchema(String operation) {
        if (this.sourceBuilder().hasSchema()) {
            throw DataTypeErrors$.MODULE$.userSpecifiedSchemaUnsupportedError(operation);
        }
    }

    public DataStreamReader option(String key, boolean value) {
        return (DataStreamReader)super.option(key, value);
    }

    public DataStreamReader option(String key, long value) {
        return (DataStreamReader)super.option(key, value);
    }

    public DataStreamReader option(String key, double value) {
        return (DataStreamReader)super.option(key, value);
    }

    public Dataset<Row> json(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.json(path));
    }

    public Dataset<Row> csv(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.csv(path));
    }

    public Dataset<Row> xml(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.xml(path));
    }

    public Dataset<Row> orc(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.orc(path));
    }

    public Dataset<Row> parquet(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.parquet(path));
    }

    public Dataset<Row> text(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.text(path));
    }

    public Dataset<String> textFile(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.textFile(path));
    }

    public static final /* synthetic */ void $anonfun$load$1(DataStreamReader $this, Relation.Builder relationBuilder) {
        relationBuilder.getReadBuilder().setIsStreaming(true).setDataSource($this.sourceBuilder().build());
    }

    public static final /* synthetic */ void $anonfun$table$2(DataStreamReader $this, String tableName$1, Relation.Builder builder) {
        builder.getReadBuilder().setIsStreaming(true).getNamedTableBuilder().setUnparsedIdentifier(tableName$1).putAllOptions($this.sourceBuilder().getOptionsMap());
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        this.sourceBuilder = Read.DataSource.newBuilder();
    }
}

