/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.BinaryArithmeticWithDatetimeResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.CoercesExpressionTypes;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversal;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversalStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ProducesUnresolvedSubtree;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesExpressionChildren;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.DateAdd;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.SubtractDates$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DatetimeType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005A3A!\u0003\u0006\u00013!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0004<\u0001\t\u0007I\u0011\u0002\u001f\t\r\u0001\u0003\u0001\u0015!\u0003>\u0011\u0015\t\u0005\u0001\"\u0011C\u0011\u0015)\u0005\u0001\"\u0003G\u0011\u0015I\u0005\u0001\"\u0003K\u0011\u0015i\u0005\u0001\"\u0003O\u0005a\u0011\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7MU3t_24XM\u001d\u0006\u0003\u00171\t\u0001B]3t_24XM\u001d\u0006\u0003\u001b9\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u001fA\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0006\u0001i\u0001S\u0006\r\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\u0012CEK\u0007\u0002\u0015%\u00111E\u0003\u0002\u0011)J,WMT8eKJ+7o\u001c7wKJ\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\b\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003S\u0019\u0012\u0001CQ5oCJL\u0018I]5uQ6,G/[2\u0011\u0005\u0015Z\u0013B\u0001\u0017'\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003C9J!a\f\u0006\u00033A\u0013x\u000eZ;dKN,fN]3t_24X\rZ*vER\u0014X-\u001a\t\u0003CEJ!A\r\u0006\u0003-\r{WM]2fg\u0016C\bO]3tg&|g\u000eV=qKN\f!#\u001a=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<feB\u0011\u0011%N\u0005\u0003m)\u0011!#\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"\"!\u000f\u001e\u0011\u0005\u0005\u0002\u0001\"B\u001a\u0003\u0001\u0004!\u0014A\u0003;sCZ,'o]1mgV\tQ\b\u0005\u0002\"}%\u0011qH\u0003\u0002\u001d\u000bb\u0004(/Z:tS>tGK]3f)J\fg/\u001a:tC2\u001cF/Y2l\u0003-!(/\u0019<feN\fGn\u001d\u0011\u0002\u000fI,7o\u001c7wKR\u0011!f\u0011\u0005\u0006\t\u0016\u0001\r\u0001J\u0001\u001bk:\u0014Xm]8mm\u0016$')\u001b8bef\f%/\u001b;i[\u0016$\u0018nY\u0001\u001eiJ\fgn\u001d4pe6\u0014\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7MT8eKR\u0011!f\u0012\u0005\u0006\u0011\u001a\u0001\r\u0001J\u0001\u0011E&t\u0017M]=Be&$\b.\\3uS\u000e\fqB]3qY\u0006\u001cW\rR1uKRK\b/\u001a\u000b\u0003U-CQ\u0001T\u0004A\u0002)\n!\"\u001a=qe\u0016\u001c8/[8o\u0003=\u0011X\r\u001d7bG\u0016tU\u000f\u001c7UsB,GC\u0001\u0016P\u0011\u0015a\u0005\u00021\u0001+\u0001")
public class BinaryArithmeticResolver
implements TreeNodeResolver<BinaryArithmetic, Expression>,
ProducesUnresolvedSubtree,
CoercesExpressionTypes {
    private final ExpressionResolver expressionResolver;
    private final ExpressionTreeTraversalStack traversals;
    private Seq<Function1<Expression, Expression>> ansiTransformations;
    private Seq<Function1<Expression, Expression>> nonAnsiTransformations;

    @Override
    public Expression coerceExpressionTypes(Expression expression, ExpressionTreeTraversal expressionTreeTraversal) {
        return CoercesExpressionTypes.coerceExpressionTypes$(this, expression, expressionTreeTraversal);
    }

    @Override
    public Expression withResolvedSubtree(Expression expression, Function1<Expression, Expression> expressionResolver, Function0<Expression> body) {
        return ProducesUnresolvedSubtree.withResolvedSubtree$(this, expression, expressionResolver, body);
    }

    @Override
    public boolean tryPopSinglePassSubtreeBoundary(Expression unresolvedExpression) {
        return ProducesUnresolvedSubtree.tryPopSinglePassSubtreeBoundary$(this, unresolvedExpression);
    }

    @Override
    public Expression withResolvedChildren(UnaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(BinaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(TernaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(QuaternaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(Expression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public Seq<Function1<Expression, Expression>> ansiTransformations() {
        return this.ansiTransformations;
    }

    @Override
    public Seq<Function1<Expression, Expression>> nonAnsiTransformations() {
        return this.nonAnsiTransformations;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$ansiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.ansiTransformations = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$nonAnsiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.nonAnsiTransformations = x$1;
    }

    private ExpressionTreeTraversalStack traversals() {
        return this.traversals;
    }

    @Override
    public Expression resolve(BinaryArithmetic unresolvedBinaryArithmetic) {
        BinaryArithmetic binaryArithmeticWithResolvedChildren = (BinaryArithmetic)this.withResolvedChildren(unresolvedBinaryArithmetic, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression));
        Expression binaryArithmeticWithResolvedSubtree = this.withResolvedSubtree(binaryArithmeticWithResolvedChildren, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression), (Function0<Expression>)(Function0 & Serializable)() -> this.transformBinaryArithmeticNode(binaryArithmeticWithResolvedChildren));
        return TimezoneAwareExpressionResolver$.MODULE$.resolveTimezone(binaryArithmeticWithResolvedSubtree, this.traversals().current().sessionLocalTimeZone());
    }

    private Expression transformBinaryArithmeticNode(BinaryArithmetic binaryArithmetic) {
        Expression binaryArithmeticWithNullReplaced = this.replaceNullType(binaryArithmetic);
        Expression binaryArithmeticWithDateTypeReplaced = this.replaceDateType(binaryArithmeticWithNullReplaced);
        Expression binaryArithmeticWithTypeCoercion = this.coerceExpressionTypes(binaryArithmeticWithDateTypeReplaced, this.traversals().current());
        Tuple2 tuple2 = new Tuple2((Object)((Expression)binaryArithmetic.left()).dataType(), (Object)((Expression)binaryArithmetic.right()).dataType());
        if (tuple2 != null && tuple2._1() instanceof DateType && tuple2._2() instanceof StringType) {
            Expression expression = binaryArithmeticWithTypeCoercion;
            if (expression instanceof Add) {
                Add add = (Add)expression;
                return new DateAdd(add.left(), add.right());
            }
            if (expression instanceof Subtract) {
                Subtract subtract = (Subtract)expression;
                return SubtractDates$.MODULE$.apply(subtract.left(), subtract.right());
            }
            return expression;
        }
        return binaryArithmeticWithTypeCoercion;
    }

    private Expression replaceDateType(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof Add ? true : (expression2 instanceof Subtract ? true : (expression2 instanceof Multiply ? true : expression2 instanceof Divide))) {
            return BinaryArithmeticWithDatetimeResolver$.MODULE$.resolve(expression2);
        }
        return expression2;
    }

    private Expression replaceNullType(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof Add) {
            Add add = (Add)expression2;
            Expression l = add.left();
            Expression r = add.right();
            Tuple2 tuple2 = new Tuple2((Object)l.dataType(), (Object)r.dataType());
            if (tuple2 != null && tuple2._1() instanceof DatetimeType && tuple2._2() instanceof NullType) {
                Cast x$1 = new Cast(add.right(), (DataType)DayTimeIntervalType$.MODULE$.DEFAULT(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                Expression x$2 = add.copy$default$1();
                Enumeration.Value x$3 = add.copy$default$3();
                return add.copy(x$2, x$1, x$3);
            }
            if (tuple2 != null && tuple2._1() instanceof NullType && tuple2._2() instanceof DatetimeType) {
                return add.copy(new Cast(add.left(), (DataType)DayTimeIntervalType$.MODULE$.DEFAULT(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), add.copy$default$2(), add.copy$default$3());
            }
            return add;
        }
        if (expression2 instanceof Subtract) {
            Subtract subtract = (Subtract)expression2;
            Expression l = subtract.left();
            Expression r = subtract.right();
            Tuple2 tuple2 = new Tuple2((Object)l.dataType(), (Object)r.dataType());
            if (tuple2 != null && tuple2._1() instanceof NullType && tuple2._2() instanceof DatetimeType) {
                return subtract.copy(new Cast(subtract.left(), subtract.right().dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), subtract.copy$default$2(), subtract.copy$default$3());
            }
            if (tuple2 != null && tuple2._1() instanceof DatetimeType && tuple2._2() instanceof NullType) {
                Cast x$4 = new Cast(subtract.right(), subtract.left().dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                Expression x$5 = subtract.copy$default$1();
                Enumeration.Value x$6 = subtract.copy$default$3();
                return subtract.copy(x$5, x$4, x$6);
            }
            return subtract;
        }
        return expression2;
    }

    public BinaryArithmeticResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesExpressionChildren.$init$(this);
        ProducesUnresolvedSubtree.$init$(this);
        CoercesExpressionTypes.$init$(this);
        this.traversals = expressionResolver.getExpressionTreeTraversals();
        Statics.releaseFence();
    }
}

