/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.Extent;
import org.datanucleus.util.Localiser;

public abstract class AbstractExtent<T>
implements Extent<T> {
    protected final ExecutionContext ec;
    protected final Class<T> candidateClass;
    protected final boolean subclasses;
    protected final AbstractClassMetaData cmd;

    public AbstractExtent(ExecutionContext ec, Class<T> cls, boolean subclasses, AbstractClassMetaData cmd) {
        if (cls == null) {
            throw new NucleusUserException(Localiser.msg("033000")).setFatal();
        }
        this.cmd = cmd;
        if (cmd == null) {
            throw new NucleusUserException(Localiser.msg("033001", cls.getName())).setFatal();
        }
        this.ec = ec;
        this.candidateClass = cls;
        this.subclasses = subclasses;
    }

    @Override
    public boolean hasSubclasses() {
        return this.subclasses;
    }

    @Override
    public Class<T> getCandidateClass() {
        return this.candidateClass;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.ec;
    }

    public String toString() {
        return Localiser.msg("033002", this.candidateClass.getName(), "" + this.subclasses);
    }
}

