/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.banyandb.v1.client.grpc.channel;

import com.google.common.collect.ImmutableList;
import io.grpc.ManagedChannel;

import java.util.List;

public class FakeChannelFactory implements ChannelFactory {
    private int called = 0;
    private List<ManagedChannel> channels;

    public FakeChannelFactory(List<ManagedChannel> channels) {
        this.channels = channels;
    }

    public FakeChannelFactory(ManagedChannel... channels) {
        this.channels = ImmutableList.copyOf(channels);
    }

    @Override
    public ManagedChannel create() {
        return channels.get(called++);
    }
}
