/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppPagePerf;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppPageTraffic;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppPerf;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppPerfSource;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppSingleVersionPerf;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppSingleVersionTraffic;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppTraffic;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppTrafficCategory;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppTrafficSource;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.Source;

class BrowserPerfDataSourceBuilder {
    private final NamingControl namingControl;
    private String service;
    private String serviceVersion;
    private String patePath;
    private long timeBucket;
    private int redirectTime;
    private int dnsTime;
    private int ttfbTime;
    private int tcpTime;
    private int transTime;
    private int domAnalysisTime;
    private int fptTime;
    private int domReadyTime;
    private int loadPageTime;
    private int resTime;
    private int sslTime;
    private int ttlTime;
    private int firstPackTime;
    private int fmpTime;

    public void setService(String service) {
        this.service = this.namingControl.formatServiceName(service);
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = this.namingControl.formatInstanceName(serviceVersion);
    }

    public void setPatePath(String patePath) {
        this.patePath = this.namingControl.formatEndpointName(this.service, patePath);
    }

    private void toSource(Source source) {
        source.setTimeBucket(this.timeBucket);
    }

    private void toBrowserAppTrafficSource(BrowserAppTrafficSource source) {
        this.toSource((Source)source);
        source.setTrafficCategory(BrowserAppTrafficCategory.NORMAL);
    }

    BrowserAppTraffic toBrowserAppTraffic() {
        BrowserAppTraffic traffic = new BrowserAppTraffic();
        traffic.setName(this.service);
        this.toBrowserAppTrafficSource((BrowserAppTrafficSource)traffic);
        return traffic;
    }

    BrowserAppSingleVersionTraffic toBrowserAppSingleVersionTraffic() {
        BrowserAppSingleVersionTraffic traffic = new BrowserAppSingleVersionTraffic();
        traffic.setName(this.serviceVersion);
        traffic.setServiceName(this.service);
        this.toBrowserAppTrafficSource((BrowserAppTrafficSource)traffic);
        return traffic;
    }

    BrowserAppPageTraffic toBrowserAppPageTraffic() {
        BrowserAppPageTraffic traffic = new BrowserAppPageTraffic();
        traffic.setName(this.patePath);
        traffic.setServiceName(this.service);
        this.toBrowserAppTrafficSource((BrowserAppTrafficSource)traffic);
        return traffic;
    }

    private void toBrowserAppPerfSource(BrowserAppPerfSource source) {
        this.toSource((Source)source);
        source.setRedirectTime(this.redirectTime);
        source.setDnsTime(this.dnsTime);
        source.setTtfbTime(this.ttfbTime);
        source.setTcpTime(this.tcpTime);
        source.setTransTime(this.transTime);
        source.setDomAnalysisTime(this.domAnalysisTime);
        source.setFptTime(this.fptTime);
        source.setDomReadyTime(this.domReadyTime);
        source.setLoadPageTime(this.loadPageTime);
        source.setResTime(this.resTime);
        source.setSslTime(this.sslTime);
        source.setTtlTime(this.ttlTime);
        source.setFirstPackTime(this.firstPackTime);
        source.setFmpTime(this.fmpTime);
    }

    BrowserAppPerf toBrowserAppPerf() {
        BrowserAppPerf perf = new BrowserAppPerf();
        perf.setName(this.service);
        this.toBrowserAppPerfSource((BrowserAppPerfSource)perf);
        return perf;
    }

    BrowserAppSingleVersionPerf toBrowserAppSingleVersionPerf() {
        BrowserAppSingleVersionPerf perf = new BrowserAppSingleVersionPerf();
        perf.setName(this.serviceVersion);
        perf.setServiceName(this.service);
        this.toBrowserAppPerfSource((BrowserAppPerfSource)perf);
        return perf;
    }

    BrowserAppPagePerf toBrowserAppPagePerf() {
        BrowserAppPagePerf perf = new BrowserAppPagePerf();
        perf.setName(this.patePath);
        perf.setServiceName(this.service);
        this.toBrowserAppPerfSource((BrowserAppPerfSource)perf);
        return perf;
    }

    @Generated
    public BrowserPerfDataSourceBuilder(NamingControl namingControl) {
        this.namingControl = namingControl;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    @Generated
    public String getPatePath() {
        return this.patePath;
    }

    @Generated
    public void setTimeBucket(long timeBucket) {
        this.timeBucket = timeBucket;
    }

    @Generated
    public long getTimeBucket() {
        return this.timeBucket;
    }

    @Generated
    public void setRedirectTime(int redirectTime) {
        this.redirectTime = redirectTime;
    }

    @Generated
    public int getRedirectTime() {
        return this.redirectTime;
    }

    @Generated
    public void setDnsTime(int dnsTime) {
        this.dnsTime = dnsTime;
    }

    @Generated
    public int getDnsTime() {
        return this.dnsTime;
    }

    @Generated
    public void setTtfbTime(int ttfbTime) {
        this.ttfbTime = ttfbTime;
    }

    @Generated
    public int getTtfbTime() {
        return this.ttfbTime;
    }

    @Generated
    public void setTcpTime(int tcpTime) {
        this.tcpTime = tcpTime;
    }

    @Generated
    public int getTcpTime() {
        return this.tcpTime;
    }

    @Generated
    public void setTransTime(int transTime) {
        this.transTime = transTime;
    }

    @Generated
    public int getTransTime() {
        return this.transTime;
    }

    @Generated
    public void setDomAnalysisTime(int domAnalysisTime) {
        this.domAnalysisTime = domAnalysisTime;
    }

    @Generated
    public int getDomAnalysisTime() {
        return this.domAnalysisTime;
    }

    @Generated
    public void setFptTime(int fptTime) {
        this.fptTime = fptTime;
    }

    @Generated
    public int getFptTime() {
        return this.fptTime;
    }

    @Generated
    public void setDomReadyTime(int domReadyTime) {
        this.domReadyTime = domReadyTime;
    }

    @Generated
    public int getDomReadyTime() {
        return this.domReadyTime;
    }

    @Generated
    public void setLoadPageTime(int loadPageTime) {
        this.loadPageTime = loadPageTime;
    }

    @Generated
    public int getLoadPageTime() {
        return this.loadPageTime;
    }

    @Generated
    public void setResTime(int resTime) {
        this.resTime = resTime;
    }

    @Generated
    public int getResTime() {
        return this.resTime;
    }

    @Generated
    public void setSslTime(int sslTime) {
        this.sslTime = sslTime;
    }

    @Generated
    public int getSslTime() {
        return this.sslTime;
    }

    @Generated
    public void setTtlTime(int ttlTime) {
        this.ttlTime = ttlTime;
    }

    @Generated
    public int getTtlTime() {
        return this.ttlTime;
    }

    @Generated
    public void setFirstPackTime(int firstPackTime) {
        this.firstPackTime = firstPackTime;
    }

    @Generated
    public int getFirstPackTime() {
        return this.firstPackTime;
    }

    @Generated
    public void setFmpTime(int fmpTime) {
        this.fmpTime = fmpTime;
    }

    @Generated
    public int getFmpTime() {
        return this.fmpTime;
    }
}

