/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.internal.shared;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.sis.image.DataType;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.internal.shared.MultiBandsIndexColorModel;
import org.apache.sis.image.internal.shared.ScaledColorSpace;
import org.apache.sis.util.internal.shared.Numerics;

public final class ImageUtilities {
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.raster");
    private static final String[] TYPE_NAMES = new String[6];
    private static final byte[] NUMBER_ENUMS;

    private ImageUtilities() {
    }

    public static Shape getValidArea(RenderedImage image) {
        if (image instanceof PlanarImage) {
            return ((PlanarImage)image).getValidArea();
        }
        return ImageUtilities.getBounds(image);
    }

    public static Rectangle getBounds(RenderedImage image) {
        return new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
    }

    public static void clipBounds(RenderedImage image, Rectangle aoi) {
        int low = aoi.x;
        int min = image.getMinX();
        if (low < min) {
            aoi.x = min;
        }
        aoi.width = Numerics.clamp((long)(Math.min((long)min + (long)image.getWidth(), (long)low + (long)aoi.width) - (long)aoi.x));
        low = aoi.y;
        min = image.getMinY();
        if (low < min) {
            aoi.y = min;
        }
        aoi.height = Numerics.clamp((long)(Math.min((long)min + (long)image.getHeight(), (long)low + (long)aoi.height) - (long)aoi.y));
    }

    public static int getNumBands(RenderedImage image) {
        SampleModel sm;
        if (image != null && (sm = image.getSampleModel()) != null) {
            return sm.getNumBands();
        }
        return 0;
    }

    public static int getVisibleBand(RenderedImage image) {
        if (image != null) {
            SampleModel sm;
            ColorModel cm = image.getColorModel();
            if (cm != null) {
                if (cm instanceof MultiBandsIndexColorModel) {
                    return ((MultiBandsIndexColorModel)cm).visibleBand;
                }
                ColorSpace cs = cm.getColorSpace();
                if (cs instanceof ScaledColorSpace) {
                    return ((ScaledColorSpace)cs).visibleBand;
                }
            }
            if ((sm = image.getSampleModel()) != null && sm.getNumBands() == 1) {
                return 0;
            }
        }
        return -1;
    }

    public static int getVisibleBand(IndexColorModel cm) {
        if (cm instanceof MultiBandsIndexColorModel) {
            return ((MultiBandsIndexColorModel)cm).visibleBand;
        }
        return 0;
    }

    public static String getDataTypeName(SampleModel sm) {
        int type;
        if (sm != null && (type = sm.getDataType()) >= 0 && type < TYPE_NAMES.length) {
            return TYPE_NAMES[type];
        }
        return null;
    }

    public static short getTransparencyDescription(ColorModel cm) {
        if (cm != null) {
            if (cm.hasAlpha()) {
                return 33;
            }
            switch (cm.getTransparency()) {
                case 2: 
                case 3: {
                    return 32;
                }
                case 1: {
                    return 34;
                }
            }
        }
        return 0;
    }

    public static short[] bandNames(ColorModel cm, SampleModel sm) {
        ColorSpace cs;
        int n = sm.getNumBands();
        short[] keys = new short[n];
        if (cm instanceof IndexColorModel) {
            int visibleBand = 0;
            if (cm instanceof MultiBandsIndexColorModel) {
                visibleBand = ((MultiBandsIndexColorModel)cm).visibleBand;
            }
            if (visibleBand < n) {
                keys[visibleBand] = 30;
            }
        } else if (cm != null && (cs = cm.getColorSpace()) != null) {
            switch (cs.getType()) {
                case 9: {
                    if (n >= 4) {
                        keys[3] = 17;
                    }
                }
                case 11: {
                    switch (n) {
                        default: {
                            keys[2] = 227;
                        }
                        case 2: {
                            keys[1] = 124;
                        }
                        case 1: {
                            keys[0] = 45;
                        }
                        case 0: 
                    }
                    break;
                }
                case 5: {
                    switch (n) {
                        default: {
                            keys[2] = 18;
                        }
                        case 2: {
                            keys[1] = 96;
                        }
                        case 1: {
                            keys[0] = 167;
                        }
                        case 0: 
                    }
                    break;
                }
                case 6: {
                    if (n == 0) break;
                    keys[0] = 95;
                }
            }
            int nc = cm.getNumColorComponents();
            if (nc < n && nc < cm.getNumComponents()) {
                keys[nc] = 201;
            }
            int[] m1 = null;
            int[] m2 = null;
            if (cm instanceof PackedColorModel) {
                m1 = ((PackedColorModel)cm).getMasks();
            }
            if (sm instanceof SinglePixelPackedSampleModel) {
                m2 = ((SinglePixelPackedSampleModel)sm).getBitMasks();
            }
            if (!Arrays.equals(m1, m2)) {
                LOGGER.warning("Band names may be in wrong order.");
            }
        }
        return keys;
    }

    public static byte toNumberEnum(DataType type) {
        return NUMBER_ENUMS[type.toDataBufferType()];
    }

    public static boolean isIntegerType(int dataType) {
        return dataType >= 0 && dataType <= 3;
    }

    public static boolean isLosslessConversion(SampleModel source, SampleModel target) {
        if (source != target) {
            int numBands = source.getNumBands();
            if (target.getNumBands() < numBands) {
                return false;
            }
            boolean sourceIsInteger = ImageUtilities.isIntegerType(source.getDataType());
            boolean targetIsInteger = ImageUtilities.isIntegerType(target.getDataType());
            if (targetIsInteger && !sourceIsInteger) {
                return false;
            }
            boolean hasSameSize = false;
            for (int i = 0; i < numBands; ++i) {
                int d = target.getSampleSize(i) - source.getSampleSize(i);
                hasSameSize |= d == 0;
                if (d >= 0) continue;
                return false;
            }
            if (hasSameSize && (sourceIsInteger != targetIsInteger || DataType.isUnsigned(source) != DataType.isUnsigned(target))) {
                return false;
            }
        }
        return true;
    }

    public static int pixelToTileX(RenderedImage image, int x) {
        return Math.toIntExact(Math.floorDiv((long)x - (long)image.getTileGridXOffset(), image.getTileWidth()));
    }

    public static int pixelToTileY(RenderedImage image, int y) {
        return Math.toIntExact(Math.floorDiv((long)y - (long)image.getTileGridYOffset(), image.getTileHeight()));
    }

    public static int tileToPixelX(RenderedImage image, int tileX) {
        return Math.toIntExact(Math.multiplyFull(tileX, image.getTileWidth()) + (long)image.getTileGridXOffset());
    }

    public static int tileToPixelY(RenderedImage image, int tileY) {
        return Math.toIntExact(Math.multiplyFull(tileY, image.getTileHeight()) + (long)image.getTileGridYOffset());
    }

    public static Rectangle pixelsToTiles(RenderedImage image, Rectangle pixels) {
        Rectangle r = new Rectangle();
        if (!pixels.isEmpty()) {
            int size = image.getTileWidth();
            long offset = image.getTileGridXOffset();
            long shifted = (long)pixels.x - offset;
            r.x = Math.toIntExact(Math.floorDiv(shifted, size));
            r.width = Math.toIntExact(Math.floorDiv(shifted + (long)(pixels.width - 1), size) - (long)r.x + 1L);
            size = image.getTileHeight();
            offset = image.getTileGridYOffset();
            shifted = (long)pixels.y - offset;
            r.y = Math.toIntExact(Math.floorDiv(shifted, size));
            r.height = Math.toIntExact(Math.floorDiv(shifted + (long)(pixels.height - 1), size) - (long)r.y + 1L);
        }
        return r;
    }

    public static Rectangle tilesToPixels(RenderedImage image, Rectangle tiles) {
        Rectangle r = new Rectangle();
        if (!tiles.isEmpty()) {
            int size = image.getTileWidth();
            int offset = image.getTileGridXOffset();
            r.x = Math.toIntExact(Math.multiplyFull(tiles.x, size) + (long)offset);
            r.width = Math.toIntExact(((long)tiles.x + (long)tiles.width) * (long)size + (long)offset - (long)r.x);
            size = image.getTileHeight();
            offset = image.getTileGridYOffset();
            r.y = Math.toIntExact(Math.multiplyFull(tiles.y, size) + (long)offset);
            r.height = Math.toIntExact(((long)tiles.y + (long)tiles.height) * (long)size + (long)offset - (long)r.y);
        }
        return r;
    }

    public static Rectangle convertTileIndices(RenderedImage source, RenderedImage target, Rectangle tiles) {
        Rectangle pixels = ImageUtilities.tilesToPixels(source, tiles);
        ImageUtilities.clipBounds(target, pixels);
        return ImageUtilities.pixelsToTiles(target, pixels);
    }

    public static boolean roundIfAlmostInteger(AffineTransform tr) {
        double d;
        double r = tr.getScaleX();
        double m00 = Math.rint(r);
        if (Math.abs(d - r) <= 1.0E-13) {
            double d2;
            r = tr.getShearX();
            double m01 = Math.rint(r);
            if (Math.abs(d2 - r) <= 1.0E-13) {
                double d3;
                r = tr.getScaleY();
                double m11 = Math.rint(r);
                if (Math.abs(d3 - r) <= 1.0E-13) {
                    double d4;
                    r = tr.getShearY();
                    double m10 = Math.rint(r);
                    if (!(!(Math.abs(d4 - r) <= 1.0E-13) || m00 == 0.0 && m01 == 0.0 || m10 == 0.0 && m11 == 0.0)) {
                        double m02 = Math.rint(tr.getTranslateX());
                        double m12 = Math.rint(tr.getTranslateY());
                        tr.setTransform(m00, m10, m01, m11, m02, m12);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static {
        ImageUtilities.TYPE_NAMES[0] = "byte";
        ImageUtilities.TYPE_NAMES[2] = "short";
        ImageUtilities.TYPE_NAMES[1] = "ushort";
        ImageUtilities.TYPE_NAMES[3] = "int";
        ImageUtilities.TYPE_NAMES[4] = "float";
        ImageUtilities.TYPE_NAMES[5] = "double";
        NUMBER_ENUMS = new byte[]{3, 4, 4, 5, 8, 9};
    }
}

