/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.http;

import com.huaweicloud.lts.producer.exception.ClientException;
import com.huaweicloud.lts.producer.http.RepeatableInputStreamEntity;
import com.huaweicloud.lts.producer.http.ServiceClient;
import com.huaweicloud.lts.producer.model.http.HttpMethod;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

class HttpRequestFactory {
    HttpRequestFactory() {
    }

    public HttpRequestBase createHttpRequest(ServiceClient.Request request, String charset) {
        HttpPost httpRequest;
        String uri = request.getUri();
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request.getContent() != null) {
                request.setUrl(postMethod.getURI().getPath());
                postMethod.setEntity((HttpEntity)new RepeatableInputStreamEntity(request));
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            if (request.getContent() != null) {
                putMethod.setEntity((HttpEntity)new RepeatableInputStreamEntity(request));
            }
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }
        this.configureRequestHeaders(request, charset, (HttpRequestBase)httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(ServiceClient.Request request, String charset, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + charset.toLowerCase(Locale.ENGLISH));
        }
    }
}

