/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.okhttp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import shade.polaris.com.google.common.annotations.VisibleForTesting;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shade.polaris.com.google.errorprone.annotations.DoNotCall;
import shade.polaris.io.grpc.ChoiceServerCredentials;
import shade.polaris.io.grpc.ExperimentalApi;
import shade.polaris.io.grpc.ForwardingServerBuilder;
import shade.polaris.io.grpc.InsecureServerCredentials;
import shade.polaris.io.grpc.Internal;
import shade.polaris.io.grpc.ServerBuilder;
import shade.polaris.io.grpc.ServerCredentials;
import shade.polaris.io.grpc.ServerStreamTracer;
import shade.polaris.io.grpc.TlsServerCredentials;
import shade.polaris.io.grpc.internal.FixedObjectPool;
import shade.polaris.io.grpc.internal.GrpcUtil;
import shade.polaris.io.grpc.internal.InternalServer;
import shade.polaris.io.grpc.internal.KeepAliveManager;
import shade.polaris.io.grpc.internal.ObjectPool;
import shade.polaris.io.grpc.internal.ServerImplBuilder;
import shade.polaris.io.grpc.internal.SharedResourcePool;
import shade.polaris.io.grpc.internal.TransportTracer;
import shade.polaris.io.grpc.okhttp.HandshakerSocketFactory;
import shade.polaris.io.grpc.okhttp.OkHttpChannelBuilder;
import shade.polaris.io.grpc.okhttp.OkHttpServer;
import shade.polaris.io.grpc.okhttp.PlaintextHandshakerSocketFactory;
import shade.polaris.io.grpc.okhttp.SslSocketFactoryServerCredentials;
import shade.polaris.io.grpc.okhttp.TlsServerHandshakerSocketFactory;
import shade.polaris.io.grpc.okhttp.internal.Platform;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public final class OkHttpServerBuilder
extends ForwardingServerBuilder<OkHttpServerBuilder> {
    private static final Logger log = Logger.getLogger(OkHttpServerBuilder.class.getName());
    private static final int DEFAULT_FLOW_CONTROL_WINDOW = 65535;
    static final long MAX_CONNECTION_IDLE_NANOS_DISABLED = Long.MAX_VALUE;
    private static final long MIN_MAX_CONNECTION_IDLE_NANO = TimeUnit.SECONDS.toNanos(1L);
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private static final ObjectPool<Executor> DEFAULT_TRANSPORT_EXECUTOR_POOL = OkHttpChannelBuilder.DEFAULT_TRANSPORT_EXECUTOR_POOL;
    final ServerImplBuilder serverImplBuilder = new ServerImplBuilder(this::buildTransportServers);
    final SocketAddress listenAddress;
    final HandshakerSocketFactory handshakerSocketFactory;
    TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    ObjectPool<Executor> transportExecutorPool = DEFAULT_TRANSPORT_EXECUTOR_POOL;
    ObjectPool<ScheduledExecutorService> scheduledExecutorServicePool = SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE);
    ServerSocketFactory socketFactory = ServerSocketFactory.getDefault();
    long keepAliveTimeNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIME_NANOS;
    long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS;
    int flowControlWindow = 65535;
    int maxInboundMetadataSize = 8192;
    int maxInboundMessageSize = 0x400000;
    long maxConnectionIdleInNanos = Long.MAX_VALUE;
    boolean permitKeepAliveWithoutCalls;
    long permitKeepAliveTimeInNanos = TimeUnit.MINUTES.toNanos(5L);
    private static final EnumSet<TlsServerCredentials.Feature> understoodTlsFeatures = EnumSet.of(TlsServerCredentials.Feature.MTLS, TlsServerCredentials.Feature.CUSTOM_MANAGERS);

    @Deprecated
    @DoNotCall(value="Always throws. Use forPort(int, ServerCredentials) instead")
    public static OkHttpServerBuilder forPort(int port) {
        throw new UnsupportedOperationException();
    }

    public static OkHttpServerBuilder forPort(int port, ServerCredentials creds) {
        return OkHttpServerBuilder.forPort(new InetSocketAddress(port), creds);
    }

    public static OkHttpServerBuilder forPort(SocketAddress address, ServerCredentials creds) {
        HandshakerSocketFactoryResult result = OkHttpServerBuilder.handshakerSocketFactoryFrom(creds);
        if (result.error != null) {
            throw new IllegalArgumentException(result.error);
        }
        return new OkHttpServerBuilder(address, result.factory);
    }

    @VisibleForTesting
    OkHttpServerBuilder(SocketAddress address, HandshakerSocketFactory handshakerSocketFactory) {
        this.listenAddress = Preconditions.checkNotNull(address, "address");
        this.handshakerSocketFactory = Preconditions.checkNotNull(handshakerSocketFactory, "handshakerSocketFactory");
    }

    @Override
    @Internal
    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    OkHttpServerBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    public OkHttpServerBuilder transportExecutor(Executor transportExecutor) {
        this.transportExecutorPool = transportExecutor == null ? DEFAULT_TRANSPORT_EXECUTOR_POOL : new FixedObjectPool<Executor>(transportExecutor);
        return this;
    }

    public OkHttpServerBuilder socketFactory(ServerSocketFactory socketFactory) {
        this.socketFactory = socketFactory == null ? ServerSocketFactory.getDefault() : socketFactory;
        return this;
    }

    @Override
    public OkHttpServerBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTime > 0L, "keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    @Override
    public OkHttpServerBuilder maxConnectionIdle(long maxConnectionIdle, TimeUnit timeUnit) {
        Preconditions.checkArgument(maxConnectionIdle > 0L, "max connection idle must be positive: %s", maxConnectionIdle);
        this.maxConnectionIdleInNanos = timeUnit.toNanos(maxConnectionIdle);
        if (this.maxConnectionIdleInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionIdleInNanos = Long.MAX_VALUE;
        }
        if (this.maxConnectionIdleInNanos < MIN_MAX_CONNECTION_IDLE_NANO) {
            this.maxConnectionIdleInNanos = MIN_MAX_CONNECTION_IDLE_NANO;
        }
        return this;
    }

    @Override
    public OkHttpServerBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTimeout > 0L, "keepalive timeout must be positive");
        this.keepAliveTimeoutNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos(this.keepAliveTimeoutNanos);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public OkHttpServerBuilder permitKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTime >= 0L, "permit keepalive time must be non-negative: %s", keepAliveTime);
        this.permitKeepAliveTimeInNanos = timeUnit.toNanos(keepAliveTime);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public OkHttpServerBuilder permitKeepAliveWithoutCalls(boolean permit) {
        this.permitKeepAliveWithoutCalls = permit;
        return this;
    }

    public OkHttpServerBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkState(flowControlWindow > 0, "flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    public OkHttpServerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorServicePool = new FixedObjectPool<ScheduledExecutorService>(Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService"));
        return this;
    }

    @Override
    public OkHttpServerBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    @Override
    public OkHttpServerBuilder maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument(bytes >= 0, "negative max bytes");
        this.maxInboundMessageSize = bytes;
        return this;
    }

    void setStatsEnabled(boolean value) {
        this.serverImplBuilder.setStatsEnabled(value);
    }

    InternalServer buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        return new OkHttpServer(this, streamTracerFactories, this.serverImplBuilder.getChannelz());
    }

    static HandshakerSocketFactoryResult handshakerSocketFactoryFrom(ServerCredentials creds) {
        if (creds instanceof TlsServerCredentials) {
            SSLContext sslContext;
            TlsServerCredentials tlsCreds = (TlsServerCredentials)creds;
            Set<TlsServerCredentials.Feature> incomprehensible = tlsCreds.incomprehensible(understoodTlsFeatures);
            if (!incomprehensible.isEmpty()) {
                return HandshakerSocketFactoryResult.error("TLS features not understood: " + incomprehensible);
            }
            KeyManager[] km = null;
            if (tlsCreds.getKeyManagers() != null) {
                km = tlsCreds.getKeyManagers().toArray(new KeyManager[0]);
            } else if (tlsCreds.getPrivateKey() != null) {
                if (tlsCreds.getPrivateKeyPassword() != null) {
                    return HandshakerSocketFactoryResult.error("byte[]-based private key with password unsupported. Use unencrypted file or KeyManager");
                }
                try {
                    km = OkHttpChannelBuilder.createKeyManager(tlsCreds.getCertificateChain(), tlsCreds.getPrivateKey());
                }
                catch (GeneralSecurityException gse) {
                    log.log(Level.FINE, "Exception loading private key from credential", gse);
                    return HandshakerSocketFactoryResult.error("Unable to load private key: " + gse.getMessage());
                }
            }
            TrustManager[] tm = null;
            if (tlsCreds.getTrustManagers() != null) {
                tm = tlsCreds.getTrustManagers().toArray(new TrustManager[0]);
            } else if (tlsCreds.getRootCertificates() != null) {
                try {
                    tm = OkHttpChannelBuilder.createTrustManager(tlsCreds.getRootCertificates());
                }
                catch (GeneralSecurityException gse) {
                    log.log(Level.FINE, "Exception loading root certificates from credential", gse);
                    return HandshakerSocketFactoryResult.error("Unable to load root certificates: " + gse.getMessage());
                }
            }
            try {
                sslContext = SSLContext.getInstance("TLS", Platform.get().getProvider());
                sslContext.init(km, tm, null);
            }
            catch (GeneralSecurityException gse) {
                throw new RuntimeException("TLS Provider failure", gse);
            }
            return HandshakerSocketFactoryResult.factory(new TlsServerHandshakerSocketFactory(new SslSocketFactoryServerCredentials.ServerCredentials(sslContext.getSocketFactory())));
        }
        if (creds instanceof InsecureServerCredentials) {
            return HandshakerSocketFactoryResult.factory(new PlaintextHandshakerSocketFactory());
        }
        if (creds instanceof SslSocketFactoryServerCredentials.ServerCredentials) {
            SslSocketFactoryServerCredentials.ServerCredentials factoryCreds = (SslSocketFactoryServerCredentials.ServerCredentials)creds;
            return HandshakerSocketFactoryResult.factory(new TlsServerHandshakerSocketFactory(factoryCreds));
        }
        if (creds instanceof ChoiceServerCredentials) {
            ChoiceServerCredentials choiceCreds = (ChoiceServerCredentials)creds;
            StringBuilder error = new StringBuilder();
            for (ServerCredentials innerCreds : choiceCreds.getCredentialsList()) {
                HandshakerSocketFactoryResult result = OkHttpServerBuilder.handshakerSocketFactoryFrom(innerCreds);
                if (result.error == null) {
                    return result;
                }
                error.append(", ");
                error.append(result.error);
            }
            return HandshakerSocketFactoryResult.error(error.substring(2));
        }
        return HandshakerSocketFactoryResult.error("Unsupported credential type: " + creds.getClass().getName());
    }

    static final class HandshakerSocketFactoryResult {
        public final HandshakerSocketFactory factory;
        public final String error;

        private HandshakerSocketFactoryResult(HandshakerSocketFactory factory2, String error) {
            this.factory = factory2;
            this.error = error;
        }

        public static HandshakerSocketFactoryResult error(String error) {
            return new HandshakerSocketFactoryResult(null, Preconditions.checkNotNull(error, "error"));
        }

        public static HandshakerSocketFactoryResult factory(HandshakerSocketFactory factory2) {
            return new HandshakerSocketFactoryResult(Preconditions.checkNotNull(factory2, "factory"), null);
        }
    }
}

