/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.collect.ImmutableList;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class RFC3339DateTimeAttribute
extends AbstractFormatAttribute {
    private static final ImmutableList<String> RFC3339_FORMATS = ImmutableList.of((Object)"yyyy-MM-dd'T'HH:mm:ss((+|-)HH:mm|Z)", (Object)"yyyy-MM-dd'T'HH:mm:ss.[0-9]{1,12}((+|-)HH:mm|Z)");
    private static final DateTimeFormatter FORMATTER;
    private static final FormatAttribute INSTANCE;

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private RFC3339DateTimeAttribute() {
        super("date-time", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String value = data.getInstance().getNode().textValue();
        try {
            FORMATTER.parseDateTime(value);
            String secFracsAndOffset = value.substring("yyyy-MM-ddTHH:mm:ss".length());
            String offset = !secFracsAndOffset.startsWith(".") ? secFracsAndOffset : (secFracsAndOffset.contains("Z") ? secFracsAndOffset.substring(secFracsAndOffset.indexOf("Z")) : (secFracsAndOffset.contains("+") ? secFracsAndOffset.substring(secFracsAndOffset.indexOf("+")) : secFracsAndOffset.substring(secFracsAndOffset.indexOf("-"))));
            if (!this.isOffSetStrictRFC3339(offset)) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(data, bundle, "err.format.invalidDate").putArgument("value", (Object)value).putArgument("expected", RFC3339_FORMATS));
        }
    }

    private boolean isOffSetStrictRFC3339(String offset) {
        if (offset.endsWith("Z")) {
            return true;
        }
        return offset.length() == 6 && offset.contains(":");
    }

    static {
        DateTimeParser secFracsParser = new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(1, 12).toParser();
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendOptional(secFracsParser).appendTimeZoneOffset("Z", true, 2, 2);
        FORMATTER = builder.toFormatter();
        INSTANCE = new RFC3339DateTimeAttribute();
    }
}

