/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.FloatSetter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class FloatReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (Float.TYPE.equals(javaType.getRawClass())) {
            return new FloatPrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Float.class.equals((Object)javaType.getRawClass()) || javaType.isJavaLangObject()) {
            return new FloatSchema(protoField, propertyDescriptor);
        }
        ProtoUtils.throwNotSupportMerge(protoField, propertyDescriptor.getJavaType());
        return null;
    }

    private static class FloatPrimitiveSchema<T>
    extends FieldSchema<T> {
        private final FloatSetter<T> setter;

        public FloatPrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (FloatSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            float value = input.readFloat();
            this.setter.set(message, value);
            return input.readFieldNumber();
        }
    }

    private static class FloatSchema<T>
    extends FieldSchema<T> {
        private final Setter<T, Float> setter;

        public FloatSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (Setter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            float value = input.readFloat();
            this.setter.set(message, (Object)Float.valueOf(value));
            return input.readFieldNumber();
        }
    }
}

