/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.response;

import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.util.ReflectionUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.servlet.http.Part;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.extend.PropertyModelConverterExt;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.ResponseTypeProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;

public class DefaultResponseTypeProcessor
implements ResponseTypeProcessor {
    protected boolean extractActualType;

    @Override
    public Type getProcessType() {
        return null;
    }

    @Override
    public Type extractResponseType(SwaggerGenerator swaggerGenerator, OperationGenerator operationGenerator, Type genericResponseType) {
        if (this.extractActualType) {
            genericResponseType = ((ParameterizedType)genericResponseType).getActualTypeArguments()[0];
        }
        return this.doExtractResponseType(genericResponseType);
    }

    private Type doExtractResponseType(Type genericResponseType) {
        ResponseTypeProcessor processor;
        if (!(genericResponseType instanceof ParameterizedType)) {
            return genericResponseType;
        }
        Type responseRawType = genericResponseType;
        if (genericResponseType instanceof ParameterizedType) {
            responseRawType = ((ParameterizedType)genericResponseType).getRawType();
        }
        if (responseRawType.equals((processor = SwaggerGeneratorUtils.findResponseTypeProcessor(responseRawType)).getProcessType())) {
            return processor.extractResponseType(genericResponseType);
        }
        return genericResponseType;
    }

    @Override
    public Model process(SwaggerGenerator swaggerGenerator, OperationGenerator operationGenerator, Type genericResponseType) {
        Object responseType = this.extractResponseType(swaggerGenerator, operationGenerator, genericResponseType);
        if (responseType == null || ReflectionUtils.isVoid((Type)responseType)) {
            return null;
        }
        if (responseType instanceof Class && Part.class.isAssignableFrom((Class)responseType)) {
            responseType = Part.class;
        }
        SwaggerUtils.addDefinitions(swaggerGenerator.getSwagger(), (Type)responseType);
        Property property = ModelConverters.getInstance().readAsProperty((Type)responseType);
        return PropertyModelConverterExt.toModel(property);
    }
}

