/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.internal.util.Preconditions;
import java.util.Collections;
import java.util.Map;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.common.config.server.QueueType;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;
import org.apache.seatunnel.engine.common.config.server.SlotServiceConfig;
import org.apache.seatunnel.engine.common.config.server.ThreadShareMode;

public class EngineConfig {
    private int backupCount = ServerConfigOptions.BACKUP_COUNT.defaultValue();
    private int printExecutionInfoInterval = ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL.defaultValue();
    private int printJobMetricsInfoInterval = ServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL.defaultValue();
    private int jobMetricsBackupInterval = ServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL.defaultValue();
    private ThreadShareMode taskExecutionThreadShareMode = ServerConfigOptions.TASK_EXECUTION_THREAD_SHARE_MODE.defaultValue();
    private SlotServiceConfig slotServiceConfig = ServerConfigOptions.SLOT_SERVICE.defaultValue();
    private CheckpointConfig checkpointConfig = ServerConfigOptions.CHECKPOINT.defaultValue();
    private ConnectorJarStorageConfig connectorJarStorageConfig = ServerConfigOptions.CONNECTOR_JAR_STORAGE_CONFIG.defaultValue();
    private boolean classloaderCacheMode = ServerConfigOptions.CLASSLOADER_CACHE_MODE.defaultValue();
    private QueueType queueType = ServerConfigOptions.QUEUE_TYPE.defaultValue();
    private int historyJobExpireMinutes = ServerConfigOptions.HISTORY_JOB_EXPIRE_MINUTES.defaultValue();
    private String eventReportHttpApi;
    private Map<String, String> eventReportHttpHeaders = Collections.emptyMap();

    public void setBackupCount(int newBackupCount) {
        Preconditions.checkBackupCount(newBackupCount, 0);
        this.backupCount = newBackupCount;
    }

    public void setPrintExecutionInfoInterval(int printExecutionInfoInterval) {
        Preconditions.checkPositive(printExecutionInfoInterval, ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL + " must be > 0");
        this.printExecutionInfoInterval = printExecutionInfoInterval;
    }

    public void setPrintJobMetricsInfoInterval(int printJobMetricsInfoInterval) {
        Preconditions.checkPositive(printJobMetricsInfoInterval, ServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL + " must be > 0");
        this.printJobMetricsInfoInterval = printJobMetricsInfoInterval;
    }

    public void setJobMetricsBackupInterval(int jobMetricsBackupInterval) {
        Preconditions.checkPositive(jobMetricsBackupInterval, ServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL + " must be > 0");
        this.jobMetricsBackupInterval = jobMetricsBackupInterval;
    }

    public void setTaskExecutionThreadShareMode(ThreadShareMode taskExecutionThreadShareMode) {
        Preconditions.checkNotNull(this.queueType);
        this.taskExecutionThreadShareMode = taskExecutionThreadShareMode;
    }

    public void setHistoryJobExpireMinutes(int historyJobExpireMinutes) {
        Preconditions.checkPositive(historyJobExpireMinutes, ServerConfigOptions.HISTORY_JOB_EXPIRE_MINUTES + " must be > 0");
        this.historyJobExpireMinutes = historyJobExpireMinutes;
    }

    public EngineConfig setQueueType(QueueType queueType) {
        Preconditions.checkNotNull(queueType);
        this.queueType = queueType;
        return this;
    }

    public EngineConfig setEventReportHttpApi(String eventReportHttpApi) {
        this.eventReportHttpApi = eventReportHttpApi;
        return this;
    }

    public EngineConfig setEventReportHttpHeaders(Map<String, String> eventReportHttpHeaders) {
        this.eventReportHttpHeaders = eventReportHttpHeaders;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getPrintExecutionInfoInterval() {
        return this.printExecutionInfoInterval;
    }

    public int getPrintJobMetricsInfoInterval() {
        return this.printJobMetricsInfoInterval;
    }

    public int getJobMetricsBackupInterval() {
        return this.jobMetricsBackupInterval;
    }

    public ThreadShareMode getTaskExecutionThreadShareMode() {
        return this.taskExecutionThreadShareMode;
    }

    public SlotServiceConfig getSlotServiceConfig() {
        return this.slotServiceConfig;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public ConnectorJarStorageConfig getConnectorJarStorageConfig() {
        return this.connectorJarStorageConfig;
    }

    public boolean isClassloaderCacheMode() {
        return this.classloaderCacheMode;
    }

    public QueueType getQueueType() {
        return this.queueType;
    }

    public int getHistoryJobExpireMinutes() {
        return this.historyJobExpireMinutes;
    }

    public String getEventReportHttpApi() {
        return this.eventReportHttpApi;
    }

    public Map<String, String> getEventReportHttpHeaders() {
        return this.eventReportHttpHeaders;
    }

    public void setSlotServiceConfig(SlotServiceConfig slotServiceConfig) {
        this.slotServiceConfig = slotServiceConfig;
    }

    public void setCheckpointConfig(CheckpointConfig checkpointConfig) {
        this.checkpointConfig = checkpointConfig;
    }

    public void setConnectorJarStorageConfig(ConnectorJarStorageConfig connectorJarStorageConfig) {
        this.connectorJarStorageConfig = connectorJarStorageConfig;
    }

    public void setClassloaderCacheMode(boolean classloaderCacheMode) {
        this.classloaderCacheMode = classloaderCacheMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngineConfig)) {
            return false;
        }
        EngineConfig other = (EngineConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBackupCount() != other.getBackupCount()) {
            return false;
        }
        if (this.getPrintExecutionInfoInterval() != other.getPrintExecutionInfoInterval()) {
            return false;
        }
        if (this.getPrintJobMetricsInfoInterval() != other.getPrintJobMetricsInfoInterval()) {
            return false;
        }
        if (this.getJobMetricsBackupInterval() != other.getJobMetricsBackupInterval()) {
            return false;
        }
        if (this.isClassloaderCacheMode() != other.isClassloaderCacheMode()) {
            return false;
        }
        if (this.getHistoryJobExpireMinutes() != other.getHistoryJobExpireMinutes()) {
            return false;
        }
        ThreadShareMode this$taskExecutionThreadShareMode = this.getTaskExecutionThreadShareMode();
        ThreadShareMode other$taskExecutionThreadShareMode = other.getTaskExecutionThreadShareMode();
        if (this$taskExecutionThreadShareMode == null ? other$taskExecutionThreadShareMode != null : !((Object)((Object)this$taskExecutionThreadShareMode)).equals((Object)other$taskExecutionThreadShareMode)) {
            return false;
        }
        SlotServiceConfig this$slotServiceConfig = this.getSlotServiceConfig();
        SlotServiceConfig other$slotServiceConfig = other.getSlotServiceConfig();
        if (this$slotServiceConfig == null ? other$slotServiceConfig != null : !((Object)this$slotServiceConfig).equals(other$slotServiceConfig)) {
            return false;
        }
        CheckpointConfig this$checkpointConfig = this.getCheckpointConfig();
        CheckpointConfig other$checkpointConfig = other.getCheckpointConfig();
        if (this$checkpointConfig == null ? other$checkpointConfig != null : !((Object)this$checkpointConfig).equals(other$checkpointConfig)) {
            return false;
        }
        ConnectorJarStorageConfig this$connectorJarStorageConfig = this.getConnectorJarStorageConfig();
        ConnectorJarStorageConfig other$connectorJarStorageConfig = other.getConnectorJarStorageConfig();
        if (this$connectorJarStorageConfig == null ? other$connectorJarStorageConfig != null : !((Object)this$connectorJarStorageConfig).equals(other$connectorJarStorageConfig)) {
            return false;
        }
        QueueType this$queueType = this.getQueueType();
        QueueType other$queueType = other.getQueueType();
        if (this$queueType == null ? other$queueType != null : !((Object)((Object)this$queueType)).equals((Object)other$queueType)) {
            return false;
        }
        String this$eventReportHttpApi = this.getEventReportHttpApi();
        String other$eventReportHttpApi = other.getEventReportHttpApi();
        if (this$eventReportHttpApi == null ? other$eventReportHttpApi != null : !this$eventReportHttpApi.equals(other$eventReportHttpApi)) {
            return false;
        }
        Map<String, String> this$eventReportHttpHeaders = this.getEventReportHttpHeaders();
        Map<String, String> other$eventReportHttpHeaders = other.getEventReportHttpHeaders();
        return !(this$eventReportHttpHeaders == null ? other$eventReportHttpHeaders != null : !((Object)this$eventReportHttpHeaders).equals(other$eventReportHttpHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngineConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBackupCount();
        result = result * 59 + this.getPrintExecutionInfoInterval();
        result = result * 59 + this.getPrintJobMetricsInfoInterval();
        result = result * 59 + this.getJobMetricsBackupInterval();
        result = result * 59 + (this.isClassloaderCacheMode() ? 79 : 97);
        result = result * 59 + this.getHistoryJobExpireMinutes();
        ThreadShareMode $taskExecutionThreadShareMode = this.getTaskExecutionThreadShareMode();
        result = result * 59 + ($taskExecutionThreadShareMode == null ? 43 : ((Object)((Object)$taskExecutionThreadShareMode)).hashCode());
        SlotServiceConfig $slotServiceConfig = this.getSlotServiceConfig();
        result = result * 59 + ($slotServiceConfig == null ? 43 : ((Object)$slotServiceConfig).hashCode());
        CheckpointConfig $checkpointConfig = this.getCheckpointConfig();
        result = result * 59 + ($checkpointConfig == null ? 43 : ((Object)$checkpointConfig).hashCode());
        ConnectorJarStorageConfig $connectorJarStorageConfig = this.getConnectorJarStorageConfig();
        result = result * 59 + ($connectorJarStorageConfig == null ? 43 : ((Object)$connectorJarStorageConfig).hashCode());
        QueueType $queueType = this.getQueueType();
        result = result * 59 + ($queueType == null ? 43 : ((Object)((Object)$queueType)).hashCode());
        String $eventReportHttpApi = this.getEventReportHttpApi();
        result = result * 59 + ($eventReportHttpApi == null ? 43 : $eventReportHttpApi.hashCode());
        Map<String, String> $eventReportHttpHeaders = this.getEventReportHttpHeaders();
        result = result * 59 + ($eventReportHttpHeaders == null ? 43 : ((Object)$eventReportHttpHeaders).hashCode());
        return result;
    }

    public String toString() {
        return "EngineConfig(backupCount=" + this.getBackupCount() + ", printExecutionInfoInterval=" + this.getPrintExecutionInfoInterval() + ", printJobMetricsInfoInterval=" + this.getPrintJobMetricsInfoInterval() + ", jobMetricsBackupInterval=" + this.getJobMetricsBackupInterval() + ", taskExecutionThreadShareMode=" + (Object)((Object)this.getTaskExecutionThreadShareMode()) + ", slotServiceConfig=" + this.getSlotServiceConfig() + ", checkpointConfig=" + this.getCheckpointConfig() + ", connectorJarStorageConfig=" + this.getConnectorJarStorageConfig() + ", classloaderCacheMode=" + this.isClassloaderCacheMode() + ", queueType=" + (Object)((Object)this.getQueueType()) + ", historyJobExpireMinutes=" + this.getHistoryJobExpireMinutes() + ", eventReportHttpApi=" + this.getEventReportHttpApi() + ", eventReportHttpHeaders=" + this.getEventReportHttpHeaders() + ")";
    }
}

