/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore.expiry;

import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import java.util.concurrent.TimeUnit;

public class ExpiryMetadataImpl
implements ExpiryMetadata {
    private int ttl;
    private int maxIdle;
    private int lastUpdateTime;
    private volatile int expirationTime;

    public ExpiryMetadataImpl() {
    }

    public ExpiryMetadataImpl(long ttl, long maxIdle, long expirationTime, long lastUpdateTime) {
        this.setTtl(ttl);
        this.setMaxIdle(maxIdle);
        this.setExpirationTime(expirationTime);
        this.setLastUpdateTime(lastUpdateTime);
    }

    @Override
    public long getTtl() {
        return this.ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.SECONDS.toMillis(this.ttl);
    }

    @Override
    public int getRawTtl() {
        return this.ttl;
    }

    @Override
    public ExpiryMetadata setTtl(long ttl) {
        long ttlSeconds = TimeUnit.MILLISECONDS.toSeconds(ttl);
        if (ttlSeconds == 0L && ttl != 0L) {
            ttlSeconds = 1L;
        }
        this.ttl = ttlSeconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ttlSeconds;
        return this;
    }

    @Override
    public ExpiryMetadata setRawTtl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public long getMaxIdle() {
        return this.maxIdle == Integer.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.SECONDS.toMillis(this.maxIdle);
    }

    @Override
    public int getRawMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public ExpiryMetadata setMaxIdle(long maxIdle) {
        long maxIdleSeconds = TimeUnit.MILLISECONDS.toSeconds(maxIdle);
        if (maxIdleSeconds == 0L && maxIdle != 0L) {
            maxIdleSeconds = 1L;
        }
        this.maxIdle = maxIdleSeconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxIdleSeconds;
        return this;
    }

    @Override
    public ExpiryMetadata setRawMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    @Override
    public long getExpirationTime() {
        if (this.expirationTime == -1) {
            return 0L;
        }
        if (this.expirationTime == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.recomputeWithBaseTime(this.expirationTime);
    }

    @Override
    public int getRawExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public ExpiryMetadata setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime == Long.MAX_VALUE ? Integer.MAX_VALUE : this.stripBaseTime(expirationTime);
        return this;
    }

    @Override
    public ExpiryMetadata setRawExpirationTime(int expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Override
    public long getLastUpdateTime() {
        if (this.lastUpdateTime == -1) {
            return 0L;
        }
        if (this.lastUpdateTime == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.recomputeWithBaseTime(this.lastUpdateTime);
    }

    @Override
    public int getRawLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public ExpiryMetadata setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime == Long.MAX_VALUE ? Integer.MAX_VALUE : this.stripBaseTime(lastUpdateTime);
        return this;
    }

    @Override
    public ExpiryMetadata setRawLastUpdateTime(int lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public String toString() {
        return "ExpiryMetadataImpl{ttl=" + this.getTtl() + ", maxIdle=" + this.getMaxIdle() + ", expirationTime=" + this.getExpirationTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + '}';
    }
}

