/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportTransform;
import org.apache.seatunnel.transform.exception.TransformCommonError;
import org.apache.seatunnel.transform.filter.FilterFieldTransformConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFieldTransform
extends AbstractCatalogSupportTransform {
    private static final Logger log = LoggerFactory.getLogger(FilterFieldTransform.class);
    public static final String PLUGIN_NAME = "Filter";
    private int[] inputValueIndex;
    private final List<String> fields;

    public FilterFieldTransform(@NonNull ReadonlyConfig config, @NonNull CatalogTable catalogTable) {
        super(catalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        SeaTunnelRowType seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
        this.fields = (List)config.get(FilterFieldTransformConfig.KEY_FIELDS);
        List<String> canNotFoundFields = this.fields.stream().filter(field -> seaTunnelRowType.indexOf(field, false) == -1).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(canNotFoundFields)) {
            throw TransformCommonError.cannotFindInputFieldsError(this.getPluginName(), canNotFoundFields);
        }
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Object[] values = new Object[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            values[i] = inputRow.getField(this.inputValueIndex[i]);
        }
        SeaTunnelRow outputRow = new SeaTunnelRow(values);
        outputRow.setRowKind(inputRow.getRowKind());
        outputRow.setTableId(inputRow.getTableId());
        return outputRow;
    }

    @Override
    protected TableSchema transformTableSchema() {
        ArrayList<Column> outputColumns = new ArrayList<Column>();
        SeaTunnelRowType seaTunnelRowType = this.inputCatalogTable.getTableSchema().toPhysicalRowDataType();
        this.inputValueIndex = new int[this.fields.size()];
        ArrayList<String> outputFieldNames = new ArrayList<String>();
        List inputColumns = this.inputCatalogTable.getTableSchema().getColumns();
        for (int i = 0; i < this.fields.size(); ++i) {
            int inputFieldIndex;
            String field = this.fields.get(i);
            this.inputValueIndex[i] = inputFieldIndex = seaTunnelRowType.indexOf(field);
            outputColumns.add(((Column)inputColumns.get(inputFieldIndex)).copy());
            outputFieldNames.add(((Column)inputColumns.get(inputFieldIndex)).getName());
        }
        List outputConstraintKeys = this.inputCatalogTable.getTableSchema().getConstraintKeys().stream().filter(key -> {
            List constraintColumnNames = key.getColumnNames().stream().map(ConstraintKey.ConstraintKeyColumn::getColumnName).collect(Collectors.toList());
            return outputFieldNames.containsAll(constraintColumnNames);
        }).map(ConstraintKey::copy).collect(Collectors.toList());
        PrimaryKey copiedPrimaryKey = null;
        PrimaryKey primaryKey = this.inputCatalogTable.getTableSchema().getPrimaryKey();
        if (primaryKey != null && outputFieldNames.containsAll(primaryKey.getColumnNames())) {
            copiedPrimaryKey = primaryKey.copy();
        }
        return TableSchema.builder().columns(outputColumns).primaryKey(copiedPrimaryKey).constraintKey(outputConstraintKeys).build();
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputCatalogTable.getTableId().copy();
    }
}

