/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.service.jar;

import com.hazelcast.map.IMap;
import java.io.File;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.core.job.CommonPluginJar;
import org.apache.seatunnel.engine.core.job.ConnectorJar;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.job.ConnectorJarType;
import org.apache.seatunnel.engine.core.job.RefCount;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.service.jar.AbstractConnectorJarStorageStrategy;
import org.apache.seatunnel.engine.server.service.jar.SharedConnectorJarCleanupTask;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class SharedConnectorJarStorageStrategy
extends AbstractConnectorJarStorageStrategy {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final IMap<ConnectorJarIdentifier, RefCount> connectorJarRefCounters = this.nodeEngine.getHazelcastInstance().getMap("engine_connectorJarRefCounters");
    private final long cleanupInterval;
    private final Timer cleanupTimer = new Timer(true);

    public SharedConnectorJarStorageStrategy(ConnectorJarStorageConfig connectorJarStorageConfig, SeaTunnelServer seaTunnelServer) {
        super(connectorJarStorageConfig, seaTunnelServer);
        this.cleanupInterval = connectorJarStorageConfig.getCleanupTaskInterval() * 1000;
        this.cleanupTimer.schedule((TimerTask)new SharedConnectorJarCleanupTask(this::deleteConnectorJar, this.connectorJarRefCounters), this.cleanupInterval, this.cleanupInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectorJarIdentifier storageConnectorJarFile(long jobId, ConnectorJar connectorJar) {
        ConnectorJarIdentifier connectorJarIdentifier = ConnectorJarIdentifier.of(connectorJar, this.getStorageLocationPath(jobId, connectorJar));
        RefCount refCount = this.connectorJarRefCounters.get(connectorJarIdentifier);
        if (refCount == null) {
            refCount = new RefCount();
            File storageLocation = this.getStorageLocation(jobId, connectorJar);
            try {
                this.readWriteLock.writeLock().lock();
                this.storageConnectorJarFileInternal(connectorJar, storageLocation);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        Long references = refCount.getReferences();
        references = references + 1L;
        refCount.setReferences(references);
        this.connectorJarRefCounters.put(connectorJarIdentifier, refCount);
        return connectorJarIdentifier;
    }

    @Override
    public boolean checkConnectorJarExisted(long jobId, ConnectorJar connectorJar) {
        ConnectorJarIdentifier connectorJarIdentifier = ConnectorJarIdentifier.of(connectorJar, this.getStorageLocationPath(jobId, connectorJar));
        RefCount refCount = this.connectorJarRefCounters.get(connectorJarIdentifier);
        return refCount != null;
    }

    public void increaseRefCountForConnectorJar(ConnectorJarIdentifier connectorJarIdentifier) {
        RefCount refCount = this.connectorJarRefCounters.get(connectorJarIdentifier);
        if (refCount != null) {
            Long references = refCount.getReferences();
            references = references + 1L;
            refCount.setReferences(references);
            this.connectorJarRefCounters.put(connectorJarIdentifier, refCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConnectorJar(ConnectorJarIdentifier connectorJarIdentifier) {
        RefCount refCount = this.connectorJarRefCounters.get(connectorJarIdentifier);
        if (refCount != null) {
            try {
                File storageLocation = new File(connectorJarIdentifier.getStoragePath());
                this.readWriteLock.writeLock().lock();
                this.deleteConnectorJarInternal(storageLocation);
                this.deleteConnectorJarInExecutionNode(connectorJarIdentifier);
                this.connectorJarRefCounters.remove(connectorJarIdentifier);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    @Override
    public String getStorageLocationPath(long jobId, ConnectorJar connectorJar) {
        Preconditions.checkNotNull(jobId);
        if (connectorJar.getType() == ConnectorJarType.COMMON_PLUGIN_JAR) {
            CommonPluginJar commonPluginJar = (CommonPluginJar)connectorJar;
            return String.format("%s/%s/%s", this.storageDir, "/plugins", commonPluginJar.getFileName());
        }
        return String.format("%s/%s/%s", this.storageDir, "/connectors", connectorJar.getFileName());
    }

    @Override
    public void cleanUpWhenJobFinished(long jobId, List<ConnectorJarIdentifier> connectorJarIdentifierList) {
        connectorJarIdentifierList.forEach(this::decreaseConnectorJarRefCount);
    }

    public void decreaseConnectorJarRefCount(ConnectorJarIdentifier connectorJarIdentifier) {
        this.connectorJarRefCounters.compute(connectorJarIdentifier, (connectorJarIdentifier1, refCount) -> {
            if (refCount != null) {
                Long references = refCount.getReferences();
                references = references - 1L;
                refCount.setReferences(references);
            }
            return refCount;
        });
    }
}

