/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EntryOrderedStore<T>
implements Iterable<T> {
    private final List<T> data = new ArrayList<T>();
    private final Map<T, Integer> index = new HashMap<T, Integer>();

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    public void add(T record) {
        int nextIndex = this.data.size();
        this.data.add(record);
        this.index.put(record, nextIndex);
    }

    public int getId(T record) {
        if (null == record) {
            return 0;
        }
        Integer id = this.index.get(record);
        if (id != null) {
            return id;
        }
        throw new IllegalArgumentException("Unable to find record index for " + record);
    }

    public int size() {
        assert (this.data.size() == this.index.size());
        return this.data.size();
    }
}

