/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.client.ErrorCondition;
import org.apache.qpid.protonj2.client.Link;
import org.apache.qpid.protonj2.client.LinkOptions;
import org.apache.qpid.protonj2.client.Source;
import org.apache.qpid.protonj2.client.Target;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientConnection;
import org.apache.qpid.protonj2.client.impl.ClientConversionSupport;
import org.apache.qpid.protonj2.client.impl.ClientErrorCondition;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientInstance;
import org.apache.qpid.protonj2.client.impl.ClientRemoteSource;
import org.apache.qpid.protonj2.client.impl.ClientRemoteTarget;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.engine.Connection;
import org.apache.qpid.protonj2.engine.Engine;
import org.apache.qpid.protonj2.engine.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientLinkType<LinkType extends Link<LinkType>, ProtonType extends org.apache.qpid.protonj2.engine.Link<ProtonType>>
implements Link<LinkType> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final AtomicIntegerFieldUpdater<ClientLinkType> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClientLinkType.class, "closed");
    protected final ClientFuture<LinkType> openFuture;
    protected final ClientFuture<LinkType> closeFuture;
    protected volatile int closed;
    protected ClientException failureCause;
    protected final ClientSession session;
    protected final Scheduler executor;
    protected final String linkId;
    protected final LinkOptions<?> options;
    protected volatile Source remoteSource;
    protected volatile Target remoteTarget;
    protected Consumer<LinkType> linkRemotelyClosedHandler;

    ClientLinkType(ClientSession session, String linkId, LinkOptions<?> options) {
        this.session = session;
        this.linkId = linkId;
        this.options = options;
        this.executor = session.getScheduler();
        this.openFuture = session.getFutureFactory().createFuture();
        this.closeFuture = session.getFutureFactory().createFuture();
    }

    protected abstract LinkType self();

    protected abstract ProtonType protonLink();

    @Override
    public void close() {
        try {
            this.doCloseOrDetach(true, null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void close(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        try {
            this.doCloseOrDetach(true, error).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void detach() {
        try {
            this.doCloseOrDetach(false, null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void detach(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        try {
            this.doCloseOrDetach(false, error).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public ClientFuture<LinkType> closeAsync() {
        return this.doCloseOrDetach(true, null);
    }

    @Override
    public ClientFuture<LinkType> closeAsync(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        return this.doCloseOrDetach(true, error);
    }

    @Override
    public ClientFuture<LinkType> detachAsync() {
        return this.doCloseOrDetach(false, null);
    }

    @Override
    public ClientFuture<LinkType> detachAsync(ErrorCondition error) {
        Objects.requireNonNull(error, "Error Condition cannot be null");
        return this.doCloseOrDetach(false, error);
    }

    private ClientFuture<LinkType> doCloseOrDetach(boolean close, ErrorCondition error) {
        if (CLOSED_UPDATER.compareAndSet(this, 0, 1) && !this.closeFuture.isDone()) {
            this.executor.execute(() -> {
                if (this.protonLink().isLocallyOpen()) {
                    try {
                        this.protonLink().setCondition(ClientErrorCondition.asProtonErrorCondition(error));
                        if (close) {
                            this.protonLink().close();
                        } else {
                            this.protonLink().detach();
                        }
                    }
                    catch (Throwable ignore) {
                        this.closeFuture.complete(this.self());
                    }
                }
            });
        }
        return this.closeFuture;
    }

    @Override
    public String address() throws ClientException {
        if (this.protonLink().isSender()) {
            org.apache.qpid.protonj2.types.messaging.Target target;
            if (this.isDynamic()) {
                this.waitForOpenToComplete();
                target = (org.apache.qpid.protonj2.types.messaging.Target)this.protonLink().getRemoteTarget();
            } else {
                target = (org.apache.qpid.protonj2.types.messaging.Target)this.protonLink().getTarget();
            }
            if (target != null) {
                return target.getAddress();
            }
            return null;
        }
        if (this.isDynamic()) {
            this.waitForOpenToComplete();
            return this.protonLink().getRemoteSource().getAddress();
        }
        return this.protonLink().getSource() != null ? this.protonLink().getSource().getAddress() : null;
    }

    @Override
    public Source source() throws ClientException {
        this.waitForOpenToComplete();
        return this.remoteSource;
    }

    @Override
    public Target target() throws ClientException {
        this.waitForOpenToComplete();
        return this.remoteTarget;
    }

    @Override
    public Map<String, Object> properties() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringKeyedMap(this.protonLink().getRemoteProperties());
    }

    @Override
    public String[] offeredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonLink().getRemoteOfferedCapabilities());
    }

    @Override
    public String[] desiredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonLink().getRemoteDesiredCapabilities());
    }

    @Override
    public ClientInstance client() {
        return this.session.client();
    }

    @Override
    public ClientConnection connection() {
        return this.session.connection();
    }

    @Override
    public ClientSession session() {
        return this.session;
    }

    @Override
    public ClientFuture<LinkType> openFuture() {
        return this.openFuture;
    }

    final LinkType remotelyClosedHandler(Consumer<LinkType> handler) {
        this.linkRemotelyClosedHandler = handler;
        return this.self();
    }

    final String getId() {
        return this.linkId;
    }

    final void setFailureCause(ClientException failureCause) {
        this.failureCause = failureCause;
    }

    final ClientException getFailureCause() {
        if (this.failureCause == null) {
            return this.session.getFailureCause();
        }
        return this.failureCause;
    }

    final boolean isClosed() {
        return this.closed > 0;
    }

    final boolean isDynamic() {
        if (this.protonLink().isSender()) {
            return this.protonLink().getTarget() != null && ((org.apache.qpid.protonj2.types.messaging.Target)this.protonLink().getTarget()).isDynamic();
        }
        return this.protonLink().getSource() != null && this.protonLink().getSource().isDynamic();
    }

    final LinkType open() {
        ((org.apache.qpid.protonj2.engine.Link)((org.apache.qpid.protonj2.engine.Link)((org.apache.qpid.protonj2.engine.Link)((org.apache.qpid.protonj2.engine.Link)this.protonLink().localOpenHandler(this::handleLocalOpen)).localCloseHandler(this::handleLocalCloseOrDetach)).localDetachHandler(this::handleLocalCloseOrDetach).openHandler(this::handleRemoteOpen)).closeHandler(this::handleRemoteCloseOrDetach)).detachHandler(this::handleRemoteCloseOrDetach).parentEndpointClosedHandler(this::handleParentEndpointClosed).engineShutdownHandler(this::handleEngineShutdown);
        this.protonLink().open();
        return this.self();
    }

    protected final void handleLocalOpen(ProtonType link) {
        this.linkSpecificLocalOpenHandler();
        if (this.options.openTimeout() > 0L) {
            this.executor.schedule(() -> {
                if (!this.openFuture.isDone()) {
                    this.immediateLinkShutdown(new ClientOperationTimedOutException("Link open timed out waiting for remote to respond"));
                }
            }, this.options.openTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    protected final void handleLocalCloseOrDetach(ProtonType link) {
        this.linkSpecificLocalCloseHandler();
        if (!link.getEngine().isShutdown() && this.failureCause == null && link.isRemotelyOpen()) {
            long timeout = this.options.closeTimeout();
            if (timeout > 0L) {
                this.session.scheduleRequestTimeout(this.closeFuture, timeout, () -> new ClientOperationTimedOutException("Link close timed out waiting for remote to respond"));
            }
        } else {
            this.immediateLinkShutdown(this.failureCause);
        }
    }

    protected final void handleRemoteOpen(ProtonType link) {
        if (link.isSender() && link.getRemoteTarget() != null || link.isReceiver() && link.getRemoteSource() != null) {
            if (link.getRemoteSource() != null) {
                this.remoteSource = new ClientRemoteSource(link.getRemoteSource());
            }
            if (link.getRemoteTarget() != null) {
                this.remoteTarget = new ClientRemoteTarget((org.apache.qpid.protonj2.types.messaging.Target)link.getRemoteTarget());
            }
            this.linkSpecificRemoteOpenHandler();
            this.openFuture.complete(this.self());
            LOG.trace("Link opened successfully: {}", link);
        } else {
            LOG.debug("Link opened but remote signaled close is pending: {}", link);
        }
    }

    protected final void handleRemoteCloseOrDetach(ProtonType link) {
        this.linkSpecificRemoteCloseHandler();
        if (link.isLocallyOpen()) {
            if (this.linkRemotelyClosedHandler != null) {
                try {
                    this.linkRemotelyClosedHandler.accept(this.self());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.immediateLinkShutdown(ClientExceptionSupport.convertToLinkClosedException(link.getRemoteCondition(), "Link remotely closed without explanation from the remote"));
        } else {
            this.immediateLinkShutdown(this.failureCause);
        }
    }

    protected final void handleParentEndpointClosed(ProtonType link) {
        if (link.getEngine().isRunning() && !link.getConnection().isLocallyClosed()) {
            ClientException failureCause = link.getConnection().getRemoteCondition() != null ? ClientExceptionSupport.convertToConnectionClosedException(link.getConnection().getRemoteCondition()) : (link.getSession().getRemoteCondition() != null ? ClientExceptionSupport.convertToSessionClosedException(link.getSession().getRemoteCondition()) : (link.getEngine().failureCause() != null ? ClientExceptionSupport.convertToConnectionClosedException(link.getEngine().failureCause()) : (!this.isClosed() ? new ClientResourceRemotelyClosedException("Remote closed without a specific error condition") : null)));
            this.immediateLinkShutdown(failureCause);
        }
    }

    protected final void handleEngineShutdown(Engine engine) {
        if (!this.isDynamic() && !this.session.getConnection().getEngine().isShutdown()) {
            this.recreateLinkForReconnect();
            this.open();
        } else {
            Connection connection = engine.connection();
            ClientConnectionRemotelyClosedException failureCause = connection.getRemoteCondition() != null ? ClientExceptionSupport.convertToConnectionClosedException(connection.getRemoteCondition()) : (engine.failureCause() != null ? ClientExceptionSupport.convertToConnectionClosedException(engine.failureCause()) : (!this.isClosed() ? new ClientConnectionRemotelyClosedException("Remote closed without a specific error condition") : null));
            this.immediateLinkShutdown(failureCause);
        }
    }

    protected final void immediateLinkShutdown(ClientException failureCause) {
        if (this.failureCause == null) {
            this.failureCause = failureCause;
        }
        try {
            if (this.protonLink().isRemotelyDetached()) {
                this.protonLink().detach();
            } else {
                this.protonLink().close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.linkSpecificCleanupHandler(this.failureCause);
        }
        catch (Exception exception) {
        }
        finally {
            if (failureCause != null) {
                this.openFuture.failed(failureCause);
            } else {
                this.openFuture.complete(this.self());
            }
            this.closeFuture.complete(this.self());
        }
    }

    protected abstract void linkSpecificLocalOpenHandler();

    protected abstract void linkSpecificLocalCloseHandler();

    protected abstract void linkSpecificRemoteOpenHandler();

    protected abstract void linkSpecificRemoteCloseHandler();

    protected abstract void linkSpecificCleanupHandler(ClientException var1);

    protected abstract void recreateLinkForReconnect();

    protected boolean notClosedOrFailed(ClientFuture<?> request) {
        return this.notClosedOrFailed(request, this.protonLink());
    }

    protected boolean notClosedOrFailed(ClientFuture<?> request, ProtonType protonLink) {
        if (this.isClosed()) {
            request.failed(new ClientIllegalStateException(String.format("The %s was explicitly closed", this.protonLink().isReceiver() ? "Receiver" : "Sender"), this.failureCause));
            return false;
        }
        if (this.failureCause != null) {
            request.failed(this.failureCause);
            return false;
        }
        if (protonLink.isLocallyClosedOrDetached()) {
            if (protonLink.getConnection().getRemoteCondition() != null) {
                request.failed(ClientExceptionSupport.convertToConnectionClosedException(protonLink.getConnection().getRemoteCondition()));
            } else if (protonLink.getSession().getRemoteCondition() != null) {
                request.failed(ClientExceptionSupport.convertToSessionClosedException(protonLink.getSession().getRemoteCondition()));
            } else if (protonLink.getEngine().failureCause() != null) {
                request.failed(ClientExceptionSupport.convertToConnectionClosedException(protonLink.getEngine().failureCause()));
            } else {
                request.failed(new ClientIllegalStateException(String.format("{} closed without a specific error condition", protonLink.isSender() ? "Sender" : "Receiver")));
            }
            return false;
        }
        return true;
    }

    protected void checkClosedOrFailed() throws ClientException {
        if (this.isClosed()) {
            throw new ClientIllegalStateException(String.format("The %s was explicitly closed", this.protonLink().isReceiver() ? "Receiver" : "Sender"), this.failureCause);
        }
        if (this.failureCause != null) {
            throw this.failureCause;
        }
    }

    protected void waitForOpenToComplete() throws ClientException {
        if (!this.openFuture.isComplete() || this.openFuture.isFailed()) {
            try {
                this.openFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.interrupted();
                if (this.failureCause != null) {
                    throw this.failureCause;
                }
                throw ClientExceptionSupport.createNonFatalOrPassthrough(e.getCause());
            }
        }
    }
}

