/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Apache.Qpid.Proton.Test.Driver.Codec.Messaging;

namespace Apache.Qpid.Proton.Test.Driver.Matchers.Types.Messaging
{
   /// <summary>
   /// Base matcher implementation for AMQP sections that are encoded into the message
   /// body section.
   /// </summary>
   public sealed class AmqpValueMatcher : AbstractBodySectionMatcher
   {
      /// <summary>
      /// Create a match that expects an AmqpValue encoding with the given payload.
      /// </summary>
      /// <param name="expectedValue">The value that should be encoded in the AmqpValue</param>
      public AmqpValueMatcher(object expectedValue) : this(expectedValue, false)
      {
      }

      /// <summary>
      /// Create a match that expects an AmqpValue encoding with the given payload.
      /// </summary>
      /// <param name="expectedValue">The value that should be encoded in the AmqpValue</param>
      /// <param name="permitTrailingBytes">Expect more bytes in the message encoding</param>
      public AmqpValueMatcher(object expectedValue, bool permitTrailingBytes) :
         base(AmqpValue.DESCRIPTOR_SYMBOL, AmqpValue.DESCRIPTOR_CODE, expectedValue, permitTrailingBytes)
      {
      }

      public override void DescribeTo(IDescription description)
      {
         description.AppendText("a Binary encoding of an AmqpValue that wraps: ").AppendValue(ExpectedValue);
      }
   }
}