/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.berkeleydb;

import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.berkeleydb.BDBCacheSizeSetter;
import org.apache.qpid.server.store.berkeleydb.BDBMessageStore;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.virtualhost.AbstractVirtualHost;
import org.apache.qpid.server.virtualhost.berkeleydb.BDBVirtualHost;

@ManagedObject(category=false, type="BDB")
public class BDBVirtualHostImpl
extends AbstractVirtualHost<BDBVirtualHostImpl>
implements BDBVirtualHost<BDBVirtualHostImpl> {
    public static final String VIRTUAL_HOST_TYPE = "BDB";
    @ManagedAttributeField
    private String _storePath;
    @ManagedAttributeField
    private Long _storeUnderfullSize;
    @ManagedAttributeField
    private Long _storeOverfullSize;

    @ManagedObjectFactoryConstructor(conditionallyAvailable=true, condition="org.apache.qpid.server.JECheck#isAvailable()")
    public BDBVirtualHostImpl(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(attributes, virtualHostNode);
        this.addChangeListener((ConfigurationChangeListener)new BDBCacheSizeSetter());
    }

    protected MessageStore createMessageStore() {
        return new BDBMessageStore();
    }

    @Override
    public String getStorePath() {
        return this._storePath;
    }

    @Override
    public Long getStoreUnderfullSize() {
        return this._storeUnderfullSize;
    }

    @Override
    public Long getStoreOverfullSize() {
        return this._storeOverfullSize;
    }

    @Override
    public void setBDBCacheSize(long cacheSize) {
        EnvironmentFacade environmentFacade;
        BDBMessageStore bdbMessageStore = (BDBMessageStore)this.getMessageStore();
        if (bdbMessageStore != null && (environmentFacade = bdbMessageStore.getEnvironmentFacade()) != null) {
            environmentFacade.setCacheSize(cacheSize);
        }
    }

    @Override
    public void updateMutableConfig() {
        EnvironmentFacade environmentFacade;
        BDBMessageStore bdbMessageStore = (BDBMessageStore)this.getMessageStore();
        if (bdbMessageStore != null && (environmentFacade = bdbMessageStore.getEnvironmentFacade()) != null) {
            environmentFacade.updateMutableConfig(this);
        }
    }

    @Override
    public int cleanLog() {
        EnvironmentFacade environmentFacade;
        BDBMessageStore bdbMessageStore = (BDBMessageStore)this.getMessageStore();
        if (bdbMessageStore != null && (environmentFacade = bdbMessageStore.getEnvironmentFacade()) != null) {
            return environmentFacade.cleanLog();
        }
        return 0;
    }

    @Override
    public void checkpoint(boolean force) {
        EnvironmentFacade environmentFacade;
        BDBMessageStore bdbMessageStore = (BDBMessageStore)this.getMessageStore();
        if (bdbMessageStore != null && (environmentFacade = bdbMessageStore.getEnvironmentFacade()) != null) {
            environmentFacade.checkpoint(force);
        }
    }

    @Override
    public Map<String, Map<String, Object>> environmentStatistics(boolean reset) {
        EnvironmentFacade environmentFacade;
        BDBMessageStore bdbMessageStore = (BDBMessageStore)this.getMessageStore();
        if (bdbMessageStore != null && (environmentFacade = bdbMessageStore.getEnvironmentFacade()) != null) {
            return environmentFacade.getEnvironmentStatistics(reset);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> transactionStatistics(boolean reset) {
        EnvironmentFacade environmentFacade;
        BDBMessageStore bdbMessageStore = (BDBMessageStore)this.getMessageStore();
        if (bdbMessageStore != null && (environmentFacade = bdbMessageStore.getEnvironmentFacade()) != null) {
            return environmentFacade.getTransactionStatistics(reset);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> databaseStatistics(String database, boolean reset) {
        EnvironmentFacade environmentFacade;
        BDBMessageStore bdbMessageStore = (BDBMessageStore)this.getMessageStore();
        if (bdbMessageStore != null && (environmentFacade = bdbMessageStore.getEnvironmentFacade()) != null) {
            return environmentFacade.getDatabaseStatistics(database, reset);
        }
        return Collections.emptyMap();
    }

    @Override
    public EnvironmentFacade getEnvironmentFacade() {
        BDBMessageStore bdbMessageStore = (BDBMessageStore)this.getMessageStore();
        if (bdbMessageStore != null) {
            return bdbMessageStore.getEnvironmentFacade();
        }
        return null;
    }
}

