/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.util.Collection;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.plugin.SystemNodeCreator;
import org.apache.qpid.server.security.TrustStoreMessageSource;

@PluggableService
public class TrustStoreMessageSourceCreator
implements SystemNodeCreator {
    @Override
    public String getType() {
        return "TRUSTSTORE-MESSAGE-SOURCE";
    }

    @Override
    public void register(final SystemNodeCreator.SystemNodeRegistry registry) {
        final VirtualHost<?> vhost = registry.getVirtualHost();
        final VirtualHostNode virtualHostNode = (VirtualHostNode)vhost.getParent();
        final Broker broker = (Broker)virtualHostNode.getParent();
        Collection<TrustStore> trustStores = broker.getChildren(TrustStore.class);
        final TrustStoreChangeListener trustStoreChangeListener = new TrustStoreChangeListener(registry);
        for (TrustStore trustStore : trustStores) {
            this.updateTrustStoreSourceRegistration(registry, trustStore);
            trustStore.addChangeListener(trustStoreChangeListener);
        }
        final AbstractConfigurationChangeListener brokerListener = new AbstractConfigurationChangeListener(){

            @Override
            public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
                if (child instanceof TrustStore) {
                    TrustStore trustStore = (TrustStore)child;
                    TrustStoreMessageSourceCreator.this.updateTrustStoreSourceRegistration(registry, trustStore);
                    trustStore.addChangeListener(trustStoreChangeListener);
                }
            }

            @Override
            public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
                if (child instanceof TrustStore) {
                    TrustStore trustStore = (TrustStore)child;
                    trustStore.removeChangeListener(trustStoreChangeListener);
                    registry.removeSystemNode(TrustStoreMessageSource.getSourceNameFromTrustStore(trustStore));
                } else if (child == virtualHostNode) {
                    object.removeChangeListener(this);
                    broker.getChildren(TrustStore.class).forEach(t -> t.removeChangeListener(trustStoreChangeListener));
                }
            }
        };
        broker.addChangeListener(brokerListener);
        virtualHostNode.addChangeListener(new AbstractConfigurationChangeListener(){

            @Override
            public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
                if (child == vhost) {
                    broker.removeChangeListener(brokerListener);
                    object.removeChangeListener(this);
                    broker.getChildren(TrustStore.class).forEach(t -> t.removeChangeListener(trustStoreChangeListener));
                }
            }
        });
    }

    private boolean isTrustStoreExposedAsMessageSource(VirtualHostNode<?> virtualHostNode, TrustStore trustStore) {
        return trustStore.getState() == State.ACTIVE && trustStore.isExposedAsMessageSource() && (trustStore.getIncludedVirtualHostNodeMessageSources().contains(virtualHostNode) || trustStore.getIncludedVirtualHostNodeMessageSources().isEmpty() && !trustStore.getExcludedVirtualHostNodeMessageSources().contains(virtualHostNode));
    }

    private void updateTrustStoreSourceRegistration(SystemNodeCreator.SystemNodeRegistry registry, TrustStore<?> trustStore) {
        String sourceName = TrustStoreMessageSource.getSourceNameFromTrustStore(trustStore);
        if (this.isTrustStoreExposedAsMessageSource(registry.getVirtualHostNode(), trustStore)) {
            if (!registry.hasSystemNode(sourceName)) {
                registry.registerSystemNode(new TrustStoreMessageSource(trustStore, registry.getVirtualHost()));
            }
        } else {
            registry.removeSystemNode(sourceName);
        }
    }

    private class TrustStoreChangeListener
    extends AbstractConfigurationChangeListener {
        private final SystemNodeCreator.SystemNodeRegistry _registry;

        public TrustStoreChangeListener(SystemNodeCreator.SystemNodeRegistry registry) {
            this._registry = registry;
        }

        @Override
        public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
            TrustStoreMessageSourceCreator.this.updateTrustStoreSourceRegistration(this._registry, (TrustStore)object);
        }

        @Override
        public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
            TrustStoreMessageSourceCreator.this.updateTrustStoreSourceRegistration(this._registry, (TrustStore)object);
        }
    }
}

