/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AbstractTrustStore;
import org.apache.qpid.server.security.SiteSpecificTrustStore;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false)
public class SiteSpecificTrustStoreImpl
extends AbstractTrustStore<SiteSpecificTrustStoreImpl>
implements SiteSpecificTrustStore<SiteSpecificTrustStoreImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteSpecificTrustStoreImpl.class);
    @ManagedAttributeField
    private String _siteUrl;
    private volatile TrustManager[] _trustManagers = new TrustManager[0];
    private volatile int _connectTimeout;
    private volatile int _readTimeout;
    private volatile X509Certificate _x509Certificate;

    @ManagedObjectFactoryConstructor
    public SiteSpecificTrustStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    protected void initialize() {
        this.generateTrustManagers();
    }

    @Override
    public String getSiteUrl() {
        return this._siteUrl;
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._connectTimeout = this.getContextValue(Integer.class, "qpid.trustStore.siteSpecific.connectTimeout");
        this._readTimeout = this.getContextValue(Integer.class, "qpid.trustStore.siteSpecific.readTimeout");
    }

    @Override
    protected void postResolve() {
        super.postResolve();
        if (this.getActualAttributes().containsKey("certificate")) {
            this.decodeCertificate();
        }
    }

    @Override
    protected void validateOnCreate() {
        super.validateOnCreate();
        try {
            URL url = new URL(this._siteUrl);
            if (url.getHost() == null || url.getPort() == -1 && url.getDefaultPort() == -1) {
                throw new IllegalConfigurationException(String.format("URL '%s' does not provide a hostname and port number", this._siteUrl));
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalConfigurationException(String.format("'%s' is not a valid URL", this._siteUrl));
        }
    }

    @Override
    public String getCertificate() {
        if (this._x509Certificate != null) {
            try {
                return Base64.getEncoder().encodeToString(this._x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new IllegalConfigurationException("Unable to encode certificate");
            }
        }
        return null;
    }

    @Override
    protected TrustManager[] getTrustManagersInternal() throws GeneralSecurityException {
        TrustManager[] trustManagers = this._trustManagers;
        if (trustManagers == null || trustManagers.length == 0) {
            throw new IllegalStateException("Truststore " + String.valueOf(this) + " defines no trust managers");
        }
        return Arrays.copyOf(trustManagers, trustManagers.length);
    }

    @Override
    public Certificate[] getCertificates() throws GeneralSecurityException {
        Certificate[] certificateArray;
        X509Certificate x509Certificate = this._x509Certificate;
        if (x509Certificate == null) {
            certificateArray = new Certificate[]{};
        } else {
            Certificate[] certificateArray2 = new Certificate[1];
            certificateArray = certificateArray2;
            certificateArray2[0] = x509Certificate;
        }
        return certificateArray;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected CompletableFuture<Void> doActivate() {
        this.initializeExpiryChecking();
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (this._x509Certificate == null) {
            String currentCertificate = this.getCertificate();
            CompletableFuture<X509Certificate> certFuture = this.downloadCertificate(this.getSiteUrl());
            certFuture.whenCompleteAsync((certificate, error) -> {
                if (error != null) {
                    this._trustManagers = new TrustManager[0];
                    this.setState(State.ERRORED);
                    result.completeExceptionally((Throwable)error);
                } else {
                    this._x509Certificate = certificate;
                    this.attributeSet("certificate", currentCertificate, this._x509Certificate);
                    this.generateTrustAndSetState(result);
                }
            }, (Executor)this.getTaskExecutor());
            return result;
        }
        this.generateTrustAndSetState(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTrustAndSetState(CompletableFuture<Void> result) {
        State state = State.ERRORED;
        try {
            this.generateTrustManagers();
            state = State.ACTIVE;
            result.complete(null);
        }
        catch (IllegalConfigurationException e) {
            result.completeExceptionally(e);
        }
        finally {
            this.setState(state);
            result.complete(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<X509Certificate> downloadCertificate(String url) {
        ExecutorService workerService = Executors.newSingleThreadExecutor(this.getThreadFactory("download-certificate-worker-" + this.getName()));
        try {
            CompletableFuture<X509Certificate> completableFuture = CompletableFuture.supplyAsync(() -> {
                try {
                    URL siteUrl = new URL(url);
                    int port = siteUrl.getPort() == -1 ? siteUrl.getDefaultPort() : siteUrl.getPort();
                    SSLContext sslContext = SSLUtil.tryGetSSLContext();
                    sslContext.init(new KeyManager[0], new TrustManager[]{new AlwaysTrustManager()}, null);
                    try (SSLSocket socket = (SSLSocket)sslContext.getSocketFactory().createSocket();){
                        socket.setSoTimeout(this._readTimeout);
                        socket.connect(new InetSocketAddress(siteUrl.getHost(), port), this._connectTimeout);
                        socket.startHandshake();
                        Certificate[] certificateChain = socket.getSession().getPeerCertificates();
                        if (certificateChain != null && certificateChain.length != 0 && certificateChain[0] instanceof X509Certificate) {
                            X509Certificate x509Certificate2 = (X509Certificate)certificateChain[0];
                            LOGGER.debug("Successfully downloaded X509Certificate with DN {} certificate from {}", (Object)x509Certificate2.getSubjectX500Principal().getName(), (Object)url);
                            X509Certificate x509Certificate = x509Certificate2;
                            return x509Certificate;
                        }
                        throw new IllegalConfigurationException(String.format("TLS handshake for '%s' from '%s' did not provide a X509Certificate", this.getName(), url));
                    }
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new IllegalConfigurationException(String.format("Unable to get certificate for '%s' from '%s'", this.getName(), url), e);
                }
            }, workerService);
            return completableFuture;
        }
        finally {
            workerService.shutdown();
        }
    }

    private void decodeCertificate() {
        byte[] certificateEncoded = Strings.decodeBase64((String)this.getActualAttributes().get("certificate"));
        try (ByteArrayInputStream input = new ByteArrayInputStream(certificateEncoded);){
            this._x509Certificate = (X509Certificate)SSLUtil.getCertificateFactory().generateCertificate(input);
        }
        catch (IOException | CertificateException e) {
            throw new IllegalConfigurationException("Could not decode certificate", e);
        }
    }

    private void generateTrustManagers() {
        try {
            KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inMemoryKeyStore.load(null, null);
            inMemoryKeyStore.setCertificateEntry("1", this._x509Certificate);
            this._trustManagers = this.getTrustManagers(inMemoryKeyStore);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot load certificate(s) :" + String.valueOf(e), e);
        }
    }

    @Override
    public void refreshCertificate() {
        this.logOperation("refreshCertificate");
        String currentCertificate = this.getCertificate();
        CompletableFuture<X509Certificate> certFuture = this.downloadCertificate(this.getSiteUrl());
        CompletionStage modelFuture = certFuture.thenApply(cert -> {
            this._x509Certificate = cert;
            this.attributeSet("certificate", currentCertificate, this._x509Certificate);
            return null;
        });
        this.doSync(modelFuture);
    }

    private ThreadFactory getThreadFactory(String name) {
        return runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            thread.setName(name);
            return thread;
        };
    }

    private static class AlwaysTrustManager
    implements X509TrustManager {
        private AlwaysTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

