/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.qpid.server.BrokerPrincipal;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.configuration.CommonProperties;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.configuration.updater.TaskExecutorImpl;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.AbstractContainer;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.CommonAccessControlProvider;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfigurationExtractor;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DescendantScope;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.model.preferences.UserPreferencesImpl;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.plugin.SystemAddressSpaceCreator;
import org.apache.qpid.server.plugin.SystemNodeCreator;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.CompoundAccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SubjectFixedResultAccessControl;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.SocketConnectionMetaData;
import org.apache.qpid.server.security.auth.SocketConnectionPrincipal;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.SimpleAuthenticationManager;
import org.apache.qpid.server.security.group.GroupPrincipal;
import org.apache.qpid.server.stats.StatisticsReportingTask;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdaterImpl;
import org.apache.qpid.server.store.preferences.PreferencesRecoverer;
import org.apache.qpid.server.util.HousekeepingExecutor;
import org.apache.qpid.server.util.SystemUtils;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="Broker")
public class BrokerImpl
extends AbstractContainer<BrokerImpl>
implements Broker<BrokerImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerImpl.class);
    private static final Logger DIRECT_MEMORY_USAGE_LOGGER = LoggerFactory.getLogger((String)"org.apache.qpid.server.directMemory.broker");
    private static final Pattern MODEL_VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+$");
    private static final int HOUSEKEEPING_SHUTDOWN_TIMEOUT = 5;
    public static final String MANAGEMENT_MODE_AUTHENTICATION = "MANAGEMENT_MODE_AUTHENTICATION";
    private final Thread _shutdownHook = new Thread((Runnable)new ShutdownService(), "QpidBrokerShutdownHook");
    private final AccessControl _systemUserAllowed = new SubjectFixedResultAccessControl(subject -> this.isSystemSubject(subject) ? Result.ALLOWED : Result.DEFER, Result.DEFER);
    private final BrokerPrincipal _principal;
    private final AtomicLong _messagesIn = new AtomicLong();
    private final AtomicLong _messagesOut = new AtomicLong();
    private final AtomicLong _transactedMessagesIn = new AtomicLong();
    private final AtomicLong _transactedMessagesOut = new AtomicLong();
    private final AtomicLong _bytesIn = new AtomicLong();
    private final AtomicLong _bytesOut = new AtomicLong();
    private final AtomicLong _maximumMessageSize = new AtomicLong();
    private final boolean _virtualHostPropertiesNodeEnabled;
    private final AddressSpaceRegistry _addressSpaceRegistry = new AddressSpaceRegistry();
    private final ConfigurationChangeListener _accessControlProviderListener = new AccessControlProviderListener();
    private final AccessControl _accessControl;
    private final AtomicBoolean _directMemoryExceedsThresholdReported = new AtomicBoolean();
    @ManagedAttributeField
    private int _shutdownTimeout;
    @ManagedAttributeField
    private int _statisticsReportingPeriod;
    @ManagedAttributeField
    private boolean _messageCompressionEnabled;
    private AuthenticationProvider<?> _managementModeAuthenticationProvider;
    private PreferenceStore _preferenceStore;
    private Collection<BrokerLogger> _brokerLoggersToClose;
    private int _networkBufferSize = 262144;
    private TaskExecutor _preferenceTaskExecutor;
    private String _documentationUrl;
    private long _compactMemoryThreshold;
    private long _compactMemoryInterval;
    private long _flowToDiskThreshold;
    private double _sparsityFraction;
    private long _lastDisposalCounter;
    private ScheduledFuture<?> _assignTargetSizeSchedulingFuture;
    private volatile ScheduledFuture<?> _statisticsReportingFuture;
    private long _housekeepingCheckPeriod;

    @ManagedObjectFactoryConstructor
    public BrokerImpl(Map<String, Object> attributes, SystemConfig parent) {
        super(attributes, parent);
        this._principal = new BrokerPrincipal(this);
        if (parent.isManagementMode()) {
            HashMap<String, Object> authManagerAttrs = new HashMap<String, Object>();
            authManagerAttrs.put("name", MANAGEMENT_MODE_AUTHENTICATION);
            authManagerAttrs.put("id", UUID.randomUUID());
            SimpleAuthenticationManager authManager = new SimpleAuthenticationManager(authManagerAttrs, this);
            authManager.addUser("mm_admin", this._parent.getManagementModePassword());
            this._managementModeAuthenticationProvider = authManager;
            this._accessControl = AccessControl.ALWAYS_ALLOWED;
        } else {
            this._accessControl = new CompoundAccessControl(List.of(), Result.ALLOWED);
        }
        QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
        Set<String> systemNodeCreatorTypes = qpidServiceLoader.getInstancesByType(SystemNodeCreator.class).keySet();
        this._virtualHostPropertiesNodeEnabled = systemNodeCreatorTypes.contains("VIRTUALHOSTPROPERTIES");
    }

    private void registerSystemAddressSpaces() {
        QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
        Iterable<SystemAddressSpaceCreator> factories = qpidServiceLoader.instancesOf(SystemAddressSpaceCreator.class);
        for (SystemAddressSpaceCreator creator : factories) {
            creator.register(this._addressSpaceRegistry);
        }
    }

    @Override
    protected void postResolve() {
        super.postResolve();
        Integer networkBufferSize = this.getContextValue(Integer.class, "qpid.broker.networkBufferSize");
        if (networkBufferSize == null || networkBufferSize < 65536) {
            throw new IllegalConfigurationException("qpid.broker.networkBufferSize is set to unacceptable value '" + networkBufferSize + "'. Must be larger than 65536.");
        }
        this._networkBufferSize = networkBufferSize;
        this._sparsityFraction = this.getContextValue(Double.class, "broker.directByteBufferPoolSparsityReallocationFraction");
        int poolSize = this.getContextValue(Integer.class, "broker.directByteBufferPoolSize");
        QpidByteBuffer.initialisePool(this._networkBufferSize, poolSize, this._sparsityFraction);
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        SystemConfig parent = (SystemConfig)this.getParent();
        Runnable task = parent.getOnContainerResolveTask();
        if (task != null) {
            task.run();
        }
        this.addChangeListener(this._accessControlProviderListener);
        for (AccessControlProvider aclProvider : this.getChildren(AccessControlProvider.class)) {
            aclProvider.addChangeListener(this._accessControlProviderListener);
        }
        this._eventLogger.message(BrokerMessages.CONFIG(parent instanceof FileBasedSettings ? ((FileBasedSettings)((Object)parent)).getStorePath() : "N/A"));
    }

    @Override
    public void onValidate() {
        super.onValidate();
        String modelVersion = (String)this.getActualAttributes().get("modelVersion");
        if (modelVersion == null) {
            this.deleteNoChecks();
            throw new IllegalConfigurationException(String.format("Broker %s must be specified", "modelVersion"));
        }
        if (!MODEL_VERSION_PATTERN.matcher(modelVersion).matches()) {
            this.deleteNoChecks();
            throw new IllegalConfigurationException(String.format("Broker %s is specified in incorrect format: %s", "modelVersion", modelVersion));
        }
        int versionSeparatorPosition = modelVersion.indexOf(".");
        String majorVersionPart = modelVersion.substring(0, versionSeparatorPosition);
        int majorModelVersion = Integer.parseInt(majorVersionPart);
        int minorModelVersion = Integer.parseInt(modelVersion.substring(versionSeparatorPosition + 1));
        if (majorModelVersion != 9 || minorModelVersion > 1) {
            this.deleteNoChecks();
            throw new IllegalConfigurationException(String.format("The model version '%s' in configuration is incompatible with the broker model version '%s'", modelVersion, "9.1"));
        }
        if (!this.isDurable()) {
            this.deleteNoChecks();
            throw new IllegalArgumentException(String.format("%s must be durable", this.getClass().getSimpleName()));
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        Map context;
        super.validateChange(proxyForValidation, changedAttributes);
        Broker updated = (Broker)proxyForValidation;
        if (changedAttributes.contains("modelVersion") && !"9.1".equals(updated.getModelVersion())) {
            throw new IllegalConfigurationException("Cannot change the model version");
        }
        if (changedAttributes.contains("context") && (context = (Map)proxyForValidation.getAttribute("context")).containsKey("broker.failStartupWithErroredChildScope")) {
            String value = (String)context.get("broker.failStartupWithErroredChildScope");
            try {
                DescendantScope.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException(String.format("Unsupported value '%s' is specified for context variable '%s'. Please, change it to any of supported : %s", value, "broker.failStartupWithErroredChildScope", EnumSet.allOf(DescendantScope.class)));
            }
        }
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        super.changeAttributes(attributes);
        if (attributes.containsKey("statisticsReportingPeriod")) {
            this.initialiseStatisticsReporting();
        }
    }

    @Override
    protected void validateChildDelete(ConfiguredObject<?> child) {
        super.validateChildDelete(child);
        if (child instanceof AccessControlProvider && this.getChildren(AccessControlProvider.class).size() == 1) {
            String categoryName = child.getCategoryClass().getSimpleName();
            throw new IllegalConfigurationException("The " + categoryName + " named '" + child.getName() + "' cannot be deleted as at least one " + categoryName + " must be present");
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> activate() {
        if (this._parent.isManagementMode()) {
            return this._managementModeAuthenticationProvider.openAsync().thenRunAsync(this::performActivation, this.getTaskExecutor());
        }
        this.performActivation();
        return CompletableFuture.completedFuture(null);
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.STOPPED)
    private CompletableFuture<Void> doStop() {
        this.stopPreferenceTaskExecutor();
        this.closePreferenceStore();
        return CompletableFuture.completedFuture(null);
    }

    private void closePreferenceStore() {
        PreferenceStore ps = this._preferenceStore;
        if (ps != null) {
            ps.close();
        }
    }

    private void stopPreferenceTaskExecutor() {
        TaskExecutor preferenceTaskExecutor = this._preferenceTaskExecutor;
        if (preferenceTaskExecutor != null) {
            preferenceTaskExecutor.stop();
        }
    }

    @Override
    public void initiateShutdown() {
        this.getEventLogger().message(BrokerMessages.OPERATION("initiateShutdown"));
        this._parent.closeAsync();
    }

    @Override
    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        return new ConfigurationExtractor().extractConfig(this, includeSecureAttributes);
    }

    private void performActivation() {
        DescendantScope descendantScope = this.getContextValue(DescendantScope.class, "broker.failStartupWithErroredChildScope");
        List<ConfiguredObject<?>> failedChildren = this.getChildrenInState(this, State.ERRORED, descendantScope);
        if (!failedChildren.isEmpty()) {
            for (ConfiguredObject<?> o : failedChildren) {
                LOGGER.warn("{} child object '{}' of type '{}' is {}", new Object[]{o.getParent().getCategoryClass().getSimpleName(), o.getName(), o.getClass().getSimpleName(), State.ERRORED});
            }
            this.getEventLogger().message(BrokerMessages.FAILED_CHILDREN(failedChildren.toString()));
        }
        this._documentationUrl = this.getContextValue(String.class, "qpid.helpURL");
        boolean brokerShutdownOnErroredChild = this.getContextValue(Boolean.class, "broker.failStartupWithErroredChild");
        if (!this._parent.isManagementMode() && brokerShutdownOnErroredChild && !failedChildren.isEmpty()) {
            throw new IllegalStateException(String.format("Broker context variable %s is set and the broker has %s children", new Object[]{"broker.failStartupWithErroredChild", State.ERRORED}));
        }
        this.updateAccessControl();
        this._houseKeepingTaskExecutor = new HousekeepingExecutor("broker-" + this.getName() + "-pool", this.getHousekeepingThreadCount(), this.getSystemTaskSubject("Housekeeping", this._principal));
        this.initialiseStatisticsReporting();
        this.scheduleDirectMemoryCheck();
        this._assignTargetSizeSchedulingFuture = this.scheduleHouseKeepingTask(this.getHousekeepingCheckPeriod(), TimeUnit.MILLISECONDS, this::assignTargetSizes);
        PreferenceStoreUpdaterImpl updater = new PreferenceStoreUpdaterImpl();
        Collection<PreferenceRecord> preferenceRecords = this._preferenceStore.openAndLoad(updater);
        this._preferenceTaskExecutor = new TaskExecutorImpl("broker-" + this.getName() + "-preferences", null);
        this._preferenceTaskExecutor.start();
        PreferencesRecoverer preferencesRecoverer = new PreferencesRecoverer(this._preferenceTaskExecutor);
        preferencesRecoverer.recoverPreferences(this, preferenceRecords, this._preferenceStore);
        if (this.isManagementMode()) {
            this._eventLogger.message(BrokerMessages.MANAGEMENT_MODE("mm_admin", this._parent.getManagementModePassword()));
        }
        this.setState(State.ACTIVE);
    }

    private List<ConfiguredObject<?>> getChildrenInState(ConfiguredObject<?> configuredObject, State state, DescendantScope descendantScope) {
        ArrayList foundChildren = new ArrayList();
        Class<ConfiguredObject> categoryClass = configuredObject.getCategoryClass();
        for (Class<? extends ConfiguredObject> childClass : this.getModel().getChildTypes(categoryClass)) {
            Collection<? extends ConfiguredObject> children = configuredObject.getChildren(childClass);
            for (ConfiguredObject configuredObject2 : children) {
                if (configuredObject2.getState() == state) {
                    foundChildren.add(configuredObject2);
                }
                if (descendantScope != DescendantScope.ALL) continue;
                foundChildren.addAll(this.getChildrenInState(configuredObject2, state, descendantScope));
            }
        }
        return foundChildren;
    }

    private void checkDirectMemoryUsage() {
        if (this._compactMemoryThreshold >= 0L && QpidByteBuffer.getAllocatedDirectMemorySize() > this._compactMemoryThreshold && this._lastDisposalCounter != QpidByteBuffer.getPooledBufferDisposalCounter()) {
            this._lastDisposalCounter = QpidByteBuffer.getPooledBufferDisposalCounter();
            CompletionStage completionStage = this.compactMemoryInternal().whenComplete((result1, error) -> this.scheduleDirectMemoryCheck());
        } else {
            this.scheduleDirectMemoryCheck();
        }
    }

    private void scheduleDirectMemoryCheck() {
        block3: {
            if (this._compactMemoryInterval > 0L) {
                try {
                    this._houseKeepingTaskExecutor.schedule(this::checkDirectMemoryUsage, this._compactMemoryInterval, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException e) {
                    if (this._houseKeepingTaskExecutor.isShutdown()) break block3;
                    LOGGER.warn("Failed to schedule direct memory check", (Throwable)e);
                }
            }
        }
    }

    private void initialiseStatisticsReporting() {
        long report = (long)this.getStatisticsReportingPeriod() * 1000L;
        ScheduledFuture<?> previousStatisticsReportingFuture = this._statisticsReportingFuture;
        if (previousStatisticsReportingFuture != null) {
            previousStatisticsReportingFuture.cancel(false);
        }
        if (report > 0L) {
            this._statisticsReportingFuture = this._houseKeepingTaskExecutor.scheduleAtFixedRate(new StatisticsReportingTask(this, this.getSystemTaskSubject("Statistics")), report, report, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public int getShutdownTimeout() {
        return this._shutdownTimeout;
    }

    @Override
    public int getStatisticsReportingPeriod() {
        return this._statisticsReportingPeriod;
    }

    @Override
    public boolean isMessageCompressionEnabled() {
        return this._messageCompressionEnabled;
    }

    @Override
    public Collection<VirtualHostNode<?>> getVirtualHostNodes() {
        Collection<VirtualHostNode<?>> children = this.getChildren(VirtualHostNode.class);
        return children;
    }

    @Override
    public Collection<Port<?>> getPorts() {
        Collection<Port<?>> children = this.getChildren(Port.class);
        return children;
    }

    @Override
    public Collection<AuthenticationProvider<?>> getAuthenticationProviders() {
        Collection<AuthenticationProvider<?>> children = this.getChildren(AuthenticationProvider.class);
        return children;
    }

    @Override
    public synchronized void assignTargetSizes() {
        this.reportDirectMemoryAboveThresholdIfExceeded();
        LOGGER.debug("Assigning target sizes based on total target {}", (Object)this._flowToDiskThreshold);
        long totalSize = 0L;
        Collection<VirtualHostNode<?>> vhns = this.getVirtualHostNodes();
        HashMap<QueueManagingVirtualHost, Long> vhs = new HashMap<QueueManagingVirtualHost, Long>();
        for (VirtualHostNode<?> vhn : vhns) {
            VirtualHost<?> vh = vhn.getVirtualHost();
            if (!(vh instanceof QueueManagingVirtualHost)) continue;
            QueueManagingVirtualHost host = (QueueManagingVirtualHost)vh;
            long totalQueueDepthBytes = host.getTotalDepthOfQueuesBytes();
            vhs.put(host, totalQueueDepthBytes);
            totalSize += totalQueueDepthBytes;
        }
        long proportionalShare = (long)((double)this._flowToDiskThreshold / (double)vhs.size());
        for (Map.Entry entry : vhs.entrySet()) {
            long size;
            long virtualHostTotalQueueSize = (Long)entry.getValue();
            if (totalSize == 0L) {
                size = proportionalShare;
            } else {
                double fraction = (double)virtualHostTotalQueueSize / (double)totalSize;
                double queueSizeBasedShare = (double)this._flowToDiskThreshold / 2.0 * fraction;
                size = (long)(queueSizeBasedShare + (double)proportionalShare / 2.0);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Assigning target size {} to vhost {}", (Object)size, entry.getKey());
            }
            ((QueueManagingVirtualHost)entry.getKey()).setTargetSize(size);
        }
        this.reportDirectMemoryBelowThresholdIfReached();
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
        LOGGER.debug("Added shutdown hook");
        SystemConfig preferencesRoot = (SystemConfig)this.getParent();
        this._preferenceStore = preferencesRoot.createPreferenceStore();
        this.getEventLogger().message(BrokerMessages.STARTUP(CommonProperties.getReleaseVersion(), CommonProperties.getBuildVersion()));
        this.getEventLogger().message(BrokerMessages.PLATFORM(System.getProperty("java.vendor"), System.getProperty("java.runtime.version", System.getProperty("java.version")), SystemUtils.getOSName(), SystemUtils.getOSVersion(), SystemUtils.getOSArch(), String.valueOf(this.getNumberOfCores())));
        long directMemory = BrokerImpl.getMaxDirectMemorySize();
        long heapMemory = Runtime.getRuntime().maxMemory();
        this.getEventLogger().message(BrokerMessages.MAX_MEMORY(heapMemory, directMemory));
        this._flowToDiskThreshold = this.getContextValue(Long.class, "broker.flowToDiskThreshold");
        this._compactMemoryThreshold = this.getContextValue(Long.class, "qpid.compact_memory_threshold");
        this._compactMemoryInterval = this.getContextValue(Long.class, "qpid.compact_memory_interval");
        this._housekeepingCheckPeriod = this.getContextValue(Long.class, "qpid.broker.housekeepingCheckPeriod");
        if (SystemUtils.getProcessPid() != null) {
            this.getEventLogger().message(BrokerMessages.PROCESS(SystemUtils.getProcessPid()));
        }
        this.registerSystemAddressSpaces();
        this.assignTargetSizes();
    }

    @Override
    public NamedAddressSpace getSystemAddressSpace(String name) {
        return this._addressSpaceRegistry.getAddressSpace(name);
    }

    @Override
    public Collection<GroupProvider<?>> getGroupProviders() {
        Collection<GroupProvider<?>> children = this.getChildren(GroupProvider.class);
        return children;
    }

    private CompletableFuture<VirtualHostNode> createVirtualHostNodeAsync(Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        return this.getObjectFactory().createAsync(VirtualHostNode.class, attributes, this).thenApplyAsync(virtualHostNode -> {
            Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> {
                ((VirtualHostNode)virtualHostNode).start();
                return null;
            });
            return virtualHostNode;
        }, (Executor)this.getTaskExecutor());
    }

    @Override
    protected <C extends ConfiguredObject> CompletableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
        if (childClass == VirtualHostNode.class) {
            return this.createVirtualHostNodeAsync(attributes);
        }
        return super.addChildAsync(childClass, attributes);
    }

    @Override
    protected CompletableFuture<Void> beforeClose() {
        try {
            boolean removed = Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            LOGGER.debug("Removed shutdown hook: " + removed);
        }
        catch (IllegalStateException ise) {
            LOGGER.debug("JVM is already shutting down", (Throwable)ise);
        }
        this._brokerLoggersToClose = new ArrayList<BrokerLogger>(this.getChildren(BrokerLogger.class));
        return super.beforeClose();
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        if (this._assignTargetSizeSchedulingFuture != null) {
            this._assignTargetSizeSchedulingFuture.cancel(true);
        }
        this.shutdownHouseKeeping();
        this.stopPreferenceTaskExecutor();
        this.closePreferenceStore();
        this._eventLogger.message(BrokerMessages.STOPPED());
        try {
            for (BrokerLogger logger : this._brokerLoggersToClose) {
                logger.stopLogging();
            }
        }
        finally {
            Runnable task = this._parent.getOnContainerCloseTask();
            if (task != null) {
                task.run();
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public UserPreferences createUserPreferences(ConfiguredObject<?> object) {
        return new UserPreferencesImpl(this._preferenceTaskExecutor, object, this._preferenceStore, Set.of());
    }

    private void updateAccessControl() {
        if (!this.isManagementMode()) {
            ArrayList<AccessControlProvider> children = new ArrayList<AccessControlProvider>(this.getChildren(AccessControlProvider.class));
            Collections.sort(children, CommonAccessControlProvider.ACCESS_CONTROL_PROVIDER_COMPARATOR);
            ArrayList accessControls = new ArrayList(children.size() + 1);
            accessControls.add(this._systemUserAllowed);
            for (AccessControlProvider prov : children) {
                if (prov.getState() == State.ERRORED) {
                    accessControls.clear();
                    accessControls.add(AccessControl.ALWAYS_DENIED);
                    break;
                }
                if (prov.getState() != State.ACTIVE) continue;
                accessControls.add(prov.getController());
            }
            ((CompoundAccessControl)this._accessControl).setAccessControls(accessControls);
        }
    }

    @Override
    public AccessControl getAccessControl() {
        return this._accessControl;
    }

    @Override
    public VirtualHost<?> findVirtualHostByName(String name) {
        for (VirtualHostNode virtualHostNode : this.getChildren(VirtualHostNode.class)) {
            VirtualHost<?> virtualHost = virtualHostNode.getVirtualHost();
            if (virtualHost == null || !virtualHost.getName().equals(name)) continue;
            return virtualHost;
        }
        return null;
    }

    @Override
    public VirtualHostNode findDefautVirtualHostNode() {
        VirtualHostNode existingDefault = null;
        ArrayList virtualHostNodes = new ArrayList(this.getVirtualHostNodes());
        for (VirtualHostNode virtualHostNode : virtualHostNodes) {
            if (!virtualHostNode.isDefaultVirtualHostNode()) continue;
            existingDefault = virtualHostNode;
            break;
        }
        return existingDefault;
    }

    @Override
    public Collection<KeyStore<?>> getKeyStores() {
        Collection<KeyStore<?>> children = this.getChildren(KeyStore.class);
        return children;
    }

    @Override
    public Collection<TrustStore<?>> getTrustStores() {
        Collection<TrustStore<?>> children = this.getChildren(TrustStore.class);
        return children;
    }

    @Override
    public boolean isManagementMode() {
        return this._parent.isManagementMode();
    }

    @Override
    public Collection<AccessControlProvider<?>> getAccessControlProviders() {
        Collection<AccessControlProvider<?>> children = this.getChildren(AccessControlProvider.class);
        return children;
    }

    @Override
    protected void onExceptionInOpen(RuntimeException e) {
        this._eventLogger.message(BrokerMessages.FATAL_ERROR(e.getMessage()));
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(BrokerMessages.OPERATION(operation));
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesOut.incrementAndGet();
        this._bytesOut.addAndGet(messageSize);
    }

    @Override
    public void registerTransactedMessageReceived() {
        this._transactedMessagesIn.incrementAndGet();
    }

    @Override
    public void registerTransactedMessageDelivered() {
        this._transactedMessagesOut.incrementAndGet();
    }

    @Override
    public void registerMessageReceived(long messageSize) {
        long hwm;
        this._messagesIn.incrementAndGet();
        this._bytesIn.addAndGet(messageSize);
        while ((hwm = this._maximumMessageSize.get()) < messageSize) {
            this._maximumMessageSize.compareAndSet(hwm, messageSize);
        }
    }

    @Override
    public long getFlowToDiskThreshold() {
        return this._flowToDiskThreshold;
    }

    @Override
    public long getNumberOfBuffersInUse() {
        return QpidByteBuffer.getNumberOfBuffersInUse();
    }

    @Override
    public long getNumberOfBuffersInPool() {
        return QpidByteBuffer.getNumberOfBuffersInPool();
    }

    @Override
    public long getInboundMessageSizeHighWatermark() {
        return this._maximumMessageSize.get();
    }

    @Override
    public long getMessagesIn() {
        return this._messagesIn.get();
    }

    @Override
    public long getBytesIn() {
        return this._bytesIn.get();
    }

    @Override
    public long getMessagesOut() {
        return this._messagesOut.get();
    }

    @Override
    public long getBytesOut() {
        return this._bytesOut.get();
    }

    @Override
    public long getTransactedMessagesIn() {
        return this._transactedMessagesIn.get();
    }

    @Override
    public long getTransactedMessagesOut() {
        return this._transactedMessagesOut.get();
    }

    @Override
    public boolean isVirtualHostPropertiesNodeEnabled() {
        return this._virtualHostPropertiesNodeEnabled;
    }

    @Override
    public AuthenticationProvider<?> getManagementModeAuthenticationProvider() {
        return this._managementModeAuthenticationProvider;
    }

    @Override
    public int getNetworkBufferSize() {
        return this._networkBufferSize;
    }

    @Override
    public String getDocumentationUrl() {
        return this._documentationUrl;
    }

    @Override
    public void resetStatistics() {
        this._maximumMessageSize.set(0L);
        this._bytesIn.set(0L);
        this._bytesOut.set(0L);
        this._messagesIn.set(0L);
        this._messagesOut.set(0L);
        this._transactedMessagesIn.set(0L);
        this._transactedMessagesOut.set(0L);
        this.getChildren(BrokerLogger.class).forEach(BrokerLogger::resetStatistics);
        this.getChildren(Port.class).stream().filter(AmqpPort.class::isInstance).map(port -> (AmqpPort)port).forEach(AmqpPort::resetStatistics);
        this.getVirtualHostNodes().stream().map(VirtualHostNode::getVirtualHost).filter(QueueManagingVirtualHost.class::isInstance).map(vh -> (QueueManagingVirtualHost)vh).forEach(QueueManagingVirtualHost::resetStatistics);
    }

    @Override
    public void restart() {
        Subject.doAs(this.getSystemTaskSubject("Broker"), () -> {
            SystemConfig systemConfig = (SystemConfig)this.getParent();
            systemConfig.setAttributesAsync(Map.of("desiredState", State.STOPPED)).thenRunAsync(() -> systemConfig.setAttributesAsync(Map.of("desiredState", State.ACTIVE)), this.getTaskExecutor());
            return null;
        });
    }

    @Override
    public Principal getUser() {
        return AuthenticatedPrincipal.getCurrentUser();
    }

    @Override
    public SocketConnectionMetaData getConnectionMetaData() {
        return this.getConnectionMetaDataInternal();
    }

    @Override
    public Set<Principal> getGroups() {
        return this.getGroupsInternal();
    }

    @Override
    public void purgeUser(AuthenticationProvider<?> origin, String username) {
        this.doPurgeUser(origin, username);
    }

    private void doPurgeUser(AuthenticationProvider<?> origin, String username) {
        if (origin instanceof PasswordCredentialManagingAuthenticationProvider) {
            try {
                ((PasswordCredentialManagingAuthenticationProvider)origin).deleteUser(username);
            }
            catch (AccountNotFoundException accountNotFoundException) {
                // empty catch block
            }
        }
        Collection<GroupProvider> groupProviders = this.getChildren(GroupProvider.class);
        for (GroupProvider groupProvider : groupProviders) {
            Collection<Group> groups = groupProvider.getChildren(Group.class);
            for (Group group : groups) {
                Collection<GroupMember> members = group.getChildren(GroupMember.class);
                for (GroupMember member : members) {
                    if (!username.equals(member.getName())) continue;
                    member.delete();
                }
            }
        }
        Subject userSubject = new Subject(true, Set.of(new AuthenticatedPrincipal(new UsernamePrincipal(username, origin))), Set.of(), Set.of());
        LinkedList<ConfiguredObject> configuredObjects = new LinkedList<ConfiguredObject>();
        configuredObjects.add(this);
        while (!configuredObjects.isEmpty()) {
            ConfiguredObject currentObject = (ConfiguredObject)configuredObjects.poll();
            Collection<Class<? extends ConfiguredObject>> childClasses = this.getModel().getChildTypes(currentObject.getClass());
            for (Class<? extends ConfiguredObject> childClass : childClasses) {
                Collection<? extends ConfiguredObject> children = currentObject.getChildren(childClass);
                for (ConfiguredObject configuredObject : children) {
                    configuredObjects.add(configuredObject);
                }
            }
            Subject.doAs(userSubject, () -> {
                currentObject.getUserPreferences().delete(null, null, null);
                return null;
            });
        }
    }

    private void shutdownHouseKeeping() {
        if (this._houseKeepingTaskExecutor != null) {
            this._houseKeepingTaskExecutor.shutdown();
            try {
                if (!this._houseKeepingTaskExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this._houseKeepingTaskExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted during Housekeeping shutdown:", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public long getCompactMemoryThreshold() {
        return this._compactMemoryThreshold;
    }

    @Override
    public long getCompactMemoryInterval() {
        return this._compactMemoryInterval;
    }

    @Override
    public double getSparsityFraction() {
        return this._sparsityFraction;
    }

    @Override
    public long getHousekeepingCheckPeriod() {
        return this._housekeepingCheckPeriod;
    }

    @Override
    public void compactMemory() {
        this.compactMemoryInternal();
    }

    private CompletableFuture<Void> compactMemoryInternal() {
        LOGGER.debug("Compacting direct memory buffers: numberOfActivePooledBuffers: {}", (Object)QpidByteBuffer.getNumberOfBuffersInUse());
        Collection<VirtualHostNode<?>> vhns = this.getVirtualHostNodes();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(vhns.size());
        for (VirtualHostNode<?> vhn : vhns) {
            VirtualHost<?> vh = vhn.getVirtualHost();
            if (!(vh instanceof QueueManagingVirtualHost)) continue;
            CompletableFuture<Void> future = ((QueueManagingVirtualHost)vh).reallocateMessages();
            futures.add(future);
        }
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        combinedFuture.whenCompleteAsync((result, error) -> {
            if (error != null) {
                LOGGER.warn("Unexpected error during direct memory compaction.", error);
                resultFuture.completeExceptionally((Throwable)error);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("After compact direct memory buffers: numberOfActivePooledBuffers: {}", (Object)QpidByteBuffer.getNumberOfBuffersInUse());
                }
                resultFuture.complete(null);
            }
        }, (Executor)this._houseKeepingTaskExecutor);
        return resultFuture;
    }

    private SocketConnectionMetaData getConnectionMetaDataInternal() {
        Set<SocketConnectionPrincipal> principals;
        Subject subject = Subject.getSubject(AccessController.getContext());
        SocketConnectionPrincipal principal = subject != null ? (!(principals = subject.getPrincipals(SocketConnectionPrincipal.class)).isEmpty() ? principals.iterator().next() : null) : null;
        return principal == null ? null : principal.getConnectionMetaData();
    }

    private Set<Principal> getGroupsInternal() {
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        if (currentSubject == null) {
            return Set.of();
        }
        return Collections.unmodifiableSet(currentSubject.getPrincipals(GroupPrincipal.class));
    }

    private void reportDirectMemoryBelowThresholdIfReached() {
        long allocatedDirectMemorySize;
        if (DIRECT_MEMORY_USAGE_LOGGER.isDebugEnabled() && (allocatedDirectMemorySize = QpidByteBuffer.getAllocatedDirectMemorySize()) >= this._flowToDiskThreshold && this._directMemoryExceedsThresholdReported.compareAndSet(true, false)) {
            DIRECT_MEMORY_USAGE_LOGGER.debug("Direct memory threshold ({}) maintained : {}", (Object)this._flowToDiskThreshold, (Object)allocatedDirectMemorySize);
        }
    }

    private void reportDirectMemoryAboveThresholdIfExceeded() {
        long allocatedDirectMemorySize;
        if (DIRECT_MEMORY_USAGE_LOGGER.isDebugEnabled() && (allocatedDirectMemorySize = QpidByteBuffer.getAllocatedDirectMemorySize()) > this._flowToDiskThreshold && this._directMemoryExceedsThresholdReported.compareAndSet(false, true)) {
            DIRECT_MEMORY_USAGE_LOGGER.debug("Direct memory threshold ({}) exceeded : {}", (Object)this._flowToDiskThreshold, (Object)allocatedDirectMemorySize);
        }
    }

    private class ShutdownService
    implements Runnable {
        private ShutdownService() {
        }

        @Override
        public void run() {
            Subject.doAs(BrokerImpl.this.getSystemTaskSubject("Shutdown"), () -> {
                LOGGER.debug("Shutdown hook initiating close");
                this.waitForBrokerShutdown();
                return null;
            });
        }

        private void waitForBrokerShutdown() {
            CompletableFuture<Void> closeResult = BrokerImpl.this._parent.closeAsync();
            try {
                if (BrokerImpl.this._shutdownTimeout < 1) {
                    closeResult.get();
                } else {
                    closeResult.get(BrokerImpl.this._shutdownTimeout, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.warn("Attempting to cleanly shutdown took too long, exiting immediately", (Throwable)e);
            }
        }
    }

    private class AddressSpaceRegistry
    implements SystemAddressSpaceCreator.AddressSpaceRegistry {
        private final ConcurrentMap<String, NamedAddressSpace> _systemAddressSpaces = new ConcurrentHashMap<String, NamedAddressSpace>();

        private AddressSpaceRegistry() {
        }

        @Override
        public void registerAddressSpace(NamedAddressSpace addressSpace) {
            this._systemAddressSpaces.put(addressSpace.getName(), addressSpace);
        }

        @Override
        public void removeAddressSpace(NamedAddressSpace addressSpace) {
            this._systemAddressSpaces.remove(addressSpace.getName(), addressSpace);
        }

        @Override
        public void removeAddressSpace(String name) {
            this._systemAddressSpaces.remove(name);
        }

        @Override
        public NamedAddressSpace getAddressSpace(String name) {
            return name == null ? null : (NamedAddressSpace)this._systemAddressSpaces.get(name);
        }

        @Override
        public Broker<?> getBroker() {
            return BrokerImpl.this;
        }
    }

    private final class AccessControlProviderListener
    extends AbstractConfigurationChangeListener {
        private final Set<ConfiguredObject<?>> _bulkChanges = new HashSet();

        private AccessControlProviderListener() {
        }

        @Override
        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (object.getCategoryClass() == Broker.class && child.getCategoryClass() == AccessControlProvider.class) {
                child.addChangeListener(this);
                BrokerImpl.this.updateAccessControl();
            }
        }

        @Override
        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (object.getCategoryClass() == Broker.class && child.getCategoryClass() == AccessControlProvider.class) {
                BrokerImpl.this.updateAccessControl();
            }
        }

        @Override
        public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
            if (object.getCategoryClass() == AccessControlProvider.class && !this._bulkChanges.contains(object)) {
                BrokerImpl.this.updateAccessControl();
            }
        }

        @Override
        public void bulkChangeStart(ConfiguredObject<?> object) {
            if (object.getCategoryClass() == AccessControlProvider.class) {
                this._bulkChanges.add(object);
            }
        }

        @Override
        public void bulkChangeEnd(ConfiguredObject<?> object) {
            if (object.getCategoryClass() == AccessControlProvider.class) {
                this._bulkChanges.remove(object);
                BrokerImpl.this.updateAccessControl();
            }
        }
    }
}

