/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Transaction;
import org.apache.qpid.server.store.berkeleydb.upgrade.CursorTemplate;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CursorOperation
implements DatabaseRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorOperation.class);
    private CursorTemplate _template;
    private long _rowCount;
    private long _processedRowCount;

    @Override
    public void run(Database sourceDatabase, Database targetDatabase, Transaction transaction) {
        this._rowCount = sourceDatabase.count();
        this._template = new CursorTemplate(sourceDatabase, transaction, (database, transaction1, key, value) -> {
            ++this._processedRowCount;
            this.processEntry(database, targetDatabase, transaction1, key, value);
            if (this.getProcessedCount() % 1000L == 0L) {
                LOGGER.info("Processed " + this.getProcessedCount() + " records of " + this.getRowCount() + ".");
            }
        });
        this._template.processEntries();
    }

    public void abort() {
        if (this._template != null) {
            this._template.abort();
        }
    }

    public boolean deleteCurrent() {
        if (this._template != null) {
            return this._template.deleteCurrent();
        }
        return false;
    }

    public long getRowCount() {
        return this._rowCount;
    }

    public long getProcessedCount() {
        return this._processedRowCount;
    }

    public abstract void processEntry(Database var1, Database var2, Transaction var3, DatabaseEntry var4, DatabaseEntry var5);
}

