/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
package org.apache.qpid.server.store.berkeleydb.entry;

import java.util.UUID;

public class HierarchyKey
{
    private final UUID _childId;
    private final String _parentType;

    public HierarchyKey(final UUID childId, final String parentType)
    {
        _childId = childId;
        _parentType = parentType;
    }

    public UUID getChildId()
    {
        return _childId;
    }

    public String getParentType()
    {
        return _parentType;
    }

    @Override
    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final HierarchyKey that = (HierarchyKey) o;

        if (!_childId.equals(that._childId))
        {
            return false;
        }
        if (!_parentType.equals(that._parentType))
        {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode()
    {
        int result = _childId.hashCode();
        result = 31 * result + _parentType.hashCode();
        return result;
    }
}
