/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.limit;

import java.util.Objects;
import org.apache.qpid.server.security.limit.ConnectionLimitException;
import org.apache.qpid.server.security.limit.ConnectionSlot;
import org.apache.qpid.server.transport.AMQPConnection;

public interface ConnectionLimiter {
    public ConnectionSlot register(AMQPConnection<?> var1);

    public ConnectionLimiter append(ConnectionLimiter var1);

    public static CachedLimiter noLimits() {
        return NoLimits.INSTANCE;
    }

    public static CachedLimiter blockEveryone() {
        return BlockEveryone.INSTANCE;
    }

    public static final class NoLimits
    implements CachedLimiter {
        static CachedLimiter INSTANCE = new NoLimits();

        private NoLimits() {
        }

        @Override
        public ConnectionSlot register(AMQPConnection<?> connection) {
            return ConnectionSlot.FreeSlot.INSTANCE;
        }

        @Override
        public boolean deregister(AMQPConnection<?> connection) {
            return true;
        }

        @Override
        public ConnectionLimiter append(ConnectionLimiter limiter) {
            return Objects.requireNonNull(limiter);
        }
    }

    public static interface CachedLimiter
    extends ConnectionLimiter {
        public boolean deregister(AMQPConnection<?> var1);
    }

    public static final class BlockEveryone
    implements CachedLimiter {
        static CachedLimiter INSTANCE = new BlockEveryone();

        private BlockEveryone() {
        }

        @Override
        public ConnectionSlot register(AMQPConnection<?> connection) {
            throw new ConnectionLimitException("Opening any new connection is forbidden");
        }

        @Override
        public boolean deregister(AMQPConnection<?> connection) {
            return false;
        }

        @Override
        public ConnectionLimiter append(ConnectionLimiter limiter) {
            Objects.requireNonNull(limiter);
            return this;
        }
    }
}

