/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import java.security.Principal;
import java.util.Map;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.model.AbstractSystemConfig;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.SystemConfigFactoryConstructor;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.berkeleydb.BDBConfigurationStore;
import org.apache.qpid.server.store.berkeleydb.BDBSystemConfig;
import org.apache.qpid.server.store.preferences.PreferenceStore;

@ManagedObject(category=false, type="BDB")
public class BDBSystemConfigImpl
extends AbstractSystemConfig<BDBSystemConfigImpl>
implements BDBSystemConfig<BDBSystemConfigImpl> {
    public static final String SYSTEM_CONFIG_TYPE = "BDB";
    @ManagedAttributeField
    private String _storePath;
    @ManagedAttributeField
    private Long _storeUnderfullSize;
    @ManagedAttributeField
    private Long _storeOverfullSize;

    @SystemConfigFactoryConstructor
    public BDBSystemConfigImpl(TaskExecutor taskExecutor, EventLogger eventLogger, Principal systemPrincipal, Map<String, Object> attributes) {
        super(taskExecutor, eventLogger, systemPrincipal, attributes);
    }

    protected DurableConfigurationStore createStoreObject() {
        return new BDBConfigurationStore(Broker.class);
    }

    @Override
    public String getStorePath() {
        return this._storePath;
    }

    @Override
    public Long getStoreUnderfullSize() {
        return this._storeUnderfullSize;
    }

    @Override
    public Long getStoreOverfullSize() {
        return this._storeOverfullSize;
    }

    public PreferenceStore getPreferenceStore() {
        return ((BDBConfigurationStore)this.getConfigurationStore()).getPreferenceStore();
    }
}

