/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PulsarClientException
extends IOException {
    private long sequenceId = -1L;
    private Collection<Throwable> previous;

    public PulsarClientException(String msg) {
        super(msg);
    }

    public PulsarClientException(String msg, long sequenceId) {
        super(msg);
        this.sequenceId = sequenceId;
    }

    public PulsarClientException(Throwable t2) {
        super(t2);
    }

    public PulsarClientException(String msg, Throwable t2) {
        super(msg, t2);
    }

    public void setPreviousExceptions(Collection<Throwable> previous) {
        this.previous = previous;
    }

    public Collection<Throwable> getPreviousExceptions() {
        return this.previous;
    }

    @Override
    public String toString() {
        if (this.previous == null || this.previous.isEmpty()) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder(super.toString());
        int i = 0;
        boolean first = true;
        sb.append("{\"previous\":[");
        for (Throwable t2 : this.previous) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append("{\"attempt\":").append(i++).append(",\"error\":\"").append(t2.toString().replace("\"", "\\\"")).append("\"}");
        }
        sb.append("]}");
        return sb.toString();
    }

    public PulsarClientException(Throwable t2, long sequenceId) {
        super(t2);
        this.sequenceId = sequenceId;
    }

    public static Throwable wrap(Throwable t2, String msg) {
        msg = msg + "\n" + t2.getMessage();
        if (t2 instanceof TimeoutException) {
            return new TimeoutException(msg);
        }
        if (t2 instanceof InvalidConfigurationException) {
            return new InvalidConfigurationException(msg);
        }
        if (t2 instanceof AuthenticationException) {
            return new AuthenticationException(msg);
        }
        if (t2 instanceof IncompatibleSchemaException) {
            return new IncompatibleSchemaException(msg);
        }
        if (t2 instanceof TooManyRequestsException) {
            return new TooManyRequestsException(msg);
        }
        if (t2 instanceof LookupException) {
            return new LookupException(msg);
        }
        if (t2 instanceof ConnectException) {
            return new ConnectException(msg);
        }
        if (t2 instanceof AlreadyClosedException) {
            return new AlreadyClosedException(msg);
        }
        if (t2 instanceof TopicTerminatedException) {
            return new TopicTerminatedException(msg);
        }
        if (t2 instanceof AuthorizationException) {
            return new AuthorizationException(msg);
        }
        if (t2 instanceof GettingAuthenticationDataException) {
            return new GettingAuthenticationDataException(msg);
        }
        if (t2 instanceof UnsupportedAuthenticationException) {
            return new UnsupportedAuthenticationException(msg);
        }
        if (t2 instanceof BrokerPersistenceException) {
            return new BrokerPersistenceException(msg);
        }
        if (t2 instanceof BrokerMetadataException) {
            return new BrokerMetadataException(msg);
        }
        if (t2 instanceof ProducerBusyException) {
            return new ProducerBusyException(msg);
        }
        if (t2 instanceof ConsumerBusyException) {
            return new ConsumerBusyException(msg);
        }
        if (t2 instanceof NotConnectedException) {
            return new NotConnectedException();
        }
        if (t2 instanceof InvalidMessageException) {
            return new InvalidMessageException(msg);
        }
        if (t2 instanceof InvalidTopicNameException) {
            return new InvalidTopicNameException(msg);
        }
        if (t2 instanceof NotSupportedException) {
            return new NotSupportedException(msg);
        }
        if (t2 instanceof NotAllowedException) {
            return new NotAllowedException(msg);
        }
        if (t2 instanceof ProducerQueueIsFullError) {
            return new ProducerQueueIsFullError(msg);
        }
        if (t2 instanceof ProducerBlockedQuotaExceededError) {
            return new ProducerBlockedQuotaExceededError(msg);
        }
        if (t2 instanceof ProducerBlockedQuotaExceededException) {
            return new ProducerBlockedQuotaExceededException(msg);
        }
        if (t2 instanceof ChecksumException) {
            return new ChecksumException(msg);
        }
        if (t2 instanceof CryptoException) {
            return new CryptoException(msg);
        }
        if (t2 instanceof ConsumerAssignException) {
            return new ConsumerAssignException(msg);
        }
        if (t2 instanceof MessageAcknowledgeException) {
            return new MessageAcknowledgeException(msg);
        }
        if (t2 instanceof TransactionConflictException) {
            return new TransactionConflictException(msg);
        }
        if (t2 instanceof TransactionHasOperationFailedException) {
            return new TransactionHasOperationFailedException(msg);
        }
        if (t2 instanceof PulsarClientException) {
            return new PulsarClientException(msg);
        }
        if (t2 instanceof CompletionException) {
            return t2;
        }
        if (t2 instanceof RuntimeException) {
            return new RuntimeException(msg, t2.getCause());
        }
        if (t2 instanceof InterruptedException) {
            return t2;
        }
        if (t2 instanceof ExecutionException) {
            return t2;
        }
        return t2;
    }

    public static PulsarClientException unwrap(Throwable t2) {
        if (t2 instanceof PulsarClientException) {
            return (PulsarClientException)t2;
        }
        if (t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        if (t2 instanceof InterruptedException) {
            return new PulsarClientException(t2);
        }
        if (!(t2 instanceof ExecutionException)) {
            return new PulsarClientException(t2);
        }
        Throwable cause = t2.getCause();
        String msg = cause.getMessage();
        PulsarClientException newException = cause instanceof TimeoutException ? new TimeoutException(msg) : (cause instanceof InvalidConfigurationException ? new InvalidConfigurationException(msg) : (cause instanceof AuthenticationException ? new AuthenticationException(msg) : (cause instanceof IncompatibleSchemaException ? new IncompatibleSchemaException(msg) : (cause instanceof TooManyRequestsException ? new TooManyRequestsException(msg) : (cause instanceof LookupException ? new LookupException(msg) : (cause instanceof ConnectException ? new ConnectException(msg) : (cause instanceof AlreadyClosedException ? new AlreadyClosedException(msg) : (cause instanceof TopicTerminatedException ? new TopicTerminatedException(msg) : (cause instanceof AuthorizationException ? new AuthorizationException(msg) : (cause instanceof GettingAuthenticationDataException ? new GettingAuthenticationDataException(msg) : (cause instanceof UnsupportedAuthenticationException ? new UnsupportedAuthenticationException(msg) : (cause instanceof BrokerPersistenceException ? new BrokerPersistenceException(msg) : (cause instanceof BrokerMetadataException ? new BrokerMetadataException(msg) : (cause instanceof ProducerBusyException ? new ProducerBusyException(msg) : (cause instanceof ConsumerBusyException ? new ConsumerBusyException(msg) : (cause instanceof NotConnectedException ? new NotConnectedException() : (cause instanceof InvalidMessageException ? new InvalidMessageException(msg) : (cause instanceof InvalidTopicNameException ? new InvalidTopicNameException(msg) : (cause instanceof NotSupportedException ? new NotSupportedException(msg) : (cause instanceof NotAllowedException ? new NotAllowedException(msg) : (cause instanceof ProducerQueueIsFullError ? new ProducerQueueIsFullError(msg) : (cause instanceof ProducerBlockedQuotaExceededError ? new ProducerBlockedQuotaExceededError(msg) : (cause instanceof ProducerBlockedQuotaExceededException ? new ProducerBlockedQuotaExceededException(msg) : (cause instanceof ChecksumException ? new ChecksumException(msg) : (cause instanceof CryptoException ? new CryptoException(msg) : (cause instanceof ConsumerAssignException ? new ConsumerAssignException(msg) : (cause instanceof MessageAcknowledgeException ? new MessageAcknowledgeException(msg) : (cause instanceof TransactionConflictException ? new TransactionConflictException(msg) : (cause instanceof TopicDoesNotExistException ? new TopicDoesNotExistException(msg) : (cause instanceof SubscriptionNotFoundException ? new SubscriptionNotFoundException(msg) : (cause instanceof ProducerFencedException ? new ProducerFencedException(msg) : (cause instanceof MemoryBufferIsFullError ? new MemoryBufferIsFullError(msg) : (cause instanceof NotFoundException ? new NotFoundException(msg) : (cause instanceof TransactionHasOperationFailedException ? new TransactionHasOperationFailedException(msg) : new PulsarClientException(t2)))))))))))))))))))))))))))))))))));
        Collection<Throwable> previousExceptions = PulsarClientException.getPreviousExceptions(t2);
        if (previousExceptions != null) {
            newException.setPreviousExceptions(previousExceptions);
        }
        return newException;
    }

    public static Collection<Throwable> getPreviousExceptions(Throwable t2) {
        Throwable e = t2;
        for (int maxDepth = 20; maxDepth > 0 && e != null; --maxDepth) {
            Collection<Throwable> previous;
            if (e instanceof PulsarClientException && (previous = ((PulsarClientException)e).getPreviousExceptions()) != null) {
                return previous;
            }
            e = t2.getCause();
        }
        return null;
    }

    public static void setPreviousExceptions(Throwable t2, Collection<Throwable> previous) {
        Throwable e = t2;
        for (int maxDepth = 20; maxDepth > 0 && e != null; --maxDepth) {
            if (e instanceof PulsarClientException) {
                ((PulsarClientException)e).setPreviousExceptions(previous);
                return;
            }
            e = t2.getCause();
        }
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
    }

    public static boolean isRetriableError(Throwable t2) {
        return !(t2 instanceof AuthorizationException) && !(t2 instanceof InvalidServiceURL) && !(t2 instanceof InvalidConfigurationException) && !(t2 instanceof NotFoundException) && !(t2 instanceof IncompatibleSchemaException) && !(t2 instanceof TopicDoesNotExistException) && !(t2 instanceof SubscriptionNotFoundException) && !(t2 instanceof UnsupportedAuthenticationException) && !(t2 instanceof InvalidMessageException) && !(t2 instanceof InvalidTopicNameException) && !(t2 instanceof NotSupportedException) && !(t2 instanceof NotAllowedException) && !(t2 instanceof ChecksumException) && !(t2 instanceof CryptoException) && !(t2 instanceof ConsumerAssignException) && !(t2 instanceof MessageAcknowledgeException) && !(t2 instanceof TransactionConflictException) && !(t2 instanceof ProducerBusyException) && !(t2 instanceof ConsumerBusyException) && !(t2 instanceof TransactionHasOperationFailedException);
    }

    public static class TimeoutException
    extends PulsarClientException {
        public TimeoutException(Throwable t2) {
            super(t2);
        }

        public TimeoutException(Throwable t2, long sequenceId) {
            super(t2, sequenceId);
        }

        public TimeoutException(String msg) {
            super(msg);
        }

        public TimeoutException(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class InvalidConfigurationException
    extends PulsarClientException {
        public InvalidConfigurationException(String msg) {
            super(msg);
        }

        public InvalidConfigurationException(Throwable t2) {
            super(t2);
        }

        public InvalidConfigurationException(String msg, Throwable t2) {
            super(msg, t2);
        }
    }

    public static class AuthenticationException
    extends PulsarClientException {
        public AuthenticationException(String msg) {
            super(msg);
        }
    }

    public static class IncompatibleSchemaException
    extends PulsarClientException {
        public IncompatibleSchemaException(Throwable t2) {
            super(t2);
        }

        public IncompatibleSchemaException(String msg) {
            super(msg);
        }
    }

    public static class TooManyRequestsException
    extends LookupException {
        public TooManyRequestsException(String msg) {
            super(msg);
        }
    }

    public static class LookupException
    extends PulsarClientException {
        public LookupException(String msg) {
            super(msg);
        }
    }

    public static class ConnectException
    extends PulsarClientException {
        public ConnectException(Throwable t2) {
            super(t2);
        }

        public ConnectException(String msg) {
            super(msg);
        }
    }

    public static class AlreadyClosedException
    extends PulsarClientException {
        public AlreadyClosedException(String msg) {
            super(msg);
        }

        public AlreadyClosedException(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class TopicTerminatedException
    extends PulsarClientException {
        public TopicTerminatedException(String msg) {
            super(msg);
        }

        public TopicTerminatedException(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class AuthorizationException
    extends PulsarClientException {
        public AuthorizationException(String msg) {
            super(msg);
        }
    }

    public static class GettingAuthenticationDataException
    extends PulsarClientException {
        public GettingAuthenticationDataException(Throwable t2) {
            super(t2);
        }

        public GettingAuthenticationDataException(String msg) {
            super(msg);
        }
    }

    public static class UnsupportedAuthenticationException
    extends PulsarClientException {
        public UnsupportedAuthenticationException(Throwable t2) {
            super(t2);
        }

        public UnsupportedAuthenticationException(String msg) {
            super(msg);
        }
    }

    public static class BrokerPersistenceException
    extends PulsarClientException {
        public BrokerPersistenceException(String msg) {
            super(msg);
        }
    }

    public static class BrokerMetadataException
    extends PulsarClientException {
        public BrokerMetadataException(String msg) {
            super(msg);
        }
    }

    public static class ProducerBusyException
    extends PulsarClientException {
        public ProducerBusyException(String msg) {
            super(msg);
        }
    }

    public static class ConsumerBusyException
    extends PulsarClientException {
        public ConsumerBusyException(String msg) {
            super(msg);
        }
    }

    public static class NotConnectedException
    extends PulsarClientException {
        public NotConnectedException() {
            super("Not connected to broker");
        }

        public NotConnectedException(long sequenceId) {
            super("Not connected to broker", sequenceId);
        }

        public NotConnectedException(String msg) {
            super(msg);
        }
    }

    public static class InvalidMessageException
    extends PulsarClientException {
        public InvalidMessageException(String msg) {
            super(msg);
        }

        public InvalidMessageException(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class InvalidTopicNameException
    extends PulsarClientException {
        public InvalidTopicNameException(String msg) {
            super(msg);
        }
    }

    public static class NotSupportedException
    extends PulsarClientException {
        public NotSupportedException(String msg) {
            super(msg);
        }
    }

    public static class NotAllowedException
    extends PulsarClientException {
        public NotAllowedException(String msg) {
            super(msg);
        }
    }

    public static class ProducerQueueIsFullError
    extends PulsarClientException {
        public ProducerQueueIsFullError(String msg) {
            super(msg);
        }

        public ProducerQueueIsFullError(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class ProducerBlockedQuotaExceededError
    extends PulsarClientException {
        public ProducerBlockedQuotaExceededError(String msg) {
            super(msg);
        }
    }

    public static class ProducerBlockedQuotaExceededException
    extends PulsarClientException {
        public ProducerBlockedQuotaExceededException(String msg) {
            super(msg);
        }
    }

    public static class ChecksumException
    extends PulsarClientException {
        public ChecksumException(String msg) {
            super(msg);
        }
    }

    public static class CryptoException
    extends PulsarClientException {
        public CryptoException(String msg) {
            super(msg);
        }
    }

    public static class ConsumerAssignException
    extends PulsarClientException {
        public ConsumerAssignException(String msg) {
            super(msg);
        }
    }

    public static class MessageAcknowledgeException
    extends PulsarClientException {
        public MessageAcknowledgeException(Throwable t2) {
            super(t2);
        }

        public MessageAcknowledgeException(String msg) {
            super(msg);
        }
    }

    public static class TransactionConflictException
    extends PulsarClientException {
        public TransactionConflictException(Throwable t2) {
            super(t2);
        }

        public TransactionConflictException(String msg) {
            super(msg);
        }
    }

    public static class TransactionHasOperationFailedException
    extends PulsarClientException {
        public TransactionHasOperationFailedException() {
            super("Now allowed to commit the transaction due to failed operations of producing or acknowledgment");
        }

        public TransactionHasOperationFailedException(String msg) {
            super(msg);
        }
    }

    public static class TopicDoesNotExistException
    extends PulsarClientException {
        public TopicDoesNotExistException(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionNotFoundException
    extends PulsarClientException {
        public SubscriptionNotFoundException(String msg) {
            super(msg);
        }
    }

    public static class ProducerFencedException
    extends PulsarClientException {
        public ProducerFencedException(String msg) {
            super(msg);
        }
    }

    public static class MemoryBufferIsFullError
    extends PulsarClientException {
        public MemoryBufferIsFullError(String msg) {
            super(msg);
        }

        public MemoryBufferIsFullError(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class NotFoundException
    extends PulsarClientException {
        public NotFoundException(String msg) {
            super(msg);
        }

        public NotFoundException(Throwable t2) {
            super(t2);
        }
    }

    public static class InvalidServiceURL
    extends PulsarClientException {
        public InvalidServiceURL(Throwable t2) {
            super(t2);
        }

        public InvalidServiceURL(String msg, Throwable t2) {
            super(msg, t2);
        }
    }

    public static enum FailedFeatureCheck {
        SupportsGetPartitionedMetadataWithoutAutoCreation;

    }

    public static class FeatureNotSupportedException
    extends NotSupportedException {
        private final FailedFeatureCheck failedFeatureCheck;

        public FeatureNotSupportedException(String msg, FailedFeatureCheck failedFeatureCheck) {
            super(msg);
            this.failedFeatureCheck = failedFeatureCheck;
        }

        @Generated
        public FailedFeatureCheck getFailedFeatureCheck() {
            return this.failedFeatureCheck;
        }
    }

    public static class TopicMigrationException
    extends PulsarClientException {
        public TopicMigrationException(String msg) {
            super(msg);
        }
    }

    public static class ServiceNotReadyException
    extends LookupException {
        public ServiceNotReadyException(String msg) {
            super(msg);
        }
    }
}

