/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Writer;
import org.apache.orc.mapreduce.OrcMapreduceRecordWriter;

public class OrcOutputFormat<V extends Writable>
extends FileOutputFormat<NullWritable, V> {
    private static final String EXTENSION = ".orc";
    public static final String SKIP_TEMP_DIRECTORY = "orc.mapreduce.output.skip-temporary-directory";

    public RecordWriter<NullWritable, V> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration conf = taskAttemptContext.getConfiguration();
        Path filename = this.getDefaultWorkFile(taskAttemptContext, EXTENSION);
        Writer writer = OrcFile.createWriter((Path)filename, (OrcFile.WriterOptions)org.apache.orc.mapred.OrcOutputFormat.buildOptions(conf));
        return new OrcMapreduceRecordWriter(writer, OrcConf.ROW_BATCH_SIZE.getInt(conf), OrcConf.ROW_BATCH_CHILD_LIMIT.getInt(conf));
    }

    public Path getDefaultWorkFile(TaskAttemptContext context, String extension) throws IOException {
        if (context.getConfiguration().getBoolean(SKIP_TEMP_DIRECTORY, false)) {
            return new Path(OrcOutputFormat.getOutputPath((JobContext)context), OrcOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)OrcOutputFormat.getOutputName((JobContext)context), (String)extension));
        }
        return super.getDefaultWorkFile(context, extension);
    }
}

