/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.hadoop.hbase.ClassFinder;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestClassFinder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClassFinder.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestClassFinder.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseCommonTestingUtility testUtil = new HBaseCommonTestingUtility();
    private static final String BASEPKG = "tfcpkg";
    private static final String PREFIX = "Prefix";
    private static AtomicLong testCounter = new AtomicLong(0L);
    private static AtomicLong jarCounter = new AtomicLong(0L);
    private static String basePath = null;
    private static CustomClassloader classLoader;

    @BeforeClass
    public static void createTestDir() throws IOException {
        File testDir;
        basePath = testUtil.getDataTestDir(TestClassFinder.class.getSimpleName()).toString();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        if ((testDir = new File(basePath)).exists()) {
            TestClassFinder.deleteTestDir();
        }
        Assert.assertTrue((boolean)testDir.mkdirs());
        LOG.info("Using new, clean directory=" + testDir);
        classLoader = new CustomClassloader(new URL[0], ClassLoader.getSystemClassLoader());
    }

    @AfterClass
    public static void deleteTestDir() {
        testUtil.cleanupTestDir(TestClassFinder.class.getSimpleName());
    }

    @Test
    public void testClassFinderCanFindClassesInJars() throws Exception {
        long counter = testCounter.incrementAndGet();
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, "", "c1");
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, ".nested", "c2");
        FileAndPath c3 = TestClassFinder.compileTestClass(counter, "", "c3");
        TestClassFinder.packageAndLoadJar(c1, c3);
        TestClassFinder.packageAndLoadJar(c2);
        ClassFinder allClassesFinder = new ClassFinder(classLoader);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(TestClassFinder.makePackageName("", counter), false);
        Assert.assertEquals((long)3L, (long)allClasses.size());
    }

    @Test
    public void testClassFinderHandlesConflicts() throws Exception {
        long counter = testCounter.incrementAndGet();
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, "", "c1");
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, "", "c2");
        TestClassFinder.packageAndLoadJar(c1, c2);
        TestClassFinder.packageAndLoadJar(c1);
        ClassFinder allClassesFinder = new ClassFinder(classLoader);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(TestClassFinder.makePackageName("", counter), false);
        Assert.assertEquals((long)2L, (long)allClasses.size());
    }

    @Test
    public void testClassFinderHandlesNestedPackages() throws Exception {
        String NESTED = ".nested";
        String CLASSNAME1 = this.name.getMethodName() + "1";
        String CLASSNAME2 = this.name.getMethodName() + "2";
        long counter = testCounter.incrementAndGet();
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, "", "c1");
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, ".nested", CLASSNAME1);
        FileAndPath c3 = TestClassFinder.compileTestClass(counter, ".nested", CLASSNAME2);
        TestClassFinder.packageAndLoadJar(c1, c2);
        TestClassFinder.packageAndLoadJar(c3);
        ClassFinder allClassesFinder = new ClassFinder(classLoader);
        Set<Class<?>> nestedClasses = allClassesFinder.findClasses(TestClassFinder.makePackageName(".nested", counter), false);
        Assert.assertEquals((long)2L, (long)nestedClasses.size());
        Class<?> nestedClass1 = TestClassFinder.makeClass(".nested", CLASSNAME1, counter);
        Assert.assertTrue((boolean)nestedClasses.contains(nestedClass1));
        Class<?> nestedClass2 = TestClassFinder.makeClass(".nested", CLASSNAME2, counter);
        Assert.assertTrue((boolean)nestedClasses.contains(nestedClass2));
    }

    @Test
    public void testClassFinderFiltersByNameInJar() throws Exception {
        long counter = testCounter.incrementAndGet();
        String classNamePrefix = this.name.getMethodName();
        LOG.info("Created jar " + TestClassFinder.createAndLoadJar("", classNamePrefix, counter));
        ClassFinder.FileNameFilter notExcNameFilter = (fileName, absFilePath) -> !fileName.startsWith(PREFIX);
        ClassFinder incClassesFinder = new ClassFinder(null, notExcNameFilter, null, classLoader);
        Set<Class<?>> incClasses = incClassesFinder.findClasses(TestClassFinder.makePackageName("", counter), false);
        Assert.assertEquals((long)1L, (long)incClasses.size());
        Class<?> incClass = TestClassFinder.makeClass("", classNamePrefix, counter);
        Assert.assertTrue((boolean)incClasses.contains(incClass));
    }

    @Test
    public void testClassFinderFiltersByClassInJar() throws Exception {
        long counter = testCounter.incrementAndGet();
        String classNamePrefix = this.name.getMethodName();
        LOG.info("Created jar " + TestClassFinder.createAndLoadJar("", classNamePrefix, counter));
        ClassFinder.ClassFilter notExcClassFilter = c -> !c.getSimpleName().startsWith(PREFIX);
        ClassFinder incClassesFinder = new ClassFinder(null, null, notExcClassFilter, classLoader);
        Set<Class<?>> incClasses = incClassesFinder.findClasses(TestClassFinder.makePackageName("", counter), false);
        Assert.assertEquals((long)1L, (long)incClasses.size());
        Class<?> incClass = TestClassFinder.makeClass("", classNamePrefix, counter);
        Assert.assertTrue((boolean)incClasses.contains(incClass));
    }

    private static String createAndLoadJar(String packageNameSuffix, String classNamePrefix, long counter) throws Exception {
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, packageNameSuffix, classNamePrefix);
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, packageNameSuffix, "Prefix1");
        FileAndPath c3 = TestClassFinder.compileTestClass(counter, packageNameSuffix, PREFIX + classNamePrefix + "2");
        return TestClassFinder.packageAndLoadJar(c1, c2, c3);
    }

    @Test
    public void testClassFinderFiltersByPathInJar() throws Exception {
        String CLASSNAME = this.name.getMethodName();
        long counter = testCounter.incrementAndGet();
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, "", CLASSNAME);
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, "", "c2");
        TestClassFinder.packageAndLoadJar(c1);
        String excludedJar = TestClassFinder.packageAndLoadJar(c2);
        String excludedJarResource = new File(excludedJar).toURI().getRawSchemeSpecificPart();
        ClassFinder.ResourcePathFilter notExcJarFilter = (resourcePath, isJar) -> !isJar || !resourcePath.equals(excludedJarResource);
        ClassFinder incClassesFinder = new ClassFinder(notExcJarFilter, null, null, classLoader);
        Set<Class<?>> incClasses = incClassesFinder.findClasses(TestClassFinder.makePackageName("", counter), false);
        Assert.assertEquals((long)1L, (long)incClasses.size());
        Class<?> incClass = TestClassFinder.makeClass("", CLASSNAME, counter);
        Assert.assertTrue((boolean)incClasses.contains(incClass));
    }

    @Test
    public void testClassFinderCanFindClassesInDirs() throws Exception {
        long counter = testCounter.incrementAndGet();
        String classNamePrefix = this.name.getMethodName();
        String pkgNameSuffix = this.name.getMethodName();
        LOG.info("Created jar " + TestClassFinder.createAndLoadJar(pkgNameSuffix, classNamePrefix, counter));
        ClassFinder allClassesFinder = new ClassFinder(classLoader);
        String pkgName = TestClassFinder.makePackageName(pkgNameSuffix, counter);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(pkgName, false);
        Assert.assertTrue((String)("Classes in " + pkgName), (allClasses.size() > 0 ? 1 : 0) != 0);
        String classNameToFind = classNamePrefix + counter;
        Assert.assertTrue((boolean)TestClassFinder.contains(allClasses, classNameToFind));
    }

    private static boolean contains(Set<Class<?>> classes, String simpleName) {
        for (Class<?> c : classes) {
            if (!c.getSimpleName().equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testClassFinderFiltersByNameInDirs() throws Exception {
        long counter = testCounter.incrementAndGet();
        String classNamePrefix = this.name.getMethodName();
        String pkgNameSuffix = this.name.getMethodName();
        LOG.info("Created jar " + TestClassFinder.createAndLoadJar(pkgNameSuffix, classNamePrefix, counter));
        String classNameToFilterOut = classNamePrefix + counter;
        ClassFinder.FileNameFilter notThisFilter = (fileName, absFilePath) -> !fileName.equals(classNameToFilterOut + ".class");
        String pkgName = TestClassFinder.makePackageName(pkgNameSuffix, counter);
        ClassFinder allClassesFinder = new ClassFinder(classLoader);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(pkgName, false);
        Assert.assertTrue((String)("Classes in " + pkgName), (allClasses.size() > 0 ? 1 : 0) != 0);
        ClassFinder notThisClassFinder = new ClassFinder(null, notThisFilter, null, classLoader);
        Set<Class<?>> notAllClasses = notThisClassFinder.findClasses(pkgName, false);
        Assert.assertFalse((boolean)TestClassFinder.contains(notAllClasses, classNameToFilterOut));
        Assert.assertEquals((long)(allClasses.size() - 1), (long)notAllClasses.size());
    }

    @Test
    public void testClassFinderFiltersByClassInDirs() throws Exception {
        long counter = testCounter.incrementAndGet();
        String classNamePrefix = this.name.getMethodName();
        String pkgNameSuffix = this.name.getMethodName();
        LOG.info("Created jar " + TestClassFinder.createAndLoadJar(pkgNameSuffix, classNamePrefix, counter));
        Class<?> clazz = TestClassFinder.makeClass(pkgNameSuffix, classNamePrefix, counter);
        ClassFinder.ClassFilter notThisFilter = c -> c != clazz;
        String pkgName = TestClassFinder.makePackageName(pkgNameSuffix, counter);
        ClassFinder allClassesFinder = new ClassFinder(classLoader);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(pkgName, false);
        Assert.assertTrue((String)("Classes in " + pkgName), (allClasses.size() > 0 ? 1 : 0) != 0);
        ClassFinder notThisClassFinder = new ClassFinder(null, null, notThisFilter, classLoader);
        Set<Class<?>> notAllClasses = notThisClassFinder.findClasses(pkgName, false);
        Assert.assertFalse((boolean)TestClassFinder.contains(notAllClasses, clazz.getSimpleName()));
        Assert.assertEquals((long)(allClasses.size() - 1), (long)notAllClasses.size());
    }

    @Test
    public void testClassFinderFiltersByPathInDirs() throws Exception {
        String hardcodedThisSubdir = "hbase-common";
        ClassFinder.ResourcePathFilter notExcJarFilter = (resourcePath, isJar) -> isJar || !resourcePath.contains("hbase-common");
        String thisPackage = this.getClass().getPackage().getName();
        ClassFinder notThisClassFinder = new ClassFinder(notExcJarFilter, null, null, classLoader);
        Set<Class<?>> notAllClasses = notThisClassFinder.findClasses(thisPackage, false);
        Assert.assertFalse((boolean)notAllClasses.contains(this.getClass()));
    }

    @Test
    public void testClassFinderDefaultsToOwnPackage() throws Exception {
        ClassFinder allClassesFinder = new ClassFinder(classLoader);
        Set<Class<?>> pkgClasses = allClassesFinder.findClasses(ClassFinder.class.getPackage().getName(), false);
        Set<Class<?>> defaultClasses = allClassesFinder.findClasses(false);
        Object[] pkgClassesArray = pkgClasses.toArray();
        Object[] defaultClassesArray = defaultClasses.toArray();
        Assert.assertEquals((long)pkgClassesArray.length, (long)defaultClassesArray.length);
        MatcherAssert.assertThat((Object)pkgClassesArray, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])defaultClassesArray));
    }

    private static Class<?> makeClass(String nestedPkgSuffix, String className, long counter) throws ClassNotFoundException {
        String name = TestClassFinder.makePackageName(nestedPkgSuffix, counter) + "." + className + counter;
        return Class.forName(name, true, classLoader);
    }

    private static String makePackageName(String nestedSuffix, long counter) {
        return BASEPKG + counter + nestedSuffix;
    }

    private static FileAndPath compileTestClass(long counter, String packageNameSuffix, String classNamePrefix) throws Exception {
        classNamePrefix = classNamePrefix + counter;
        String packageName = TestClassFinder.makePackageName(packageNameSuffix, counter);
        String javaPath = basePath + classNamePrefix + ".java";
        String classPath = basePath + classNamePrefix + ".class";
        PrintStream source = new PrintStream(javaPath);
        source.println("package " + packageName + ";");
        source.println("public class " + classNamePrefix + " { public static void main(String[] args) { } };");
        source.close();
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        int result = jc.run(null, null, null, javaPath);
        Assert.assertEquals((long)0L, (long)result);
        File classFile = new File(classPath);
        Assert.assertTrue((boolean)classFile.exists());
        return new FileAndPath(packageName.replace('.', '/') + '/', classFile);
    }

    private static String packageAndLoadJar(FileAndPath ... filesInJar) throws Exception {
        String path = basePath + "jar" + jarCounter.incrementAndGet() + ".jar";
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        FileOutputStream fos = new FileOutputStream(path);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fos, manifest);
        HashSet<String> pathsInJar = new HashSet<String>();
        for (FileAndPath fileAndPath : filesInJar) {
            int ix;
            String pathToAdd = fileAndPath.path;
            while (pathsInJar.add(pathToAdd) && (ix = pathToAdd.lastIndexOf(47, pathToAdd.length() - 2)) >= 0) {
                pathToAdd = pathToAdd.substring(0, ix);
            }
        }
        for (String pathInJar : pathsInJar) {
            jarOutputStream.putNextEntry(new JarEntry(pathInJar));
            jarOutputStream.closeEntry();
        }
        for (FileAndPath fileAndPath : filesInJar) {
            File file = fileAndPath.file;
            jarOutputStream.putNextEntry(new JarEntry(fileAndPath.path + file.getName()));
            byte[] allBytes = new byte[(int)file.length()];
            FileInputStream fis = new FileInputStream(file);
            fis.read(allBytes);
            fis.close();
            jarOutputStream.write(allBytes);
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
        fos.close();
        File jarFile = new File(path);
        Assert.assertTrue((boolean)jarFile.exists());
        classLoader.addURL(jarFile.toURI().toURL());
        return jarFile.getAbsolutePath();
    }

    private static class CustomClassloader
    extends URLClassLoader {
        public CustomClassloader(URL[] urls, ClassLoader parentLoader) {
            super(urls, parentLoader);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }

    private static class FileAndPath {
        String path;
        File file;

        public FileAndPath(String path, File file) {
            this.file = file;
            this.path = path;
        }
    }
}

