/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;

class BufferingScanResultConsumer
implements AdvancedScanResultConsumer {
    private ScanMetrics scanMetrics;
    private final Queue<Result> queue = new ArrayDeque<Result>();
    private boolean finished;
    private Throwable error;

    BufferingScanResultConsumer() {
    }

    public void onScanMetricsCreated(ScanMetrics scanMetrics) {
        this.scanMetrics = scanMetrics;
    }

    public synchronized void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
        for (Result result : results) {
            this.queue.offer(result);
        }
        this.notifyAll();
    }

    public synchronized void onError(Throwable error) {
        this.finished = true;
        this.error = error;
        this.notifyAll();
    }

    public synchronized void onComplete() {
        this.finished = true;
        this.notifyAll();
    }

    public synchronized Result take() throws IOException, InterruptedException {
        while (this.queue.isEmpty()) {
            if (this.finished) {
                if (this.error != null) {
                    Throwables.propagateIfPossible((Throwable)this.error, IOException.class);
                    throw new IOException(this.error);
                }
                return null;
            }
            this.wait();
        }
        return this.queue.poll();
    }

    public ScanMetrics getScanMetrics() {
        return this.scanMetrics;
    }
}

