/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.lib.impl;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Scanner;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.client.mapreduce.impl.DelegationTokenStub;
import org.apache.accumulo.core.client.mapreduce.lib.impl.DistributedCacheHelper;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.util.DeprecationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ConfiguratorBase {
    protected static String enumToConfKey(Class<?> implementingClass, Enum<?> e) {
        return implementingClass.getSimpleName() + "." + e.getDeclaringClass().getSimpleName() + "." + StringUtils.camelize((String)e.name().toLowerCase());
    }

    protected static String enumToConfKey(Enum<?> e) {
        return e.getDeclaringClass().getSimpleName() + "." + StringUtils.camelize((String)e.name().toLowerCase());
    }

    public static void setConnectorInfo(Class<?> implementingClass, Configuration conf, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        if (ConfiguratorBase.isConnectorInfoSet(implementingClass, conf).booleanValue()) {
            throw new IllegalStateException("Connector info for " + implementingClass.getSimpleName() + " can only be set once per job");
        }
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        conf.setBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.IS_CONFIGURED), true);
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.PRINCIPAL), principal);
        if (token instanceof DelegationTokenImpl) {
            DelegationTokenImpl delToken = (DelegationTokenImpl)token;
            conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.TOKEN), TokenSource.JOB.prefix() + token.getClass().getName() + ":" + delToken.getServiceName().toString());
        } else {
            conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.TOKEN), TokenSource.INLINE.prefix() + token.getClass().getName() + ":" + Base64.getEncoder().encodeToString(AuthenticationToken.AuthenticationTokenSerializer.serialize(token)));
        }
    }

    public static void setConnectorInfo(Class<?> implementingClass, Configuration conf, String principal, String tokenFile) throws AccumuloSecurityException {
        if (ConfiguratorBase.isConnectorInfoSet(implementingClass, conf).booleanValue()) {
            throw new IllegalStateException("Connector info for " + implementingClass.getSimpleName() + " can only be set once per job");
        }
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((tokenFile != null ? 1 : 0) != 0, (Object)"tokenFile is null");
        try {
            DistributedCacheHelper.addCacheFile(new URI(tokenFile), conf);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to add tokenFile \"" + tokenFile + "\" to distributed cache.");
        }
        conf.setBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.IS_CONFIGURED), true);
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.PRINCIPAL), principal);
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.TOKEN), TokenSource.FILE.prefix() + tokenFile);
    }

    public static Boolean isConnectorInfoSet(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.IS_CONFIGURED), false);
    }

    public static String getPrincipal(Class<?> implementingClass, Configuration conf) {
        return conf.get(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.PRINCIPAL));
    }

    public static AuthenticationToken getAuthenticationToken(Class<?> implementingClass, Configuration conf) {
        String token = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.TOKEN));
        if (token == null || token.isEmpty()) {
            return null;
        }
        if (token.startsWith(TokenSource.INLINE.prefix())) {
            String[] args = token.substring(TokenSource.INLINE.prefix().length()).split(":", 2);
            if (args.length == 2) {
                return AuthenticationToken.AuthenticationTokenSerializer.deserialize(args[0], Base64.getDecoder().decode(args[1].getBytes(StandardCharsets.UTF_8)));
            }
        } else {
            String[] args;
            if (token.startsWith(TokenSource.FILE.prefix())) {
                String tokenFileName = token.substring(TokenSource.FILE.prefix().length());
                return ConfiguratorBase.getTokenFromFile(conf, ConfiguratorBase.getPrincipal(implementingClass, conf), tokenFileName);
            }
            if (token.startsWith(TokenSource.JOB.prefix()) && (args = token.substring(TokenSource.JOB.prefix().length()).split(":", 2)).length == 2) {
                String className = args[0];
                String serviceName = args[1];
                if (DelegationTokenImpl.class.getName().equals(className)) {
                    return new DelegationTokenStub(serviceName);
                }
            }
        }
        throw new IllegalStateException("Token was not properly serialized into the configuration");
    }

    public static AuthenticationToken getTokenFromFile(Configuration conf, String principal, String tokenFile) {
        FSDataInputStream in = null;
        try {
            URI[] uris = DistributedCacheHelper.getCacheFiles(conf);
            Path path = null;
            for (URI u : uris) {
                if (!u.toString().equals(tokenFile)) continue;
                path = new Path(u);
            }
            if (path == null) {
                throw new IllegalArgumentException("Couldn't find password file called \"" + tokenFile + "\" in cache.");
            }
            FileSystem fileSystem = FileSystem.get((Configuration)conf);
            in = fileSystem.open(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't open password file called \"" + tokenFile + "\".");
        }
        try (Scanner fileScanner = new Scanner((InputStream)in);){
            while (fileScanner.hasNextLine()) {
                Credentials creds = Credentials.deserialize(fileScanner.nextLine());
                if (!principal.equals(creds.getPrincipal())) continue;
                AuthenticationToken authenticationToken = creds.getToken();
                return authenticationToken;
            }
            throw new IllegalArgumentException("Couldn't find token for user \"" + principal + "\" in file \"" + tokenFile + "\"");
        }
    }

    public static void setZooKeeperInstance(Class<?> implementingClass, Configuration conf, ClientConfiguration clientConfig) {
        String key = ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.TYPE);
        if (!conf.get(key, "").isEmpty()) {
            throw new IllegalStateException("Instance info can only be set once per job; it has already been configured with " + conf.get(key));
        }
        conf.set(key, "ZooKeeperInstance");
        if (clientConfig != null) {
            conf.set(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.CLIENT_CONFIG), clientConfig.serialize());
        }
    }

    @Deprecated
    public static void setMockInstance(Class<?> implementingClass, Configuration conf, String instanceName) {
        String key = ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.TYPE);
        if (!conf.get(key, "").isEmpty()) {
            throw new IllegalStateException("Instance info can only be set once per job; it has already been configured with " + conf.get(key));
        }
        conf.set(key, "MockInstance");
        Preconditions.checkArgument((instanceName != null ? 1 : 0) != 0, (Object)"instanceName is null");
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.NAME), instanceName);
    }

    public static Instance getInstance(Class<?> implementingClass, Configuration conf) {
        String instanceType = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.TYPE), "");
        if ("MockInstance".equals(instanceType)) {
            return DeprecationUtil.makeMockInstance(conf.get(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.NAME)));
        }
        if ("ZooKeeperInstance".equals(instanceType)) {
            return new ZooKeeperInstance(ConfiguratorBase.getClientConfiguration(implementingClass, conf));
        }
        if (instanceType.isEmpty()) {
            throw new IllegalStateException("Instance has not been configured for " + implementingClass.getSimpleName());
        }
        throw new IllegalStateException("Unrecognized instance type " + instanceType);
    }

    public static ClientConfiguration getClientConfiguration(Class<?> implementingClass, Configuration conf) {
        String clientConfigString = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.CLIENT_CONFIG));
        if (null != clientConfigString) {
            return ClientConfiguration.deserialize(clientConfigString);
        }
        String instanceName = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.NAME));
        String zookeepers = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.ZOO_KEEPERS));
        ClientConfiguration clientConf = ClientConfiguration.loadDefault();
        if (null != instanceName) {
            clientConf.withInstance(instanceName);
        }
        if (null != zookeepers) {
            clientConf.withZkHosts(zookeepers);
        }
        return clientConf;
    }

    public static void setLogLevel(Class<?> implementingClass, Configuration conf, Level level) {
        Preconditions.checkArgument((level != null ? 1 : 0) != 0, (Object)"level is null");
        Logger.getLogger(implementingClass).setLevel(level);
        conf.setInt(ConfiguratorBase.enumToConfKey(implementingClass, GeneralOpts.LOG_LEVEL), level.toInt());
    }

    public static Level getLogLevel(Class<?> implementingClass, Configuration conf) {
        return Level.toLevel((int)conf.getInt(ConfiguratorBase.enumToConfKey(implementingClass, GeneralOpts.LOG_LEVEL), Level.INFO.toInt()));
    }

    public static void setVisibilityCacheSize(Configuration conf, int visibilityCacheSize) {
        conf.setInt(ConfiguratorBase.enumToConfKey(GeneralOpts.VISIBILITY_CACHE_SIZE), visibilityCacheSize);
    }

    public static int getVisibilityCacheSize(Configuration conf) {
        return conf.getInt(ConfiguratorBase.enumToConfKey(GeneralOpts.VISIBILITY_CACHE_SIZE), 1000);
    }

    public static AuthenticationToken unwrapAuthenticationToken(JobConf job, AuthenticationToken token) {
        Objects.requireNonNull(job);
        Objects.requireNonNull(token);
        if (token instanceof DelegationTokenStub) {
            DelegationTokenStub delTokenStub = (DelegationTokenStub)token;
            Token hadoopToken = job.getCredentials().getToken(new Text(delTokenStub.getServiceName()));
            AuthenticationTokenIdentifier identifier = new AuthenticationTokenIdentifier();
            try {
                identifier.readFields(new DataInputStream(new ByteArrayInputStream(hadoopToken.getIdentifier())));
                return new DelegationTokenImpl(hadoopToken.getPassword(), identifier);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not construct DelegationToken from JobConf Credentials", e);
            }
        }
        return token;
    }

    public static AuthenticationToken unwrapAuthenticationToken(JobContext job, AuthenticationToken token) {
        Objects.requireNonNull(job);
        Objects.requireNonNull(token);
        if (token instanceof DelegationTokenStub) {
            DelegationTokenStub delTokenStub = (DelegationTokenStub)token;
            Token hadoopToken = job.getCredentials().getToken(new Text(delTokenStub.getServiceName()));
            AuthenticationTokenIdentifier identifier = new AuthenticationTokenIdentifier();
            try {
                identifier.readFields(new DataInputStream(new ByteArrayInputStream(hadoopToken.getIdentifier())));
                return new DelegationTokenImpl(hadoopToken.getPassword(), identifier);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not construct DelegationToken from JobConf Credentials", e);
            }
        }
        return token;
    }

    public static enum GeneralOpts {
        LOG_LEVEL,
        VISIBILITY_CACHE_SIZE;

    }

    public static enum InstanceOpts {
        TYPE,
        NAME,
        ZOO_KEEPERS,
        CLIENT_CONFIG;

    }

    public static enum TokenSource {
        FILE,
        INLINE,
        JOB;

        private String prefix = this.name().toLowerCase() + ":";

        public String prefix() {
            return this.prefix;
        }
    }

    public static enum ConnectorInfo {
        IS_CONFIGURED,
        PRINCIPAL,
        TOKEN;

    }
}

