/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.timeline.TimelineHealth;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineStorageUtils;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemTimelineReaderImpl
extends AbstractService
implements TimelineReader {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemTimelineReaderImpl.class);
    private FileSystem fs;
    private Path rootPath;
    private Path entitiesPath;
    private static final String ENTITIES_DIR = "entities";
    private static final String TIMELINE_SERVICE_STORAGE_EXTENSION = ".thist";
    @VisibleForTesting
    static final String APP_FLOW_MAPPING_FILE = "app_flow_mapping.csv";
    public static final String TIMELINE_SERVICE_STORAGE_DIR_ROOT = "yarn.timeline-service.fs-writer.root-dir";
    private static final String STORAGE_DIR_ROOT = "timeline_service_data";
    private final CSVFormat csvFormat = CSVFormat.Builder.create().setHeader(new String[]{"APP", "USER", "FLOW", "FLOWRUN"}).build();
    private static ObjectMapper mapper = new ObjectMapper();

    public FileSystemTimelineReaderImpl() {
        super(FileSystemTimelineReaderImpl.class.getName());
    }

    @VisibleForTesting
    String getRootPath() {
        return this.rootPath.toString();
    }

    public static <T> T getTimelineRecordFromJSON(String jsonString, Class<T> clazz) throws JsonGenerationException, JsonMappingException, IOException {
        return (T)mapper.readValue(jsonString, clazz);
    }

    private static void fillFields(TimelineEntity finalEntity, TimelineEntity real, EnumSet<TimelineReader.Field> fields) {
        if (fields.contains((Object)TimelineReader.Field.ALL)) {
            fields = EnumSet.allOf(TimelineReader.Field.class);
        }
        block8: for (TimelineReader.Field field : fields) {
            switch (field) {
                case CONFIGS: {
                    finalEntity.setConfigs(real.getConfigs());
                    continue block8;
                }
                case METRICS: {
                    finalEntity.setMetrics(real.getMetrics());
                    continue block8;
                }
                case INFO: {
                    finalEntity.setInfo(real.getInfo());
                    continue block8;
                }
                case IS_RELATED_TO: {
                    finalEntity.setIsRelatedToEntities(real.getIsRelatedToEntities());
                    continue block8;
                }
                case RELATES_TO: {
                    finalEntity.setIsRelatedToEntities(real.getIsRelatedToEntities());
                    continue block8;
                }
                case EVENTS: {
                    finalEntity.setEvents(real.getEvents());
                    continue block8;
                }
            }
        }
    }

    private String getFlowRunPath(String userId, String clusterId, String flowName, Long flowRunId, String appId) throws IOException {
        if (userId != null && flowName != null && flowRunId != null) {
            return userId + File.separator + flowName + File.separator + flowRunId;
        }
        if (clusterId == null || appId == null) {
            throw new IOException("Unable to get flow info");
        }
        Path clusterIdPath = new Path(this.entitiesPath, clusterId);
        Path appFlowMappingFilePath = new Path(clusterIdPath, APP_FLOW_MAPPING_FILE);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.fs.open(appFlowMappingFilePath), Charset.forName("UTF-8")));
             CSVParser parser = new CSVParser((Reader)reader, this.csvFormat);){
            for (CSVRecord record : parser.getRecords()) {
                String applicationId;
                if (record.size() < 4 || (applicationId = record.get("APP")) != null && !applicationId.trim().isEmpty() && !applicationId.trim().equals(appId)) continue;
                String string = record.get(1).trim() + File.separator + record.get(2).trim() + File.separator + record.get(3).trim();
                return string;
            }
            parser.close();
        }
        throw new IOException("Unable to get flow info");
    }

    private static TimelineEntity createEntityToBeReturned(TimelineEntity entity, EnumSet<TimelineReader.Field> fieldsToRetrieve) {
        TimelineEntity entityToBeReturned = new TimelineEntity();
        entityToBeReturned.setIdentifier(entity.getIdentifier());
        entityToBeReturned.setCreatedTime(entity.getCreatedTime());
        if (fieldsToRetrieve != null) {
            FileSystemTimelineReaderImpl.fillFields(entityToBeReturned, entity, fieldsToRetrieve);
        }
        return entityToBeReturned;
    }

    private static boolean isTimeInRange(Long time, Long timeBegin, Long timeEnd) {
        return time >= timeBegin && time <= timeEnd;
    }

    private static void mergeEntities(TimelineEntity entity1, TimelineEntity entity2) {
        String type;
        if (entity2.getCreatedTime() != null && entity2.getCreatedTime() > 0L) {
            entity1.setCreatedTime(entity2.getCreatedTime());
        }
        for (Map.Entry configEntry : entity2.getConfigs().entrySet()) {
            entity1.addConfig((String)configEntry.getKey(), (String)configEntry.getValue());
        }
        for (Map.Entry infoEntry : entity2.getInfo().entrySet()) {
            entity1.addInfo((String)infoEntry.getKey(), infoEntry.getValue());
        }
        for (Map.Entry isRelatedToEntry : entity2.getIsRelatedToEntities().entrySet()) {
            type = (String)isRelatedToEntry.getKey();
            for (String entityId : (Set)isRelatedToEntry.getValue()) {
                entity1.addIsRelatedToEntity(type, entityId);
            }
        }
        for (Map.Entry relatesToEntry : entity2.getRelatesToEntities().entrySet()) {
            type = (String)relatesToEntry.getKey();
            for (String entityId : (Set)relatesToEntry.getValue()) {
                entity1.addRelatesToEntity(type, entityId);
            }
        }
        for (TimelineEvent event : entity2.getEvents()) {
            entity1.addEvent(event);
        }
        for (TimelineMetric metric2 : entity2.getMetrics()) {
            boolean found = false;
            for (TimelineMetric metric1 : entity1.getMetrics()) {
                if (!metric1.getId().equals(metric2.getId())) continue;
                metric1.addValues(metric2.getValues());
                found = true;
                break;
            }
            if (found) continue;
            entity1.addMetric(metric2);
        }
    }

    private static TimelineEntity readEntityFromFile(BufferedReader reader) throws IOException {
        TimelineEntity entity = FileSystemTimelineReaderImpl.getTimelineRecordFromJSON(reader.readLine(), TimelineEntity.class);
        String entityStr = "";
        while ((entityStr = reader.readLine()) != null) {
            if (entityStr.trim().isEmpty()) continue;
            TimelineEntity anotherEntity = FileSystemTimelineReaderImpl.getTimelineRecordFromJSON(entityStr, TimelineEntity.class);
            if (!entity.getId().equals(anotherEntity.getId()) || !entity.getType().equals(anotherEntity.getType())) continue;
            FileSystemTimelineReaderImpl.mergeEntities(entity, anotherEntity);
        }
        return entity;
    }

    private Set<TimelineEntity> getEntities(Path dir, String entityType, TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        RemoteIterator fileStatuses;
        TreeMap<Long, HashSet<TimelineEntity>> sortedEntities = new TreeMap<Long, HashSet<TimelineEntity>>(new Comparator<Long>(){

            @Override
            public int compare(Long l1, Long l2) {
                return l2.compareTo(l1);
            }
        });
        if (dir != null && (fileStatuses = this.fs.listFiles(dir, false)) != null) {
            while (fileStatuses.hasNext()) {
                LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatuses.next();
                Path entityFile = locatedFileStatus.getPath();
                if (!entityFile.getName().contains(TIMELINE_SERVICE_STORAGE_EXTENSION)) continue;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.fs.open(entityFile), Charset.forName("UTF-8")));
                Throwable throwable = null;
                try {
                    TimelineEntity entity = FileSystemTimelineReaderImpl.readEntityFromFile(reader);
                    if (!entity.getType().equals(entityType) || !FileSystemTimelineReaderImpl.isTimeInRange(entity.getCreatedTime(), filters.getCreatedTimeBegin(), filters.getCreatedTimeEnd()) || filters.getRelatesTo() != null && !filters.getRelatesTo().getFilterList().isEmpty() && !TimelineStorageUtils.matchRelatesTo(entity, filters.getRelatesTo()) || filters.getIsRelatedTo() != null && !filters.getIsRelatedTo().getFilterList().isEmpty() && !TimelineStorageUtils.matchIsRelatedTo(entity, filters.getIsRelatedTo()) || filters.getInfoFilters() != null && !filters.getInfoFilters().getFilterList().isEmpty() && !TimelineStorageUtils.matchInfoFilters(entity, filters.getInfoFilters()) || filters.getConfigFilters() != null && !filters.getConfigFilters().getFilterList().isEmpty() && !TimelineStorageUtils.matchConfigFilters(entity, filters.getConfigFilters()) || filters.getMetricFilters() != null && !filters.getMetricFilters().getFilterList().isEmpty() && !TimelineStorageUtils.matchMetricFilters(entity, filters.getMetricFilters()) || filters.getEventFilters() != null && !filters.getEventFilters().getFilterList().isEmpty() && !TimelineStorageUtils.matchEventFilters(entity, filters.getEventFilters())) continue;
                    TimelineEntity entityToBeReturned = FileSystemTimelineReaderImpl.createEntityToBeReturned(entity, dataToRetrieve.getFieldsToRetrieve());
                    HashSet<TimelineEntity> entitiesCreatedAtSameTime = (HashSet<TimelineEntity>)sortedEntities.get(entityToBeReturned.getCreatedTime());
                    if (entitiesCreatedAtSameTime == null) {
                        entitiesCreatedAtSameTime = new HashSet<TimelineEntity>();
                    }
                    entitiesCreatedAtSameTime.add(entityToBeReturned);
                    sortedEntities.put(entityToBeReturned.getCreatedTime(), entitiesCreatedAtSameTime);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        HashSet<TimelineEntity> entities = new HashSet<TimelineEntity>();
        long entitiesAdded = 0L;
        for (Set entitySet : sortedEntities.values()) {
            for (TimelineEntity entity : entitySet) {
                entities.add(entity);
                if (++entitiesAdded < filters.getLimit()) continue;
                return entities;
            }
        }
        return entities;
    }

    public void serviceInit(Configuration conf) throws Exception {
        String outputRoot = conf.get(TIMELINE_SERVICE_STORAGE_DIR_ROOT, conf.get("hadoop.tmp.dir") + File.separator + STORAGE_DIR_ROOT);
        this.rootPath = new Path(outputRoot);
        this.entitiesPath = new Path(this.rootPath, ENTITIES_DIR);
        this.fs = this.rootPath.getFileSystem(conf);
        super.serviceInit(conf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TimelineEntity getEntity(TimelineReaderContext context, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        String flowRunPathStr = this.getFlowRunPath(context.getUserId(), context.getClusterId(), context.getFlowName(), context.getFlowRunId(), context.getAppId());
        Path clusterIdPath = new Path(this.entitiesPath, context.getClusterId());
        Path flowRunPath = new Path(clusterIdPath, flowRunPathStr);
        Path appIdPath = new Path(flowRunPath, context.getAppId());
        Path entityTypePath = new Path(appIdPath, context.getEntityType());
        Path entityFilePath = new Path(entityTypePath, context.getEntityId() + TIMELINE_SERVICE_STORAGE_EXTENSION);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.fs.open(entityFilePath), Charset.forName("UTF-8")));){
            TimelineEntity entity = FileSystemTimelineReaderImpl.readEntityFromFile(reader);
            TimelineEntity timelineEntity = FileSystemTimelineReaderImpl.createEntityToBeReturned(entity, dataToRetrieve.getFieldsToRetrieve());
            return timelineEntity;
        }
        catch (FileNotFoundException e) {
            LOG.info("Cannot find entity {id:" + context.getEntityId() + " , type:" + context.getEntityType() + "}. Will send HTTP 404 in response.");
            return null;
        }
    }

    @Override
    public Set<TimelineEntity> getEntities(TimelineReaderContext context, TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        String flowRunPathStr = this.getFlowRunPath(context.getUserId(), context.getClusterId(), context.getFlowName(), context.getFlowRunId(), context.getAppId());
        Path clusterIdPath = new Path(this.entitiesPath, context.getClusterId());
        Path flowRunPath = new Path(clusterIdPath, flowRunPathStr);
        Path appIdPath = new Path(flowRunPath, context.getAppId());
        Path entityTypePath = new Path(appIdPath, context.getEntityType());
        return this.getEntities(entityTypePath, context.getEntityType(), filters, dataToRetrieve);
    }

    @Override
    public Set<String> getEntityTypes(TimelineReaderContext context) throws IOException {
        FileStatus[] fileStatuses;
        TreeSet<String> result = new TreeSet<String>();
        String flowRunPathStr = this.getFlowRunPath(context.getUserId(), context.getClusterId(), context.getFlowName(), context.getFlowRunId(), context.getAppId());
        if (context.getUserId() == null) {
            context.setUserId(new Path(flowRunPathStr).getParent().getParent().getName());
        }
        Path clusterIdPath = new Path(this.entitiesPath, context.getClusterId());
        Path flowRunPath = new Path(clusterIdPath, flowRunPathStr);
        Path appIdPath = new Path(flowRunPath, context.getAppId());
        for (FileStatus fileStatus : fileStatuses = this.fs.listStatus(appIdPath)) {
            if (!fileStatus.isDirectory()) continue;
            result.add(fileStatus.getPath().getName());
        }
        return result;
    }

    @Override
    public TimelineHealth getHealthStatus() {
        try {
            this.fs.exists(this.rootPath);
        }
        catch (IOException e) {
            return new TimelineHealth(TimelineHealth.TimelineHealthStatus.READER_CONNECTION_FAILURE, e.getMessage());
        }
        return new TimelineHealth(TimelineHealth.TimelineHealthStatus.RUNNING, "");
    }

    static {
        YarnJacksonJaxbJsonProvider.configObjectMapper((ObjectMapper)mapper);
    }
}

