/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class VALUELIST
extends EvalFunc<DataBag> {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final BagFactory BAG_FACTORY = BagFactory.getInstance();

    @Override
    public DataBag exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        Map m = null;
        m = (Map)input.get(0);
        if (m == null) {
            return null;
        }
        Collection c = m.values();
        NonSpillableDataBag bag = new NonSpillableDataBag(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Tuple t = TUPLE_FACTORY.newTuple(iter.next());
            bag.add(t);
        }
        return bag;
    }

    @Override
    public Schema outputSchema(Schema input) {
        Schema.FieldSchema f = null;
        Schema.FieldSchema innerFieldSchema = null;
        try {
            f = input.getField(0);
        }
        catch (FrontendException fe) {
            throw new RuntimeException(fe);
        }
        if (f.type != 100) {
            throw new RuntimeException("Expected map, received schema " + DataType.findTypeName(f.type));
        }
        Schema s = f.schema;
        if (s != null) {
            Schema.FieldSchema fs = null;
            try {
                fs = s.getField(0);
            }
            catch (FrontendException fe) {
                throw new RuntimeException(fe);
            }
            if (fs != null) {
                innerFieldSchema = new Schema.FieldSchema(null, new Schema(fs));
            }
        } else {
            innerFieldSchema = new Schema.FieldSchema(null, 50);
        }
        Schema innerSch = new Schema(innerFieldSchema);
        Schema bagSchema = null;
        try {
            bagSchema = new Schema(new Schema.FieldSchema(null, innerSch, 120));
        }
        catch (FrontendException fe) {
            throw new RuntimeException(fe);
        }
        return bagSchema;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

