/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProtoAndProcedure;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class InMemoryProcedureIterator
implements ProcedureStore.ProcedureIterator {
    private final List<ProtoAndProcedure> procs;
    private Iterator<ProtoAndProcedure> iter;
    private ProtoAndProcedure current;

    public InMemoryProcedureIterator(List<ProtoAndProcedure> procs) {
        this.procs = procs;
        this.reset();
    }

    @Override
    public void reset() {
        this.iter = this.procs.iterator();
        this.current = this.iter.hasNext() ? this.iter.next() : null;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    private void checkNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean isNextFinished() {
        this.checkNext();
        return ProcedureUtil.isFinished(this.current.getProto());
    }

    private void moveToNext() {
        this.current = this.iter.hasNext() ? this.iter.next() : null;
    }

    @Override
    public void skipNext() {
        this.checkNext();
        this.moveToNext();
    }

    @Override
    public Procedure<?> next() throws IOException {
        this.checkNext();
        Procedure<?> proc = this.current.getProcedure();
        this.moveToNext();
        return proc;
    }
}

