/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcConnection;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, SmallTests.class})
public class TestNettyRpcConnection {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyRpcConnection.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestNettyRpcConnection.class);
    private static NettyRpcClient CLIENT;
    private static NettyRpcConnection CONN;

    @BeforeClass
    public static void setUp() throws IOException {
        CLIENT = new NettyRpcClient(HBaseConfiguration.create());
        CONN = new NettyRpcConnection(CLIENT, new ConnectionId(User.getCurrent(), "test", new InetSocketAddress("localhost", 1234)));
    }

    @AfterClass
    public static void tearDown() throws IOException {
        Closeables.close((Closeable)CLIENT, (boolean)true);
    }

    @Test
    public void testPrivateMethodExecutedInEventLoop() throws IllegalAccessException {
        Assert.assertThrows(AssertionError.class, () -> {
            assert (false);
        });
        for (Method method : NettyRpcConnection.class.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getName().contains("$")) continue;
            LOG.info("checking {}", (Object)method);
            method.setAccessible(true);
            try {
                method.invoke((Object)CONN, new Object[method.getParameterCount()]);
                Assert.fail((String)"should fail with AssertionError");
            }
            catch (InvocationTargetException e) {
                MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(AssertionError.class));
            }
        }
    }
}

