/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.List;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooZap {
    private static final Logger log = LoggerFactory.getLogger(ZooZap.class);

    private static void message(String msg, Opts opts) {
        if (opts.verbose) {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(ZooZap.class.getName(), args, new Object[0]);
        if (!(opts.zapMaster || opts.zapTservers || opts.zapTracers)) {
            new JCommander((Object)opts).usage();
            return;
        }
        SiteConfiguration siteConf = SiteConfiguration.getInstance();
        if (siteConf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            SecurityUtil.serverLogin((AccumuloConfiguration)siteConf);
        }
        String iid = opts.getInstance().getInstanceID();
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        if (opts.zapMaster) {
            String masterLockPath = "/accumulo/" + iid + "/masters/lock";
            try {
                ZooZap.zapDirectory((IZooReaderWriter)zoo, masterLockPath, opts);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (opts.zapTservers) {
            String tserversPath = "/accumulo/" + iid + "/tservers";
            try {
                List children = zoo.getChildren(tserversPath);
                for (String child : children) {
                    ZooZap.message("Deleting " + tserversPath + "/" + child + " from zookeeper", opts);
                    if (opts.zapMaster) {
                        ZooReaderWriter.getInstance().recursiveDelete(tserversPath + "/" + child, ZooUtil.NodeMissingPolicy.SKIP);
                        continue;
                    }
                    String path = tserversPath + "/" + child;
                    if (zoo.getChildren(path).size() <= 0 || ZooLock.deleteLock(path, "tserver")) continue;
                    ZooZap.message("Did not delete " + tserversPath + "/" + child, opts);
                }
            }
            catch (Exception e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (opts.zapTracers) {
            String path = opts.getTraceZKPath();
            try {
                ZooZap.zapDirectory((IZooReaderWriter)zoo, path, opts);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void zapDirectory(IZooReaderWriter zoo, String path, Opts opts) throws KeeperException, InterruptedException {
        List children = zoo.getChildren(path);
        for (String child : children) {
            ZooZap.message("Deleting " + path + "/" + child + " from zookeeper", opts);
            zoo.recursiveDelete(path + "/" + child, ZooUtil.NodeMissingPolicy.SKIP);
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"-master"}, description="remove master locks")
        boolean zapMaster = false;
        @Parameter(names={"-tservers"}, description="remove tablet server locks")
        boolean zapTservers = false;
        @Parameter(names={"-tracers"}, description="remove tracer locks")
        boolean zapTracers = false;
        @Parameter(names={"-verbose"}, description="print out messages about progress")
        boolean verbose = false;

        Opts() {
        }

        String getTraceZKPath() {
            return super.getClientConfiguration().get(ClientConfiguration.ClientProperty.TRACE_ZK_PATH);
        }
    }
}

