/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.RandomVolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressModernizer
public class PreferredVolumeChooser
extends RandomVolumeChooser {
    private static final Logger log = LoggerFactory.getLogger(PreferredVolumeChooser.class);
    public static final String PREFERRED_VOLUMES_CUSTOM_KEY = "table.custom.preferredVolumes";
    private static final Predicate<String> PREFERRED_VOLUMES_FILTER = new Predicate<String>(){

        public boolean apply(String key) {
            return PreferredVolumeChooser.PREFERRED_VOLUMES_CUSTOM_KEY.equals(key);
        }
    };
    private final Map<String, Set<String>> parsedPreferredVolumes = Collections.synchronizedMap(new LRUMap(1000));
    private volatile ServerConfigurationFactory serverConfs;

    @Override
    public String choose(VolumeChooserEnvironment env, String[] options) {
        Set<String> preferred;
        if (!env.hasTableId()) {
            return super.choose(env, options);
        }
        ServerConfigurationFactory localConf = this.serverConfs;
        if (localConf == null) {
            this.serverConfs = localConf = new ServerConfigurationFactory(HdfsZooInstance.getInstance());
        }
        TableConfiguration tableConf = localConf.getTableConfiguration(env.getTableId());
        HashMap<String, String> props = new HashMap<String, String>();
        tableConf.getProperties(props, PREFERRED_VOLUMES_FILTER);
        if (props.isEmpty()) {
            log.warn("No preferred volumes specified. Defaulting to randomly choosing from instance volumes");
            return super.choose(env, options);
        }
        String volumes = (String)props.get(PREFERRED_VOLUMES_CUSTOM_KEY);
        if (log.isTraceEnabled()) {
            log.trace("In custom chooser");
            log.trace("Volumes: " + volumes);
            log.trace("TableID: " + env.getTableId());
        }
        if ((preferred = this.parsedPreferredVolumes.get(volumes)) == null) {
            preferred = new HashSet<String>(Arrays.asList(StringUtils.split((String)volumes, (char)',')));
            this.parsedPreferredVolumes.put(volumes, preferred);
        }
        ArrayList<String> filteredOptions = new ArrayList<String>(Arrays.asList(options));
        filteredOptions.retainAll(preferred);
        if (filteredOptions.isEmpty()) {
            log.warn("Preferred volumes are not instance volumes. Defaulting to randomly choosing from instance volumes");
            return super.choose(env, options);
        }
        String choice = super.choose(env, filteredOptions.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        if (log.isTraceEnabled()) {
            log.trace("Choice = " + choice);
        }
        return choice;
    }
}

