/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcChannel;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.client.ServiceCaller;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncTableImpl
implements AsyncTable<ScanResultConsumer> {
    private final AsyncTable<AdvancedScanResultConsumer> rawTable;
    private final ExecutorService pool;

    AsyncTableImpl(AsyncConnectionImpl conn, AsyncTable<AdvancedScanResultConsumer> rawTable, ExecutorService pool) {
        this.rawTable = rawTable;
        this.pool = pool;
    }

    @Override
    public TableName getName() {
        return this.rawTable.getName();
    }

    @Override
    public Configuration getConfiguration() {
        return this.rawTable.getConfiguration();
    }

    @Override
    public CompletableFuture<TableDescriptor> getDescriptor() {
        return this.wrap(this.rawTable.getDescriptor());
    }

    @Override
    public AsyncTableRegionLocator getRegionLocator() {
        return this.rawTable.getRegionLocator();
    }

    @Override
    public long getRpcTimeout(TimeUnit unit) {
        return this.rawTable.getRpcTimeout(unit);
    }

    @Override
    public long getReadRpcTimeout(TimeUnit unit) {
        return this.rawTable.getReadRpcTimeout(unit);
    }

    @Override
    public long getWriteRpcTimeout(TimeUnit unit) {
        return this.rawTable.getWriteRpcTimeout(unit);
    }

    @Override
    public long getOperationTimeout(TimeUnit unit) {
        return this.rawTable.getOperationTimeout(unit);
    }

    @Override
    public long getScanTimeout(TimeUnit unit) {
        return this.rawTable.getScanTimeout(unit);
    }

    private <T> CompletableFuture<T> wrap(CompletableFuture<T> future) {
        return FutureUtils.wrapFuture(future, (Executor)this.pool);
    }

    @Override
    public CompletableFuture<Result> get(Get get) {
        return this.wrap(this.rawTable.get(get));
    }

    @Override
    public CompletableFuture<Void> put(Put put) {
        return this.wrap(this.rawTable.put(put));
    }

    @Override
    public CompletableFuture<Void> delete(Delete delete) {
        return this.wrap(this.rawTable.delete(delete));
    }

    @Override
    public CompletableFuture<Result> append(Append append) {
        return this.wrap(this.rawTable.append(append));
    }

    @Override
    public CompletableFuture<Result> increment(Increment increment) {
        return this.wrap(this.rawTable.increment(increment));
    }

    @Override
    public AsyncTable.CheckAndMutateBuilder checkAndMutate(final byte[] row, final byte[] family) {
        return new AsyncTable.CheckAndMutateBuilder(){
            private final AsyncTable.CheckAndMutateBuilder builder;
            {
                this.builder = AsyncTableImpl.this.rawTable.checkAndMutate(row, family);
            }

            @Override
            public CompletableFuture<Boolean> thenPut(Put put) {
                return AsyncTableImpl.this.wrap(this.builder.thenPut(put));
            }

            @Override
            public CompletableFuture<Boolean> thenMutate(RowMutations mutation) {
                return AsyncTableImpl.this.wrap(this.builder.thenMutate(mutation));
            }

            @Override
            public CompletableFuture<Boolean> thenDelete(Delete delete) {
                return AsyncTableImpl.this.wrap(this.builder.thenDelete(delete));
            }

            @Override
            public AsyncTable.CheckAndMutateBuilder qualifier(byte[] qualifier) {
                this.builder.qualifier(qualifier);
                return this;
            }

            @Override
            public AsyncTable.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
                this.builder.timeRange(timeRange);
                return this;
            }

            @Override
            public AsyncTable.CheckAndMutateBuilder ifNotExists() {
                this.builder.ifNotExists();
                return this;
            }

            @Override
            public AsyncTable.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
                this.builder.ifMatches(compareOp, value);
                return this;
            }
        };
    }

    @Override
    public AsyncTable.CheckAndMutateWithFilterBuilder checkAndMutate(final byte[] row, final Filter filter) {
        return new AsyncTable.CheckAndMutateWithFilterBuilder(){
            private final AsyncTable.CheckAndMutateWithFilterBuilder builder;
            {
                this.builder = AsyncTableImpl.this.rawTable.checkAndMutate(row, filter);
            }

            @Override
            public AsyncTable.CheckAndMutateWithFilterBuilder timeRange(TimeRange timeRange) {
                this.builder.timeRange(timeRange);
                return this;
            }

            @Override
            public CompletableFuture<Boolean> thenPut(Put put) {
                return AsyncTableImpl.this.wrap(this.builder.thenPut(put));
            }

            @Override
            public CompletableFuture<Boolean> thenDelete(Delete delete) {
                return AsyncTableImpl.this.wrap(this.builder.thenDelete(delete));
            }

            @Override
            public CompletableFuture<Boolean> thenMutate(RowMutations mutation) {
                return AsyncTableImpl.this.wrap(this.builder.thenMutate(mutation));
            }
        };
    }

    @Override
    public CompletableFuture<CheckAndMutateResult> checkAndMutate(CheckAndMutate checkAndMutate) {
        return this.wrap(this.rawTable.checkAndMutate(checkAndMutate));
    }

    @Override
    public List<CompletableFuture<CheckAndMutateResult>> checkAndMutate(List<CheckAndMutate> checkAndMutates) {
        return this.rawTable.checkAndMutate(checkAndMutates).stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<Result> mutateRow(RowMutations mutation) {
        return this.wrap(this.rawTable.mutateRow(mutation));
    }

    @Override
    public CompletableFuture<List<Result>> scanAll(Scan scan) {
        return this.wrap(this.rawTable.scanAll(scan));
    }

    @Override
    public ResultScanner getScanner(Scan scan) {
        return this.rawTable.getScanner(scan);
    }

    private void scan0(Scan scan, ScanResultConsumer consumer) {
        try (ResultScanner scanner = this.getScanner(scan);){
            Result result;
            consumer.onScanMetricsCreated(scanner.getScanMetrics());
            while ((result = scanner.next()) != null && consumer.onNext(result)) {
            }
            consumer.onComplete();
        }
        catch (IOException e) {
            consumer.onError(e);
        }
    }

    @Override
    public void scan(Scan scan, ScanResultConsumer consumer) {
        this.pool.execute(() -> this.scan0(scan, consumer));
    }

    @Override
    public List<CompletableFuture<Result>> get(List<Get> gets) {
        return this.rawTable.get(gets).stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public List<CompletableFuture<Void>> put(List<Put> puts) {
        return this.rawTable.put(puts).stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public List<CompletableFuture<Void>> delete(List<Delete> deletes) {
        return this.rawTable.delete(deletes).stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public <T> List<CompletableFuture<T>> batch(List<? extends Row> actions) {
        return this.rawTable.batch(actions).stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable, byte[] row) {
        return this.wrap(this.rawTable.coprocessorService(stubMaker, callable, row));
    }

    @Override
    public <S, R> AsyncTable.CoprocessorServiceBuilder<S, R> coprocessorService(Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable, final AsyncTable.CoprocessorCallback<R> callback) {
        AsyncTable.CoprocessorCallback wrappedCallback = new AsyncTable.CoprocessorCallback<R>(){

            @Override
            public void onRegionComplete(RegionInfo region, R resp) {
                AsyncTableImpl.this.pool.execute(() -> callback.onRegionComplete(region, resp));
            }

            @Override
            public void onRegionError(RegionInfo region, Throwable error) {
                AsyncTableImpl.this.pool.execute(() -> callback.onRegionError(region, error));
            }

            @Override
            public void onComplete() {
                AsyncTableImpl.this.pool.execute(() -> callback.onComplete());
            }

            @Override
            public void onError(Throwable error) {
                AsyncTableImpl.this.pool.execute(() -> callback.onError(error));
            }
        };
        final AsyncTable.CoprocessorServiceBuilder<S, R> builder = this.rawTable.coprocessorService(stubMaker, callable, wrappedCallback);
        return new AsyncTable.CoprocessorServiceBuilder<S, R>(){

            @Override
            public AsyncTable.CoprocessorServiceBuilder<S, R> fromRow(byte[] startKey, boolean inclusive) {
                builder.fromRow(startKey, inclusive);
                return this;
            }

            @Override
            public AsyncTable.CoprocessorServiceBuilder<S, R> toRow(byte[] endKey, boolean inclusive) {
                builder.toRow(endKey, inclusive);
                return this;
            }

            @Override
            public void execute() {
                builder.execute();
            }
        };
    }
}

